/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.search;

import java.util.Arrays;
import org.alfresco.rest.core.search.SearchRequestBuilder;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.search.RestRequestQueryModel;
import org.alfresco.rest.search.SearchRequest;
import org.alfresco.rest.search.SearchResponse;
import org.alfresco.rest.v0.UserTrashcanAPI;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SearchRecordsV1CmisTests
extends BaseRMRestTest {
    private static final String SEARCH_TERM = CommonTestUtils.generateTestPrefix(SearchRecordsV1CmisTests.class);
    private SiteModel collaborationSite;
    private UserModel nonRMUser;
    private UserModel rmUser;
    private FileModel fileModel;
    private RestRequestQueryModel queryModel;
    @Autowired
    private UserTrashcanAPI userTrashcanAPI;
    @Autowired
    private RoleService roleService;

    @BeforeClass(alwaysRun=true)
    public void setupSearchRecordsV1Cmis() throws Exception {
        Step.STEP((String)"Create a collaboration site");
        this.collaborationSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        Step.STEP((String)"Create a site manager user for the collaboration site");
        this.nonRMUser = this.getDataUser().createRandomTestUser();
        this.getDataUser().addUserToSite(this.nonRMUser, this.collaborationSite, UserRole.SiteManager);
        Step.STEP((String)"Create an rm user");
        this.rmUser = this.getDataUser().createRandomTestUser();
        Step.STEP((String)"Create 10 documents and declare as records");
        int i = 0;
        while (++i <= 10) {
            this.fileModel = new FileModel(String.format("%s.%s", "Record" + SEARCH_TERM + i, FileType.TEXT_PLAIN.extension));
            this.fileModel = ((DataContent)this.dataContent.usingUser(this.nonRMUser).usingSite(this.collaborationSite)).createContent(this.fileModel);
            this.getRestAPIFactory().getFilesAPI(this.nonRMUser).declareAsRecord(this.fileModel.getNodeRefWithoutVersion());
        }
        Step.STEP((String)"Create record folder and some records ");
        RecordCategoryChild recordFolder = this.createCategoryFolderInFilePlan();
        this.roleService.assignUserPermissionsOnCategoryAndRMRole(this.rmUser, recordFolder.getId(), UserPermissions.PERMISSION_READ_RECORDS, UserRoles.ROLE_RM_MANAGER.roleId);
        int i2 = 0;
        while (++i2 <= 10) {
            this.createElectronicRecord(recordFolder.getId(), "Record" + SEARCH_TERM + i2);
        }
        this.queryModel = new RestRequestQueryModel();
        this.queryModel.setQuery("select * from cmis:document WHERE cmis:name LIKE 'Record" + SEARCH_TERM + "%'");
        this.queryModel.setLanguage("cmis");
        Utility.sleep((int)1000, (int)80000, () -> {
            SearchRequestBuilder sqlRequest = new SearchRequestBuilder().setQueryBuilder(this.queryModel).setPagingBuilder(new SearchRequestBuilder().setPagination(Integer.valueOf(100), Integer.valueOf(0))).setFieldsBuilder(Arrays.asList("id", "name"));
            SearchResponse searchResponse = this.getRestAPIFactory().getSearchAPI(null).search((SearchRequest)sqlRequest);
            Assert.assertEquals((int)searchResponse.getPagination().getTotalItems(), (int)20, (String)"Total number of items is not retrieved yet");
        });
    }

    @Test
    public void searchWhenTotalItemsReach() {
        SearchRequestBuilder sqlRequest = new SearchRequestBuilder().setQueryBuilder(this.queryModel).setPagingBuilder(new SearchRequestBuilder().setPagination(Integer.valueOf(5), Integer.valueOf(15))).setFieldsBuilder(Arrays.asList("id", "name"));
        SearchResponse searchResponse = this.getRestAPIFactory().getSearchAPI(this.rmUser).search((SearchRequest)sqlRequest);
        Assert.assertEquals((int)searchResponse.getPagination().getCount(), (int)5, (String)"Expected maxItems to be five");
        Assert.assertEquals((int)searchResponse.getPagination().getSkipCount(), (int)15, (String)"Expected skip count to be fifteen");
        Assert.assertFalse((boolean)searchResponse.getPagination().isHasMoreItems(), (String)"Expected hasMoreItems to be false");
        Assert.assertEquals((int)searchResponse.getEntries().size(), (int)5, (String)"Expected total entries to be five");
    }

    @Test
    public void searchWhenTotalItemsReachWithNonRM() {
        SearchRequestBuilder sqlRequest = new SearchRequestBuilder().setQueryBuilder(this.queryModel).setPagingBuilder(new SearchRequestBuilder().setPagination(Integer.valueOf(5), Integer.valueOf(5))).setFieldsBuilder(Arrays.asList("id", "name"));
        SearchResponse searchResponse = this.getRestAPIFactory().getSearchAPI(this.nonRMUser).search((SearchRequest)sqlRequest);
        Assert.assertEquals((int)searchResponse.getPagination().getCount(), (int)5, (String)"Expected maxItems to be five");
        Assert.assertEquals((int)searchResponse.getPagination().getSkipCount(), (int)5, (String)"Expected skip count to be five");
        Assert.assertFalse((boolean)searchResponse.getPagination().isHasMoreItems(), (String)"Expected hasMoreItems to be false");
        Assert.assertEquals((int)searchResponse.getEntries().size(), (int)5, (String)"Expected total entries to be five");
    }

    @Test
    public void searchWhenTotalItemsExceedRMUser() {
        SearchRequestBuilder sqlRequest = new SearchRequestBuilder().setQueryBuilder(this.queryModel).setPagingBuilder(new SearchRequestBuilder().setPagination(Integer.valueOf(5), Integer.valueOf(16))).setFieldsBuilder(Arrays.asList("id", "name"));
        SearchResponse searchResponse = this.getRestAPIFactory().getSearchAPI(this.rmUser).search((SearchRequest)sqlRequest);
        Assert.assertEquals((int)searchResponse.getPagination().getCount(), (int)4, (String)"Expected maxItems to be four");
        Assert.assertEquals((int)searchResponse.getPagination().getSkipCount(), (int)16, (String)"Expected skip count to be sixteen");
        Assert.assertFalse((boolean)searchResponse.getPagination().isHasMoreItems(), (String)"Expected hasMoreItems to be false");
        Assert.assertEquals((int)searchResponse.getEntries().size(), (int)4, (String)"Expected total entries to be four");
    }

    @Test
    public void searchWhenTotalItemsExceedNonRMUser() {
        SearchRequestBuilder sqlRequest = new SearchRequestBuilder().setQueryBuilder(this.queryModel).setPagingBuilder(new SearchRequestBuilder().setPagination(Integer.valueOf(5), Integer.valueOf(6))).setFieldsBuilder(Arrays.asList("id", "name"));
        SearchResponse searchResponse = this.getRestAPIFactory().getSearchAPI(this.nonRMUser).search((SearchRequest)sqlRequest);
        Assert.assertEquals((int)searchResponse.getPagination().getCount(), (int)4, (String)"Expected maxItems to be four");
        Assert.assertEquals((int)searchResponse.getPagination().getSkipCount(), (int)6, (String)"Expected skip count to be six");
        Assert.assertFalse((boolean)searchResponse.getPagination().isHasMoreItems(), (String)"Expected hasMoreItems to be false");
        Assert.assertEquals((int)searchResponse.getEntries().size(), (int)4, (String)"Expected total entries to be four");
    }

    @Test
    public void searchResultsUnderTotalItemsRMUser() {
        SearchRequestBuilder sqlRequest = new SearchRequestBuilder().setQueryBuilder(this.queryModel).setPagingBuilder(new SearchRequestBuilder().setPagination(Integer.valueOf(4), Integer.valueOf(15))).setFieldsBuilder(Arrays.asList("id", "name"));
        SearchResponse searchResponse = this.getRestAPIFactory().getSearchAPI(this.rmUser).search((SearchRequest)sqlRequest);
        Assert.assertEquals((int)searchResponse.getPagination().getCount(), (int)4, (String)"Expected maxItems to be four");
        Assert.assertEquals((int)searchResponse.getPagination().getSkipCount(), (int)15, (String)"Expected skip count to be fifteen");
        Assert.assertTrue((boolean)searchResponse.getPagination().isHasMoreItems(), (String)"Expected hasMoreItems to be true");
        Assert.assertEquals((int)searchResponse.getEntries().size(), (int)4, (String)"Expected total entries to be four");
    }

    @Test
    public void searchResultsUnderTotalItemsNonRMUser() {
        SearchRequestBuilder sqlRequest = new SearchRequestBuilder().setQueryBuilder(this.queryModel).setPagingBuilder(new SearchRequestBuilder().setPagination(Integer.valueOf(4), Integer.valueOf(5))).setFieldsBuilder(Arrays.asList("id", "name"));
        SearchResponse searchResponse = this.getRestAPIFactory().getSearchAPI(this.nonRMUser).search((SearchRequest)sqlRequest);
        Assert.assertEquals((int)searchResponse.getPagination().getCount(), (int)4, (String)"Expected maxItems to be four");
        Assert.assertEquals((int)searchResponse.getPagination().getSkipCount(), (int)5, (String)"Expected skip count to be five");
        Assert.assertTrue((boolean)searchResponse.getPagination().isHasMoreItems(), (String)"Expected hasMoreItems to be true");
        Assert.assertEquals((int)searchResponse.getEntries().size(), (int)4, (String)"Expected total entries to be four");
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.collaborationSite);
        this.userTrashcanAPI.emptyTrashcan(this.getAdminUser().getUsername(), this.getAdminUser().getPassword());
    }
}

