/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeclareInPlaceRecordTests
extends BaseRMRestTest {
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(DeclareInPlaceRecordTests.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    private UserModel testUser;
    private UserModel RmAdminUser;
    private SiteModel testSite;
    private FolderModel testFolder;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RecordsAPI recordsAPI;

    @BeforeClass(alwaysRun=true)
    public void preConditions() {
        Step.STEP((String)"Create RM Site");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create RM Admin user");
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.RM_ADMIN, this.getAdminUser().getPassword(), "Administrator");
        this.RmAdminUser = new UserModel(this.RM_ADMIN, this.getAdminUser().getPassword());
        Step.STEP((String)"Create collab_user user");
        this.testUser = this.getDataUser().createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.getDataUser().addUserToSite(this.testUser, this.testSite, UserRole.SiteContributor);
        this.testFolder = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.testUser).createFolder();
    }

    @Test
    @AlfrescoTest(jira="RM-2366")
    public void declareInplaceRecord() {
        FileModel uploadedDocHidden = ((DataContent)((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.testUser).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Record uploadedRecordHidden = this.getRestAPIFactory().getFilesAPI(this.testUser).declareAsRecord(uploadedDocHidden.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        this.recordsAPI.hideRecord(this.testUser.getUsername(), this.testUser.getPassword(), uploadedRecordHidden.getId());
        FileModel uploadedDocWithoutHidden = ((DataContent)((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.testUser).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Record uploadedRecordWithoutHidden = this.getRestAPIFactory().getFilesAPI(this.testUser).declareAsRecord(uploadedDocWithoutHidden.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertTrue((boolean)this.isRecordChildOfUnfiledContainer(uploadedRecordHidden.getId()), (String)(uploadedRecordHidden.getId() + " doesn't exist in Unfiled Records"));
        Assert.assertTrue((boolean)this.isRecordChildOfUnfiledContainer(uploadedRecordWithoutHidden.getId()), (String)(uploadedRecordWithoutHidden.getId() + " doesn't exist in Unfiled Records"));
    }

    @AfterClass(alwaysRun=true)
    public void deletePreConditions() {
        Step.STEP((String)"Delete the records created in the test");
        this.getRestAPIFactory().getUnfiledContainersAPI(this.RmAdminUser).getUnfiledContainerChildren("-unfiled-").getEntries().stream().forEach(x -> this.getRestAPIFactory().getRecordsAPI().deleteRecord(x.getEntry().getId()));
    }

    private boolean isRecordChildOfUnfiledContainer(String recordId) {
        return this.getRestAPIFactory().getUnfiledContainersAPI(this.RmAdminUser).getUnfiledContainerChildren("-unfiled-").getEntries().stream().anyMatch(c -> c.getEntry().getId().equals(recordId));
    }
}

