/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core.v0;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIUtils.class);
    public static final DateTimeFormatter ISO_INSTANT_FORMATTER = new DateTimeFormatterBuilder().appendInstant(3).toFormatter();

    private APIUtils() {
    }

    public static JSONObject convertHTTPResponseToJSON(HttpResponse httpResponse) {
        String source = null;
        try {
            source = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not extract JSON from HTTP response.", e);
        }
        LOGGER.info("Response body:\n{}", (Object)source);
        return new JSONObject(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractErrorMessageFromHttpResponse(HttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        try (JsonReader reader = null;){
            InputStream responseStream = entity.getContent();
            reader = Json.createReader((InputStream)responseStream);
            String string = reader.readObject().getString("message");
            return string;
        }
        return null;
    }
}

