/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.rest.core.v0.BaseAPI;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class ExportAPI
extends BaseAPI {
    private static final String EXPORT_API = "{0}rma/admin/export";

    public HttpResponse exportRMNode(String user, String password, int expectedStatusCode, String nodeID) {
        return this.export(user, password, expectedStatusCode, Collections.singletonList(ExportAPI.getNodeRefSpacesStore() + nodeID));
    }

    public HttpResponse exportRMNodes(String user, String password, int expectedStatusCode, List<String> nodeIDList) {
        List<String> nodeRefs = nodeIDList.stream().map(nodeID -> ExportAPI.getNodeRefSpacesStore() + nodeID).collect(Collectors.toList());
        return this.export(user, password, expectedStatusCode, nodeRefs);
    }

    public HttpResponse export(String user, String password, int expectedStatusCode, List<String> nodeRefs) {
        JSONObject requestParams = new JSONObject();
        requestParams.put("nodeRefs", (Object)new JSONArray(nodeRefs));
        return this.doPostJsonRequest(user, password, expectedStatusCode, requestParams, EXPORT_API, new String[0]);
    }
}

