/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import java.util.HashMap;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CreateNonElectronicRecordsTests
extends BaseRMRestTest {
    private RecordCategory rootCategory;
    private RecordCategoryChild recordFolder;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RecordsAPI recordsAPI;
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(CreateNonElectronicRecordsTests.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    private final String recordName = "RM-2777 record";
    private final String recordTitle = "RM-2777 record title";
    private final String recordDescription = "RM-2777 record description";

    @BeforeClass(alwaysRun=true)
    public void preConditions() {
        Step.STEP((String)"Create RM Site");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create RM Admin user");
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.RM_ADMIN, this.getAdminUser().getPassword(), "Administrator");
        Step.STEP((String)"Create root level category");
        this.rootCategory = this.createRootCategory(RandomData.getRandomName((String)"Category"));
        Step.STEP((String)"Create the record folder inside the rootCategory");
        this.recordFolder = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"Folder"));
    }

    @Test
    @AlfrescoTest(jira="RM-2777")
    public void createNonElectronicRecordTest() {
        Step.STEP((String)"Create a non-electronic record by completing some of the fields");
        HashMap<BaseAPI.RMProperty, String> properties = new HashMap<BaseAPI.RMProperty, String>();
        properties.put(BaseAPI.RMProperty.TITLE, "RM-2777 record title");
        properties.put(BaseAPI.RMProperty.DESCRIPTION, "RM-2777 record description");
        properties.put(BaseAPI.RMProperty.NAME, "RM-2777 record");
        properties.put(BaseAPI.RMProperty.PHYSICAL_SIZE, "");
        properties.put(BaseAPI.RMProperty.NUMBER_OF_COPIES, "");
        properties.put(BaseAPI.RMProperty.SHELF, "");
        properties.put(BaseAPI.RMProperty.STORAGE_LOCATION, "");
        properties.put(BaseAPI.RMProperty.BOX, "");
        properties.put(BaseAPI.RMProperty.FILE, "");
        this.recordsAPI.createNonElectronicRecord(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), properties, this.rootCategory.getName(), this.recordFolder.getName());
        Step.STEP((String)"Check the non-electronic record has been created");
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertNotNull((Object)this.recordsAPI.getRecord(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.recordFolder.getName(), "RM-2777 record"));
    }

    @AfterClass(alwaysRun=true)
    public void deletePreConditions() {
        Step.STEP((String)"Delete the created rootCategory along with corresponding record folders/records present in it");
        this.getRestAPIFactory().getRecordCategoryAPI().deleteRecordCategory(this.rootCategory.getId());
    }
}

