/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.rm.community.model.rules.RuleDefinition;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.testng.AssertJUnit;

@Component
public class RulesAPI
extends BaseAPI {
    public static final String RULES_API = "{0}node/{1}/ruleset/rules";
    public static final String RULE_API = "{0}node/{1}/ruleset/rules/{2}";
    public static final String INHERIT_RULES_API = "{0}node/{1}/ruleset/inheritrules/toggle";
    public static final String INHERIT_RULES_STATE_API = "{0}node/{1}/ruleset/inheritrules/state";
    public static final Logger LOGGER = LoggerFactory.getLogger(RulesAPI.class);

    public HttpResponse createRule(String username, String password, String containerNodeRef, RuleDefinition ruleProperties) {
        try {
            return this.doPostJsonRequest(username, password, 200, this.getRuleRequest(ruleProperties), MessageFormat.format(RULES_API, "{0}", containerNodeRef), new String[0]);
        }
        catch (JSONException error) {
            LOGGER.error("Unable to extract response parameter.", (Throwable)error);
            return null;
        }
    }

    public JSONObject updateRule(String username, String password, String containerNodeRef, RuleDefinition ruleProperties) {
        String ruleId = ruleProperties.getId();
        if (ruleId == null || ruleId.isEmpty()) {
            throw new RuntimeException("Can not update a rule without id.");
        }
        try {
            return this.doPutRequest(username, password, this.getRuleRequest(ruleProperties), MessageFormat.format(RULE_API, "{0}", containerNodeRef, ruleId), new String[0]);
        }
        catch (JSONException error) {
            LOGGER.error("Unable to extract response parameter.", (Throwable)error);
            return null;
        }
    }

    public void deleteRule(String username, String password, String containerNodeRef, String ruleId) {
        this.doDeleteRequest(username, password, MessageFormat.format(RULE_API, "{0}", containerNodeRef, ruleId), new String[0]);
        boolean success = !this.getRulesIdsSetOnContainer(username, password, containerNodeRef).contains(ruleId);
        AssertJUnit.assertTrue((String)("Rule " + ruleId + " was not deleted successfully from " + containerNodeRef), (boolean)success);
    }

    public void deleteAllRulesOnContainer(String username, String password, String containerNodeRef) {
        List<String> ruleIds = this.getRulesIdsSetOnContainer(username, password, containerNodeRef);
        for (String ruleId : ruleIds) {
            this.deleteRule(username, password, containerNodeRef, ruleId);
        }
    }

    public List<RuleDefinition> getRulesSetOnContainer(String username, String password, String containerNodeRef) {
        ArrayList<RuleDefinition> rulesDefinitions = new ArrayList<RuleDefinition>();
        JSONObject rulesJson = this.doGetRequest(username, password, MessageFormat.format(RULES_API, "{0}", containerNodeRef), new String[0]);
        if (rulesJson != null) {
            try {
                JSONArray rules = rulesJson.getJSONArray("data");
                for (int i = 0; i < rules.length(); ++i) {
                    RuleDefinition ruleDefinition = new RuleDefinition();
                    JSONObject rule = rules.getJSONObject(i);
                    ruleDefinition.id(rule.getString("id"));
                    ruleDefinition.title(rule.getString("title"));
                    ruleDefinition.description(rule.getString("description"));
                    ruleDefinition.ruleType(rule.getJSONArray("ruleType").get(0).toString());
                    ruleDefinition.disabled(rule.getBoolean("disabled"));
                    rulesDefinitions.add(ruleDefinition);
                }
            }
            catch (JSONException error) {
                LOGGER.error("Unable to parse rules.", (Throwable)error);
            }
        }
        return rulesDefinitions;
    }

    public List<String> getRulesIdsSetOnContainer(String username, String password, String containerNodeRef) {
        return this.getRulesSetOnContainer(username, password, containerNodeRef).stream().map(RuleDefinition::getId).collect(Collectors.toList());
    }

    private JSONObject getRuleRequest(RuleDefinition ruleProperties) throws JSONException {
        JSONObject requestParams = new JSONObject();
        requestParams.put("id", (Object)"");
        requestParams.put("action", (Object)this.addRulesActions(ruleProperties));
        requestParams.put("title", (Object)ruleProperties.getTitle());
        requestParams.put("description", (Object)ruleProperties.getDescription());
        requestParams.put("disabled", ruleProperties.isDisabled());
        requestParams.put("applyToChildren", ruleProperties.isApplyToChildren());
        requestParams.put("executeAsynchronously", ruleProperties.getRunInBackground());
        requestParams.put("ruleType", Arrays.asList(ruleProperties.getRuleType()));
        return requestParams;
    }

    private JSONObject addRulesActions(RuleDefinition ruleProperties) throws JSONException {
        JSONObject action = new JSONObject();
        action.put("actionDefinitionName", (Object)"composite-action");
        JSONObject conditions = new JSONObject();
        conditions.put("conditionDefinitionName", (Object)"no-condition");
        conditions.put("parameterValues", (Object)new JSONObject());
        action.put("conditions", Arrays.asList(conditions));
        action.put("actions", this.getRuleActionsList(ruleProperties));
        return action;
    }

    private List<JSONObject> getRuleActionsList(RuleDefinition ruleProperties) throws JSONException {
        ArrayList<JSONObject> ruleActionsList = new ArrayList<JSONObject>();
        for (String ruleAction : ruleProperties.getActions()) {
            JSONObject ruleActionObj = new JSONObject();
            ruleActionObj.put("actionDefinitionName", (Object)ruleAction);
            JSONObject parameters = new JSONObject();
            if (ruleProperties.getPath() != null) {
                if (ruleProperties.getCreateRecordPath() != null) {
                    parameters.put("createRecordPath", (Object)ruleProperties.getCreateRecordPath());
                }
                parameters.put("path", (Object)ruleProperties.getPath());
            }
            if (ruleProperties.getContentTitle() != null) {
                parameters.put("property", (Object)"cm:title");
                parameters.put("value", (Object)ruleProperties.getContentTitle());
                parameters.put("prop_type", (Object)"d:mltext");
            }
            if (ruleProperties.getContentDescription() != null) {
                parameters.put("property", (Object)"cm:description");
                parameters.put("value", (Object)ruleProperties.getContentDescription());
                parameters.put("prop_type", (Object)"d:mltext");
            }
            if (ruleProperties.getRejectReason() != null) {
                parameters.put("reason", (Object)ruleProperties.getRejectReason());
            }
            ruleActionObj.put("parameterValues", (Object)parameters);
            ruleActionsList.add(ruleActionObj);
        }
        return ruleActionsList;
    }

    public String getRuleIdWithTitle(String username, String password, String containerNodeRef, String title) {
        return this.getRulesSetOnContainer(username, password, containerNodeRef).stream().filter(rule -> rule.getTitle().equals(title)).findAny().get().getId();
    }

    public HttpResponse disableRulesInheritance(String username, String password, String containerNodeRef) {
        if (this.containerInheritsRulesFromParent(username, password, containerNodeRef)) {
            return this.doPostJsonRequest(username, password, 200, new JSONObject(), MessageFormat.format(INHERIT_RULES_API, "{0}", containerNodeRef), new String[0]);
        }
        return null;
    }

    public HttpResponse enableRulesInheritance(String username, String password, String containerNodeRef) {
        if (!this.containerInheritsRulesFromParent(username, password, containerNodeRef)) {
            return this.doPostJsonRequest(username, password, 200, new JSONObject(), MessageFormat.format(INHERIT_RULES_API, "{0}", containerNodeRef), new String[0]);
        }
        return null;
    }

    public boolean containerInheritsRulesFromParent(String username, String password, String containerNodeRef) throws JSONException {
        JSONObject rulesInheritanceInfo = this.doGetRequest(username, password, MessageFormat.format(INHERIT_RULES_STATE_API, "{0}", containerNodeRef), new String[0]);
        return rulesInheritanceInfo.getJSONObject("data").getBoolean("inheritRules");
    }
}

