/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import java.util.Arrays;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.CoreUtil;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CreateElectronicRecordsTests
extends BaseRMRestTest {
    private RecordCategory rootCategory;
    private UserModel updateUser;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(CreateElectronicRecordsTests.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";

    @BeforeClass(alwaysRun=true)
    public void preConditions() {
        Step.STEP((String)"Create RM Site");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create RM Admin user");
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.RM_ADMIN, this.getAdminUser().getPassword(), "Administrator");
        Step.STEP((String)"Create root level category");
        this.rootCategory = this.createRootCategory(RandomData.getRandomName((String)"Category"));
        Step.STEP((String)"Create the record folder1 inside the rootCategory");
        String recordFolder1 = this.createCategoryFolderInFilePlan().getId();
    }

    @Test
    @AlfrescoTest(jira="RM-2768")
    public void createElectronicRecordTest() throws Exception {
        String recordFolder1 = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recFolder")).getId();
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        Record electronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), recordFolder1, FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Check the electronic record has been created");
        this.assertStatusCode(HttpStatus.CREATED);
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI(this.updateUser);
        for (Record record : Arrays.asList(electronicRecord)) {
            recordsAPI.getRecord(record.getId());
            this.assertStatusCode(HttpStatus.OK);
            String newName = this.getModifiedPropertyValue(record.getName());
            String newTitle = this.getModifiedPropertyValue(record.getProperties().getTitle());
            String newDescription = this.getModifiedPropertyValue(record.getProperties().getDescription());
            recordsAPI.updateRecord(FilePlanComponentsUtil.createRecordModel(newName, newDescription, newTitle), record.getId());
            this.assertStatusCode(HttpStatus.OK);
        }
        Step.STEP((String)"Create the record folder2 inside the rootCategory");
        String recordFolder2 = this.createCategoryFolderInFilePlan().getId();
        Step.STEP((String)"Move record from folder1 to folder2");
        RestNodeModel electronicDocRestNodeModel = this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(electronicRecord.getId())).move(CoreUtil.createBodyForMoveCopy(recordFolder2));
        this.assertStatusCode(HttpStatus.OK);
    }

    private String getModifiedPropertyValue(String originalValue) {
        String MODIFIED_PREFIX = "modified_";
        return MODIFIED_PREFIX + originalValue;
    }

    @AfterClass(alwaysRun=true)
    public void deletePreConditions() {
        Step.STEP((String)"Delete the created rootCategory along with corresponding record folders/records present in it");
        this.getRestAPIFactory().getRecordCategoryAPI().deleteRecordCategory(this.rootCategory.getId());
    }
}

