/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.rm.community.utils.RMSiteUtil;
import org.alfresco.test.AlfrescoTest;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CompleteRecordTests
extends BaseRMRestTest {
    private static final Boolean COMPLETE = true;
    private static final Boolean INCOMPLETE = false;
    private static final String PARAMETERS = "include=isCompleted";

    @DataProvider(name="IncompleteRecordsMandatoryMetadataMissing")
    public Object[][] getIncompleteRecordsMandatoryMetadataMissing() {
        this.createRMSite(RMSiteUtil.createDOD5015RMSiteModel());
        return this.createAndVerifyRecordsInFolder();
    }

    @DataProvider(name="IncompleteRecordsMandatoryMetadataPresent")
    public Object[][] getIncompleteRecordsMandatoryMetadataPresent() {
        return this.createAndVerifyRecordsInFolder();
    }

    @Test(dataProvider="IncompleteRecordsMandatoryMetadataMissing", description="Cannot complete electronic and non-electronic records with mandatory metadata missing", priority=1)
    @AlfrescoTest(jira="RM-4431")
    public void completeRecordWithMandatoryMetadataMissing(Record record) {
        this.verifyRecordCompletionStatus(record, INCOMPLETE);
        this.completeRecord(record);
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
        this.verifyRecordCompletionStatus(record, INCOMPLETE);
    }

    @Test(dataProvider="IncompleteRecordsMandatoryMetadataPresent", description="Can complete electronic and non-electronic records with mandatory metadata present")
    @AlfrescoTest(jira="RM-4431")
    public void completeRecordWithMandatoryMetadataPresent(Record record) {
        this.verifyRecordCompletionStatus(record, INCOMPLETE);
        this.completeRecord(record);
        this.assertStatusCode(HttpStatus.CREATED);
        this.verifyRecordCompletionStatus(record, COMPLETE);
    }

    @Test(description="Cannot complete a document that is not a record")
    @AlfrescoTest(jira="RM-4431")
    public void completeNonRecord() {
        this.getRestAPIFactory().getRecordsAPI().completeRecord(this.createCategoryFolderInFilePlan().getId(), PARAMETERS);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test(dataProvider="IncompleteRecordsMandatoryMetadataPresent", description="Cannot complete a record that is already completed")
    @AlfrescoTest(jira="RM-4431")
    public void completeAlreadyCompletedRecord(Record record) {
        this.verifyRecordCompletionStatus(record, INCOMPLETE);
        this.completeRecord(record);
        this.assertStatusCode(HttpStatus.CREATED);
        this.verifyRecordCompletionStatus(record, COMPLETE);
        this.completeRecord(record);
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    private Record[][] createAndVerifyRecordsInFolder() {
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        String recordFolderId = this.createCategoryFolderInFilePlan().getId();
        Record electronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), recordFolderId, FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.CREATED);
        Record nonElectronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createNonElectronicRecordModel(), recordFolderId);
        this.assertStatusCode(HttpStatus.CREATED);
        return new Record[][]{{electronicRecord}, {nonElectronicRecord}};
    }

    private void verifyRecordCompletionStatus(Record record, Boolean completionStatus) {
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        Record recordModel = recordsAPI.getRecord(record.getId(), PARAMETERS);
        Assert.assertEquals((Object)recordModel.getIsCompleted(), (Object)completionStatus);
    }

    private void completeRecord(Record record) {
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        recordsAPI.completeRecord(record.getId(), PARAMETERS);
    }
}

