/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.RMAuditAPI;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.test.util.AssertionErrors;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class NonElectronicRecordAuditLogTest
extends BaseRMRestTest {
    private Optional<UserModel> rmAdmin;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RMAuditAPI auditLog;
    @Autowired
    private RecordsAPI recordApi;
    private RecordCategory category1;
    private RecordCategoryChild recordFolder1;
    private Record nonElectronicRecord;
    private Record nonElectronicRecord2;
    private static final String AUDIT_NON_ELECTRONIC_RECORD = CommonTestUtils.generateTestPrefix(NonElectronicRecordAuditLogTest.class) + "non electronic record";
    private static final String AUDIT_COMPLETE_REOPEN_NON_ELECTRONIC_RECORD = "Complete Reopen Non-Electronic Record";
    public static final String TITLE = "Title";
    public static final String DESCRIPTION = "Description";

    @BeforeClass(alwaysRun=true)
    public void nonElectronicRecordAuditLogSetup() {
        this.createRMSiteIfNotExists();
        this.rmAdmin = Optional.ofNullable(this.getDataUser().createRandomTestUser());
        this.rmRolesAndActionsAPI.assignRoleToUser(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.rmAdmin.get().getUsername(), "Administrator");
        this.auditLog.clearAuditLog(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword());
        this.category1 = this.createRootCategory(TITLE, DESCRIPTION);
        this.recordFolder1 = this.createFolder(this.category1.getId(), TITLE);
        this.nonElectronicRecord = this.createNonElectronicRecord(this.recordFolder1.getId(), AUDIT_NON_ELECTRONIC_RECORD, this.rmAdmin.get());
    }

    @Test(description="Audit log for newly filed non-electronic record")
    @AlfrescoTest(jira="RM-4303")
    public void newNonElectronicRecordAudit() {
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"File To Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("File to")));
        AssertionErrors.assertTrue((String)"Updated metadata Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Updated Metadata")));
        AssertionErrors.assertTrue((String)"Created Object Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Created Object")));
    }

    @Test(dependsOnMethods={"newNonElectronicRecordAudit"}, description="Viewing Non electronic record audit log is itself an auditable event")
    @AlfrescoTest(jira="RM-4303")
    public void nonElectronicRecordAuditIsEvent() {
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Audit View Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Audit View")));
    }

    @Test(dependsOnMethods={"nonElectronicRecordAuditIsEvent"}, description="Rename electronic record is an edit metadata event")
    @AlfrescoTest(jira="RM-4303")
    public void renameNonElectronicRecord() {
        this.auditLog.clearAuditLog(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword());
        Record renameNonElectronicRecord = FilePlanComponentsUtil.createRecordModel("edited " + this.nonElectronicRecord.getName(), "", "");
        this.getRestAPIFactory().getRecordsAPI().updateRecord(renameNonElectronicRecord, this.nonElectronicRecord.getId());
        this.assertStatusCode(HttpStatus.OK);
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Updated metadata Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Updated Metadata")));
    }

    @Test(dependsOnMethods={"newNonElectronicRecordAudit"}, description="Complete and reopen electronic record")
    @AlfrescoTest(jira="RM-4303")
    public void completeAndReopenNonElectronicRecord() {
        this.nonElectronicRecord2 = this.createNonElectronicRecord(this.recordFolder1.getId(), AUDIT_COMPLETE_REOPEN_NON_ELECTRONIC_RECORD);
        this.recordApi.completeRecord(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword(), this.nonElectronicRecord2.getName());
        try {
            Utility.sleep((int)1000, (int)30000, () -> {
                org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
                List aspects = recordsAPI.getRecord(this.nonElectronicRecord2.getId()).getAspectNames();
                AssertionErrors.assertTrue((String)"Record is not completed.", (boolean)aspects.contains("rma:declaredRecord"));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Complete Record Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Complete Record")));
        this.recordApi.reOpenRecord(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword(), this.nonElectronicRecord2.getName());
        try {
            Utility.sleep((int)1000, (int)30000, () -> {
                org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
                List aspects = recordsAPI.getRecord(this.nonElectronicRecord2.getId()).getAspectNames();
                Assert.assertFalse((boolean)aspects.contains("rma:declaredRecord"));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Reopen Record Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Reopen Record")));
    }

    @Test(dependsOnMethods={"completeAndReopenNonElectronicRecord"}, description="File electronic record's audit log as record")
    @AlfrescoTest(jira="RM-4303")
    public void fileNonElectronicRecordAuditLogAsRecord() {
        HttpResponse auditRecordHttpResponse = this.auditLog.logsAuditLogAsRecord(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword(), this.getRecordNodeRef(this.nonElectronicRecord2.getId()), this.getFolderNodeRef(this.recordFolder1.getId()));
        JSONObject auditRecordProperties = this.getAuditPropertyValues(auditRecordHttpResponse);
        Record auditRecord = this.getRestAPIFactory().getRecordsAPI().getRecord(auditRecordProperties.get("record").toString().replace("workspace://SpacesStore/", ""));
        AssertJUnit.assertTrue((boolean)auditRecordProperties.get("recordName").toString().endsWith(".html"));
        AssertJUnit.assertTrue((boolean)auditRecord.getAspectNames().stream().noneMatch(x -> x.startsWith("rma:declaredRecord")));
    }

    private String getFolderNodeRef(String folderId) {
        return "workspace://SpacesStore/" + folderId;
    }

    private String getRecordNodeRef(String recordId) {
        return "workspace/SpacesStore/" + recordId;
    }

    private JSONObject getAuditPropertyValues(HttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        String responseString = null;
        try {
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject result = new JSONObject(responseString);
        return result;
    }

    @AfterMethod
    private void closeAuditLog() {
        this.auditLog.clearAuditLog(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword());
    }

    @AfterClass(alwaysRun=true)
    private void nonElectronicRecordAuditLogCleanup() {
        this.deleteRecord(this.nonElectronicRecord.getId());
        this.deleteRecord(this.nonElectronicRecord2.getId());
        this.deleteRecordFolder(this.recordFolder1.getId());
        this.deleteRecordCategory(this.category1.getId());
        ((DataUser)this.dataUser.usingAdmin()).deleteUser(new UserModel(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword()));
    }
}

