/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.recordcategories;

import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.v0.service.DispositionScheduleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DispositionScheduleInheritanceTests
extends BaseRMRestTest {
    private static final String RETAIN_STEP = "retain";
    private static final String CUTOFF_STEP = "cutoff";
    @Autowired
    private DispositionScheduleService dispositionScheduleService;

    @AlfrescoTest(jira="MNT-19967")
    @Test
    public void testRSInheritanceOnRecordsWhenOnlyACategoryHasRS() {
        Step.STEP((String)"Create record category with retention schedule and apply it to records.");
        RecordCategory rootCategory = this.createRootCategory(RandomData.getRandomName((String)"rootCategory"));
        this.dispositionScheduleService.createCategoryRetentionSchedule(rootCategory.getName(), Boolean.valueOf(true));
        Step.STEP((String)"Add retention schedule cut off step with immediate period.");
        this.dispositionScheduleService.addCutOffImmediatelyStep(rootCategory.getName());
        Step.STEP((String)"Add retention schedule retain step with immediate period.");
        this.dispositionScheduleService.addRetainAfterPeriodStep(rootCategory.getName(), "immediately");
        Step.STEP((String)"Create a subcategory with a record folder");
        RecordCategoryChild subCategory = this.createRecordCategory(rootCategory.getId(), RandomData.getRandomName((String)"subCategory"));
        RecordCategoryChild recFolder = this.createFolder(subCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        Step.STEP((String)"Create 2 records in the record folder. Complete one of them.");
        Record elRecord = this.createElectronicRecord(recFolder.getId(), RandomData.getRandomName((String)"elRecord"));
        Record nonElRecord = this.createNonElectronicRecord(recFolder.getId(), RandomData.getRandomName((String)"nonElRecord"));
        this.getRestAPIFactory().getRecordsAPI().completeRecord(nonElRecord.getId());
        Step.STEP((String)"Check that both records inherit root category retention schedule");
        Assert.assertTrue((boolean)elRecord.getProperties().getRecordSearchHasDispositionSchedule(), (String)"rma:recordSearchHasDispositionSchedule property should be true");
        Assert.assertTrue((boolean)nonElRecord.getProperties().getRecordSearchHasDispositionSchedule(), (String)"rma:recordSearchHasDispositionSchedule property should be true");
    }

    @Test
    public void testRSInheritanceOnRecordFoldersWhenOnlyACategoryHasRS() {
        Step.STEP((String)"Create record category with retention schedule and apply it to record folders.");
        RecordCategory rootCategory = this.createRootCategory(RandomData.getRandomName((String)"rootCategory"));
        this.dispositionScheduleService.createCategoryRetentionSchedule(rootCategory.getName(), Boolean.valueOf(false));
        Step.STEP((String)"Add retention schedule cut off step with immediate period.");
        this.dispositionScheduleService.addCutOffImmediatelyStep(rootCategory.getName());
        Step.STEP((String)"Add retention schedule retain step with immediate period.");
        this.dispositionScheduleService.addRetainAfterPeriodStep(rootCategory.getName(), "immediately");
        Step.STEP((String)"Create a subcategory with a record folder");
        RecordCategoryChild subCategory = this.createRecordCategory(rootCategory.getId(), RandomData.getRandomName((String)"subCategory"));
        RecordCategoryChild recFolder = this.createFolder(subCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        Step.STEP((String)"Check that recFolder inherits root category retention schedule");
        Assert.assertTrue((boolean)recFolder.getProperties().getRecordSearchHasDispositionSchedule(), (String)"rma:recordSearchHasDispositionSchedule property should be true");
    }

    @Test
    public void testRSInheritanceOnRecordsWhen2CategoriesHaveRS() {
        Step.STEP((String)"Create record category with retention schedule and apply it to records.");
        RecordCategory rootCategory = this.createRootCategory(RandomData.getRandomName((String)"rootCategory"));
        this.dispositionScheduleService.createCategoryRetentionSchedule(rootCategory.getName(), Boolean.valueOf(true));
        Step.STEP((String)"Add retention schedule cut off step with immediate period.");
        this.dispositionScheduleService.addCutOffImmediatelyStep(rootCategory.getName());
        Step.STEP((String)"Create a subcategory with retention schedule and apply it to records.");
        RecordCategoryChild subCategory1 = this.createRecordCategory(rootCategory.getId(), RandomData.getRandomName((String)"subCategory"));
        String subcategory1Path = rootCategory.getName() + "/" + subCategory1.getName();
        this.dispositionScheduleService.createCategoryRetentionSchedule(subcategory1Path, Boolean.valueOf(true));
        Step.STEP((String)"Add retention schedule retain step with 1 day after created date.");
        this.dispositionScheduleService.addRetainAfterPeriodStep(subcategory1Path, "day|1");
        Step.STEP((String)"Create a subcategory2 in subcategory1");
        RecordCategoryChild subCategory2 = this.createRecordCategory(subCategory1.getId(), RandomData.getRandomName((String)"subCategory"));
        Step.STEP((String)"Create a record folder with 2 records. Complete one of them.");
        RecordCategoryChild recFolder = this.createFolder(subCategory2.getId(), RandomData.getRandomName((String)"recFolder"));
        Record elRecord = this.createElectronicRecord(recFolder.getId(), RandomData.getRandomName((String)"elRecord"));
        Record nonElRecord = this.createNonElectronicRecord(recFolder.getId(), RandomData.getRandomName((String)"nonElRecord"));
        this.getRestAPIFactory().getRecordsAPI().completeRecord(nonElRecord.getId());
        Step.STEP((String)"Check that both records inherit subCategory1 retention schedule");
        Assert.assertTrue((boolean)elRecord.getProperties().getRecordSearchHasDispositionSchedule(), (String)"rma:recordSearchHasDispositionSchedule property should be true for incomplete record");
        Assert.assertTrue((boolean)nonElRecord.getProperties().getRecordSearchHasDispositionSchedule(), (String)"rma:recordSearchHasDispositionSchedule property should be true for complete record");
        Assert.assertEquals((String)elRecord.getProperties().getRecordSearchDispositionActionName(), (String)RETAIN_STEP, (String)"Disposition action should be retain and not cutoff for incomplete record");
        Assert.assertEquals((String)nonElRecord.getProperties().getRecordSearchDispositionActionName(), (String)RETAIN_STEP, (String)"Disposition action should be retain and not cutoff for complete record");
    }

    @Test
    public void testRSInheritanceOnRecordFoldersWhen2CategoriesHaveRS() {
        Step.STEP((String)"Create record category with retention schedule and apply it to record folders.");
        RecordCategory rootCategory = this.createRootCategory(RandomData.getRandomName((String)"rootCategory"));
        this.dispositionScheduleService.createCategoryRetentionSchedule(rootCategory.getName(), Boolean.valueOf(false));
        Step.STEP((String)"Add retention schedule retain step with 2 days after created date.");
        this.dispositionScheduleService.addRetainAfterPeriodStep(rootCategory.getName(), "day|2");
        Step.STEP((String)"Create a subcategory with retention schedule and apply it to record folders.");
        RecordCategoryChild subCategory1 = this.createRecordCategory(rootCategory.getId(), RandomData.getRandomName((String)"subCategory"));
        String subcategory1Path = rootCategory.getName() + "/" + subCategory1.getName();
        this.dispositionScheduleService.createCategoryRetentionSchedule(subcategory1Path, Boolean.valueOf(false));
        Step.STEP((String)"Add retention schedule cut off step with immediate period.");
        this.dispositionScheduleService.addCutOffImmediatelyStep(subcategory1Path);
        Step.STEP((String)"Create a subcategory2 with a record folder in subcategory1");
        RecordCategoryChild subCategory2 = this.createRecordCategory(subCategory1.getId(), RandomData.getRandomName((String)"subCategory"));
        RecordCategoryChild recFolder = this.createFolder(subCategory2.getId(), RandomData.getRandomName((String)"recFolder"));
        Step.STEP((String)"Check that recFolder inherits subCategory1 retention schedule");
        Assert.assertTrue((boolean)recFolder.getProperties().getRecordSearchHasDispositionSchedule(), (String)"rma:recordSearchHasDispositionSchedule property should be true");
        Assert.assertEquals((String)recFolder.getProperties().getRecordSearchDispositionActionName(), (String)CUTOFF_STEP, (String)"Disposition action should be cutoff and not retain for the record folder");
    }

    @Test
    public void testMixedRSInheritanceWhenFirstParentHasRSOnRecords() {
        Step.STEP((String)"Create record category with retention schedule and apply it to folder records.");
        RecordCategory rootCategory = this.createRootCategory(RandomData.getRandomName((String)"rootCategory"));
        this.dispositionScheduleService.createCategoryRetentionSchedule(rootCategory.getName(), Boolean.valueOf(false));
        Step.STEP((String)"Add retention schedule cut off step with immediate period.");
        this.dispositionScheduleService.addCutOffImmediatelyStep(rootCategory.getName());
        Step.STEP((String)"Create a subcategory with retention schedule and apply it to records.");
        RecordCategoryChild subCategory = this.createRecordCategory(rootCategory.getId(), RandomData.getRandomName((String)"subCategory"));
        String subcategoryPath = rootCategory.getName() + "/" + subCategory.getName();
        this.dispositionScheduleService.createCategoryRetentionSchedule(subcategoryPath, Boolean.valueOf(true));
        Step.STEP((String)"Add retention schedule retain step with 1 day after created date.");
        this.dispositionScheduleService.addRetainAfterPeriodStep(subcategoryPath, "day|1");
        Step.STEP((String)"Create a record folder with 2 records. Complete one of them.");
        RecordCategoryChild recFolder = this.createFolder(subCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        Record elRecord = this.createElectronicRecord(recFolder.getId(), RandomData.getRandomName((String)"elRecord"));
        Record nonElRecord = this.createNonElectronicRecord(recFolder.getId(), RandomData.getRandomName((String)"nonElRecord"));
        this.getRestAPIFactory().getRecordsAPI().completeRecord(nonElRecord.getId());
        Step.STEP((String)"Check that both records inherit subCategory retention schedule");
        Assert.assertTrue((boolean)elRecord.getProperties().getRecordSearchHasDispositionSchedule(), (String)"rma:recordSearchHasDispositionSchedule property should be true for incomplete record");
        Assert.assertTrue((boolean)nonElRecord.getProperties().getRecordSearchHasDispositionSchedule(), (String)"rma:recordSearchHasDispositionSchedule property should be true for complete record");
        Assert.assertEquals((String)elRecord.getProperties().getRecordSearchDispositionActionName(), (String)RETAIN_STEP, (String)"Disposition action should be retain and not cutoff for incomplete record");
        Assert.assertEquals((String)nonElRecord.getProperties().getRecordSearchDispositionActionName(), (String)RETAIN_STEP, (String)"Disposition action should be retain and not cutoff for complete record");
    }

    @Test
    public void testMixedRSInheritanceWhenFirstParentHasRSOnFolders() {
        Step.STEP((String)"Create record category with retention schedule and apply it to records.");
        RecordCategory rootCategory = this.createRootCategory(RandomData.getRandomName((String)"rootCategory"));
        this.dispositionScheduleService.createCategoryRetentionSchedule(rootCategory.getName(), Boolean.valueOf(true));
        Step.STEP((String)"Add retention schedule cut off step with immediate period.");
        this.dispositionScheduleService.addCutOffImmediatelyStep(rootCategory.getName());
        Step.STEP((String)"Create a subcategory with retention schedule and apply it to record folders.");
        RecordCategoryChild subCategory = this.createRecordCategory(rootCategory.getId(), RandomData.getRandomName((String)"subCategory"));
        String subcategoryPath = rootCategory.getName() + "/" + subCategory.getName();
        this.dispositionScheduleService.createCategoryRetentionSchedule(subcategoryPath, Boolean.valueOf(false));
        Step.STEP((String)"Add retention schedule retain step with 1 day after created date.");
        this.dispositionScheduleService.addRetainAfterPeriodStep(subcategoryPath, "day|1");
        Step.STEP((String)"Create a record folder with 2 records. Complete one of them.");
        RecordCategoryChild recFolder = this.createFolder(subCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        Record elRecord = this.createElectronicRecord(recFolder.getId(), RandomData.getRandomName((String)"elRecord"));
        Record nonElRecord = this.createNonElectronicRecord(recFolder.getId(), RandomData.getRandomName((String)"nonElRecord"));
        this.getRestAPIFactory().getRecordsAPI().completeRecord(nonElRecord.getId());
        Step.STEP((String)"Check that the records don't have retention schedule");
        Assert.assertFalse((boolean)elRecord.getProperties().getRecordSearchHasDispositionSchedule(), (String)"rma:recordSearchHasDispositionSchedule property should be false for incomplete record");
        Assert.assertFalse((boolean)nonElRecord.getProperties().getRecordSearchHasDispositionSchedule(), (String)"rma:recordSearchHasDispositionSchedule property should be false for complete record");
        Step.STEP((String)"Check that recFolder inherits subCategory retention schedule");
        Assert.assertTrue((boolean)recFolder.getProperties().getRecordSearchHasDispositionSchedule(), (String)"rma:recordSearchHasDispositionSchedule property should be true");
        Assert.assertEquals((String)recFolder.getProperties().getRecordSearchDispositionActionName(), (String)RETAIN_STEP, (String)"Disposition action should be retain and not cutoff for the record folder");
    }
}

