/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import org.alfresco.dataprep.ContentService;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class ShareRecordsTest
extends BaseRMRestTest {
    @Autowired
    private RecordsAPI service;
    @Autowired
    private ContentService contentService;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(ShareRecordsTest.class);
    private final String CATEGORY = "CategoryWithSharedRecords" + this.TEST_PREFIX;
    private final String FOLDER = "FolderWithSharedRecords" + this.TEST_PREFIX;
    private final String ELECTRONIC_RECORD = "ELECTRONIC_RECORD" + this.TEST_PREFIX;
    private final String NONELECTRONIC_REC = "NON_ELECTRONIC_RECORD" + this.TEST_PREFIX;
    private RecordCategory category;
    private RecordCategoryChild recordCategoryChild;

    @Test
    @AlfrescoTest(jira="RM-5308")
    public void shareRecordViaApi() {
        this.createRMSiteIfNotExists();
        this.category = this.createRootCategory(this.CATEGORY);
        this.recordCategoryChild = this.createFolder(this.category.getId(), this.FOLDER);
        this.createNonElectronicRecord(this.recordCategoryChild.getId(), this.NONELECTRONIC_REC);
        this.createElectronicRecord(this.recordCategoryChild.getId(), this.ELECTRONIC_RECORD);
        String nodeRefRec1 = this.contentService.getNodeRefByPath(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "/Sites/rm/documentLibrary/" + this.CATEGORY + "/" + this.FOLDER + "/" + this.service.getRecordFullName(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.FOLDER, this.ELECTRONIC_RECORD));
        AssertJUnit.assertFalse((String)"The record has been succesfully shared", (boolean)((Boolean)this.service.shareDocument(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), nodeRefRec1).getKey()));
        AssertJUnit.assertEquals((String)"The API response code is not 500", (String)((String)this.service.shareDocument(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), nodeRefRec1).getValue()), (String)String.valueOf(500));
        String nodeRefRec2 = this.contentService.getNodeRefByPath(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "/Sites/rm/documentLibrary/" + this.CATEGORY + "/" + this.FOLDER + "/" + this.service.getRecordFullName(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.FOLDER, this.NONELECTRONIC_REC));
        AssertJUnit.assertFalse((String)"The record has been succesfully shared", (boolean)((Boolean)this.service.shareDocument(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), nodeRefRec2).getKey()));
        AssertJUnit.assertEquals((String)"The API response code is not 500", (String)((String)this.service.shareDocument(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), nodeRefRec2).getValue()), (String)String.valueOf(500));
    }

    @AfterClass
    public void cleanupCategory() {
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", this.recordCategoryChild.getName());
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", this.category.getName());
        this.deleteRecordCategory(this.category.getId());
    }
}

