/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.rules;

import java.util.Collections;
import java.util.Random;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.rules.ActionsOnRule;
import org.alfresco.rest.rm.community.model.rules.ConditionsOnRule;
import org.alfresco.rest.rm.community.model.rules.RuleDefinition;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.HoldsAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.rest.v0.RulesAPI;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class MoveToRuleOnFoldersTest
extends BaseRMRestTest {
    private RecordCategoryChild recordFolder2;
    private RecordCategoryChild recordFolder1;
    private String nonElectronicId;
    public Record electronicRecord;
    private String ruleType = ConditionsOnRule.UPDATE.getWhenConditionValue();
    private UserModel rmAdmin;
    public RecordCategory RecordCategoryOne;
    private RecordCategoryChild recordFolder;
    public static final String RECORD_FOLDER_ONE = "record-folder-one";
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(MoveToRuleOnFoldersTest.class);
    private final String RECORD_CATEGORY_ONE = this.TEST_PREFIX + "category";
    private final String recordName = "Test record";
    private final String recordTitle = "Test record title";
    private final String recordDescription = "Test record description";
    private Record nonElectrinicRecordModel;
    private RecordFolderAPI recordFolderAPI;
    public String title;
    public String description;
    public String box;
    public String file;
    public String shelf;
    public String storageLocation;
    public String name;
    @Autowired
    private RulesAPI rulesAPI;
    @Autowired
    private HoldsAPI holdsAPI;
    @Autowired
    private RoleService roleService;
    @Autowired
    public RecordsAPI recordsAPI;

    @BeforeClass(alwaysRun=true)
    public void precondition() {
        this.createRMSiteIfNotExists();
        this.rmAdmin = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_ADMIN.roleId);
        this.RecordCategoryOne = this.createRootCategory(this.RECORD_CATEGORY_ONE);
        this.recordFolder1 = this.createRecordFolder(this.RecordCategoryOne.getId(), RandomData.getRandomName((String)"recFolder"));
        this.recordFolder2 = this.createFolder(this.getAdminUser(), this.RecordCategoryOne.getId(), RandomData.getRandomName((String)"recFolder"));
        Step.STEP((String)"CREATE ELECTRONIC RECORD");
        this.recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        this.electronicRecord = this.recordFolderAPI.createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), this.recordFolder1.getId(), FilePlanComponentsUtil.getFile("money.JPG"));
        Step.STEP((String)"Check the electronic record has been created");
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Create a non-electronic record by completing some of the fields");
        this.title = "Title " + RandomData.getRandomAlphanumeric();
        this.description = "Description " + RandomData.getRandomAlphanumeric();
        this.box = "Box " + RandomData.getRandomAlphanumeric();
        this.file = "File " + RandomData.getRandomAlphanumeric();
        this.shelf = "Shelf " + RandomData.getRandomAlphanumeric();
        this.storageLocation = "Storage Location " + RandomData.getRandomAlphanumeric();
        this.name = "Record " + RandomData.getRandomAlphanumeric();
        Random random = new Random();
        Integer numberOfCopies = random.nextInt(Integer.MAX_VALUE);
        Integer physicalSize = random.nextInt(Integer.MAX_VALUE);
        this.nonElectrinicRecordModel = FilePlanComponentsUtil.createFullNonElectronicRecordModel(this.name, this.title, this.description, this.box, this.file, this.shelf, this.storageLocation, numberOfCopies, physicalSize);
        this.nonElectronicId = this.recordFolderAPI.createRecord(this.nonElectrinicRecordModel, this.recordFolder1.getId()).getId();
        Step.STEP((String)"Check the non-electronic record has been created");
        this.assertStatusCode(HttpStatus.CREATED);
    }

    @Test
    public void MoveToRuleFoldersTest() {
        String CatName = this.RecordCategoryOne.getName();
        String folder2name = this.recordFolder2.getName();
        String recfolder2_path = "/" + CatName + "/" + folder2name;
        Step.STEP((String)"create a rule MOVE_TO for folder 1");
        RuleDefinition ruleDefinition = RuleDefinition.createNewRule().title("name").description("description1").runInBackground(true).title(this.title).actions(Collections.singletonList(ActionsOnRule.MOVE_TO.getActionValue())).ruleType(this.ruleType).path(recfolder2_path);
        this.rulesAPI.createRule(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "workspace/SpacesStore/" + this.recordFolder1.getId(), ruleDefinition);
        Step.STEP((String)"Update metadata for Non-Electronic Record");
        this.updateRecordMetadata();
        Step.STEP((String)"Delete ELECTRONIC AND NON-ELECTRONIC RECORDS IN FOLDER 2");
        org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        recordsAPI.deleteRecord(this.electronicRecord.getId());
        this.assertStatusCode(HttpStatus.NO_CONTENT);
        recordsAPI.deleteRecord(this.nonElectronicId);
        this.assertStatusCode(HttpStatus.NO_CONTENT);
        Step.STEP((String)"RULE CREATION FOR FOLDER 1 WITHOUT RUNNING IN BACKGROUND");
        RuleDefinition ruleDefinition_notinbackground = RuleDefinition.createNewRule().title("name").description("description1").runInBackground(false).title(this.title).actions(Collections.singletonList(ActionsOnRule.MOVE_TO.getActionValue())).ruleType(this.ruleType).path(recfolder2_path);
        this.rulesAPI.createRule(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "workspace/SpacesStore/" + this.recordFolder1.getId(), ruleDefinition);
        Step.STEP((String)"CREATE ELECTRONIC AND NON-ELECTRONIC RECORDS");
        this.electronicRecord = this.recordFolderAPI.createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), this.recordFolder1.getId(), FilePlanComponentsUtil.getFile("money.JPG"));
        Step.STEP((String)"Check the electronic record has been created");
        this.assertStatusCode(HttpStatus.CREATED);
        this.nonElectronicId = this.recordFolderAPI.createRecord(this.nonElectrinicRecordModel, this.recordFolder1.getId()).getId();
        Step.STEP((String)"Check the non-electronic record has been created");
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"UPDATE METADATA");
        this.updateRecordMetadata();
        Step.STEP((String)"CHECK IF ELECTRONIC AND NON-ELECTRONIC RECORDS MOVED  TO FOLDER2");
        this.updateRecordMetadata();
    }

    @AfterClass(alwaysRun=true)
    public void cleanMoveToRuleOnFoldersTest() {
        this.deleteRecordCategory(this.RecordCategoryOne.getId());
        this.getDataUser().deleteUser(this.rmAdmin);
    }

    private String getModifiedPropertyValue(String originalValue) {
        String MODIFIED_PREFIX = "modified_";
        return MODIFIED_PREFIX + originalValue;
    }

    private void updateRecordMetadata() {
        Step.STEP((String)"Update metadata for Non-Electronic Record");
        org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        Record nonelecrecord = recordsAPI.getRecord(this.nonElectronicId);
        String nonelecnewName = this.getModifiedPropertyValue(this.nonElectrinicRecordModel.getName());
        String nonelecnewTitle = this.getModifiedPropertyValue(this.nonElectrinicRecordModel.getProperties().getTitle());
        String nonelecnewDescription = this.getModifiedPropertyValue(this.nonElectrinicRecordModel.getProperties().getDescription());
        recordsAPI.updateRecord(FilePlanComponentsUtil.createRecordModel(nonelecnewName, nonelecnewDescription, nonelecnewTitle), nonelecrecord.getId());
        this.assertStatusCode(HttpStatus.OK);
        Step.STEP((String)"Update metadata for Electronic Record");
        Record elecrecord = recordsAPI.getRecord(this.electronicRecord.getId());
        String elecnewName = this.getModifiedPropertyValue(this.electronicRecord.getName());
        String elecnewTitle = this.getModifiedPropertyValue(this.electronicRecord.getProperties().getTitle());
        String elecnewDescription = this.getModifiedPropertyValue(this.electronicRecord.getProperties().getDescription());
        recordsAPI.updateRecord(FilePlanComponentsUtil.createRecordModel(elecnewName, elecnewDescription, elecnewTitle), elecrecord.getId());
        this.assertStatusCode(HttpStatus.OK);
    }
}

