/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.hold;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.HoldsAPI;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@AlfrescoTest(jira="RM-6874, RM-6873")
public class RemoveFromHoldsTests
extends BaseRMRestTest {
    private static final String HOLD_ONE = "HOLD_ONE" + CommonTestUtils.generateTestPrefix(RemoveFromHoldsTests.class);
    private static final String HOLD_TWO = "HOLD_TWO" + CommonTestUtils.generateTestPrefix(RemoveFromHoldsTests.class);
    private static final String ACCESS_DENIED_ERROR_MESSAGE = "Access Denied.  You do not have the appropriate permissions to perform this operation.";
    private SiteModel testSite;
    private SiteModel privateSite;
    private String holdNodeRefOne;
    private String holdNodeRefTwo;
    private FileModel contentHeld;
    private FileModel contentAddToManyHolds;
    private final Set<UserModel> usersToBeClean = new HashSet<UserModel>();
    private final Set<String> nodesToBeClean = new HashSet<String>();
    @Autowired
    private HoldsAPI holdsAPI;
    @Autowired
    private RoleService roleService;

    @BeforeClass(alwaysRun=true)
    public void preconditionForRemoveContentFromHold() {
        Step.STEP((String)"Create two holds.");
        this.holdNodeRefOne = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getUsername(), HOLD_ONE, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        this.holdNodeRefTwo = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getUsername(), HOLD_TWO, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        Step.STEP((String)"Create test files.");
        this.testSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.contentHeld = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.contentAddToManyHolds = ((DataContent)this.dataContent.usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Add content to the holds.");
        this.holdsAPI.addItemToHold(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.contentHeld.getNodeRefWithoutVersion(), HOLD_ONE);
        this.holdsAPI.addItemsToHolds(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), Collections.singletonList(this.contentAddToManyHolds.getNodeRefWithoutVersion()), Arrays.asList(HOLD_ONE, HOLD_TWO));
    }

    @DataProvider(name="validNodesToRemoveFromHold")
    public Object[][] getValidNodesToRemoveFromHold() {
        RecordCategoryChild recordFolder = this.createCategoryFolderInFilePlan();
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        this.nodesToBeClean.add(recordFolder.getParentId());
        Record electronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), recordFolder.getId(), FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.CREATED);
        Record nonElectronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createNonElectronicRecordModel(), recordFolder.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        RecordCategoryChild folderToHeld = this.createCategoryFolderInFilePlan();
        this.nodesToBeClean.add(folderToHeld.getParentId());
        this.holdsAPI.addItemsToHolds(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), Arrays.asList(electronicRecord.getId(), nonElectronicRecord.getId(), folderToHeld.getId()), Collections.singletonList(HOLD_ONE));
        return new String[][]{{folderToHeld.getId()}, {electronicRecord.getId()}, {nonElectronicRecord.getId()}, {this.contentHeld.getNodeRefWithoutVersion()}};
    }

    @Test(dataProvider="validNodesToRemoveFromHold")
    public void removeContentFromHold(String nodeId) throws Exception {
        Step.STEP((String)"Remove node from hold");
        this.holdsAPI.removeItemFromHold(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), nodeId, HOLD_ONE);
        Step.STEP((String)"Check the node is not held");
        Assert.assertFalse((boolean)this.hasAspect(nodeId, "rma:frozen"));
        Step.STEP((String)"Check node is not in any hold");
        List holdEntries = this.holdsAPI.getHolds(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), nodeId, Boolean.valueOf(true), null);
        Assert.assertTrue((boolean)holdEntries.isEmpty(), (String)"Content held is still added to a hold.");
    }

    @Test
    public void removeContentAddedToManyHolds() throws Exception {
        Step.STEP((String)"Remove content from hold. ");
        this.holdsAPI.removeItemFromHold(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.contentAddToManyHolds.getNodeRefWithoutVersion(), HOLD_ONE);
        Step.STEP((String)"Check the content is held. ");
        Assert.assertTrue((boolean)this.hasAspect(this.contentAddToManyHolds.getNodeRefWithoutVersion(), "rma:frozen"));
        Step.STEP((String)"Check node is in hold HOLD_TWO. ");
        List holdEntries = this.holdsAPI.getHolds(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.contentAddToManyHolds.getNodeRefWithoutVersion(), Boolean.valueOf(true), null);
        Assert.assertFalse((boolean)holdEntries.isEmpty(), (String)"Content held is not held after removing from one hold.");
        Assert.assertTrue((boolean)holdEntries.stream().anyMatch(holdEntry -> holdEntry.getName().contains(HOLD_TWO)), (String)"Content held is not held after removing from one hold.");
    }

    @DataProvider(name="userWithoutPermissionForRemoveFromHold")
    public Object[][] getUserWithoutPermissionForAddToHold() {
        RecordCategoryChild recordFolder = this.createCategoryFolderInFilePlan();
        this.nodesToBeClean.add(recordFolder.getParentId());
        UserModel user = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_MANAGER.roleId);
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(this.holdNodeRefOne, user, UserPermissions.PERMISSION_FILING);
        FileModel contentNoHoldPerm = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        FileModel contentNoHoldCap = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        FileModel privateFile = ((DataContent)this.dataContent.usingAdmin().usingSite(this.privateSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.holdsAPI.addItemsToHolds(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), Arrays.asList(recordFolder.getId(), contentNoHoldCap.getNodeRefWithoutVersion(), contentNoHoldPerm.getNodeRefWithoutVersion(), privateFile.getNodeRefWithoutVersion()), Collections.singletonList(HOLD_ONE));
        return new Object[][]{{this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, this.holdNodeRefOne, UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_READ_RECORDS), contentNoHoldPerm.getNodeRefWithoutVersion()}, {this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, this.holdNodeRefOne, UserRoles.ROLE_RM_POWER_USER, UserPermissions.PERMISSION_FILING), contentNoHoldCap.getNodeRefWithoutVersion()}, {user, recordFolder.getId()}, {user, privateFile.getNodeRefWithoutVersion()}};
    }

    @Test(dataProvider="userWithoutPermissionForRemoveFromHold")
    public void removeFromHoldWithUserWithoutPermission(UserModel userModel, String nodeIdToBeRemoved) throws Exception {
        Step.STEP((String)"Update the list of users to be deleted after running the tests");
        this.usersToBeClean.add(userModel);
        Step.STEP((String)"Remove node from hold with user without right permission or capability");
        String responseNoHoldPermission = this.holdsAPI.removeFromHoldAndGetMessage(userModel.getUsername(), userModel.getPassword(), 500, nodeIdToBeRemoved, this.holdNodeRefOne);
        Assert.assertTrue((boolean)responseNoHoldPermission.contains(ACCESS_DENIED_ERROR_MESSAGE));
        Step.STEP((String)"Check node is frozen.");
        Assert.assertTrue((boolean)this.hasAspect(nodeIdToBeRemoved, "rma:frozen"));
    }

    @DataProvider(name="userWithPermissionForRemoveFromHold")
    public Object[][] getUserWithPermissionForAddToHold() {
        RecordCategoryChild recordFolder = this.createCategoryFolderInFilePlan();
        this.nodesToBeClean.add(recordFolder.getParentId());
        UserModel user = this.roleService.createUserWithRMRoleAndRMNodePermission(UserRoles.ROLE_RM_MANAGER.roleId, recordFolder.getId(), UserPermissions.PERMISSION_READ_RECORDS);
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(this.holdNodeRefOne, user, UserPermissions.PERMISSION_FILING);
        FileModel contentPermission = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.holdsAPI.addItemsToHolds(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), Arrays.asList(recordFolder.getId(), contentPermission.getNodeRefWithoutVersion()), Collections.singletonList(HOLD_ONE));
        return new Object[][]{{this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteConsumer, this.holdNodeRefOne, UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING), contentPermission.getNodeRefWithoutVersion()}, {user, recordFolder.getId()}};
    }

    @Test(dataProvider="userWithPermissionForRemoveFromHold")
    public void removeFromHoldWithUserWithPermission(UserModel userModel, String nodeIdToBeRemoved) throws Exception {
        Step.STEP((String)"Update the list of users to be deleted after running the tests");
        this.usersToBeClean.add(userModel);
        Step.STEP((String)"Remove node from hold with user with right permission and capability");
        this.holdsAPI.removeItemFromHold(userModel.getUsername(), userModel.getPassword(), nodeIdToBeRemoved, HOLD_ONE);
        Step.STEP((String)"Check node is not frozen.");
        Assert.assertFalse((boolean)this.hasAspect(nodeIdToBeRemoved, "rma:frozen"));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpRemoveContentFromHold() {
        this.holdsAPI.deleteHold(this.getAdminUser(), this.holdNodeRefOne);
        this.holdsAPI.deleteHold(this.getAdminUser(), this.holdNodeRefTwo);
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.testSite);
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.privateSite);
        this.usersToBeClean.forEach(user -> ((DataUser)this.getDataUser().usingAdmin()).deleteUser(user));
        this.nodesToBeClean.forEach(category -> this.deleteRecordCategory((String)category));
    }
}

