/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.recordfolders;

import java.util.Arrays;
import java.util.Random;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.record.RecordProperties;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildProperties;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledContainerAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledRecordFolderAPI;
import org.alfresco.rest.rm.community.util.PojoUtility;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NonElectronicRecordTests
extends BaseRMRestTest {
    @Test(dataProvider="validRootContainers", description="Non-electronic records can be created in valid containers")
    public void canCreateInValidContainers(String folderId, String type) throws Exception {
        String nonElectronicId;
        this.logger.info((Object)("Root container:\n" + PojoUtility.toJson((Object)folderId)));
        String title = "Title " + RandomData.getRandomAlphanumeric();
        String description = "Description " + RandomData.getRandomAlphanumeric();
        String box = "Box " + RandomData.getRandomAlphanumeric();
        String file = "File " + RandomData.getRandomAlphanumeric();
        String shelf = "Shelf " + RandomData.getRandomAlphanumeric();
        String storageLocation = "Storage Location " + RandomData.getRandomAlphanumeric();
        String name = "Record " + RandomData.getRandomAlphanumeric();
        Random random = new Random();
        Integer numberOfCopies = random.nextInt(Integer.MAX_VALUE);
        Integer physicalSize = random.nextInt(Integer.MAX_VALUE);
        if ("rma:recordFolder".equalsIgnoreCase(type)) {
            RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
            Assert.assertFalse((boolean)recordFolderAPI.getRecordFolder(folderId).getProperties().getIsClosed());
            Record nonElectrinicRecordModel = FilePlanComponentsUtil.createFullNonElectronicRecordModel(name, title, description, box, file, shelf, storageLocation, numberOfCopies, physicalSize);
            nonElectronicId = recordFolderAPI.createRecord(nonElectrinicRecordModel, folderId).getId();
        } else if ("rma:unfiledRecordContainer".equalsIgnoreCase(type)) {
            nonElectrinicRecordModel = FilePlanComponentsUtil.createFullNonElectronicUnfiledContainerChildRecordModel(name, title, description, box, file, shelf, storageLocation, numberOfCopies, physicalSize);
            UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
            nonElectronicId = unfiledContainersAPI.createUnfiledContainerChild(nonElectrinicRecordModel, folderId).getId();
        } else if ("rma:unfiledRecordFolder".equalsIgnoreCase(type)) {
            nonElectrinicRecordModel = FilePlanComponentsUtil.createFullNonElectronicUnfiledContainerChildRecordModel(name, title, description, box, file, shelf, storageLocation, numberOfCopies, physicalSize);
            UnfiledRecordFolderAPI unfiledRecordFoldersAPI = this.getRestAPIFactory().getUnfiledRecordFoldersAPI();
            nonElectronicId = unfiledRecordFoldersAPI.createUnfiledRecordFolderChild(nonElectrinicRecordModel, folderId).getId();
        } else {
            throw new Exception("Unsuported type = " + type);
        }
        this.assertStatusCode(HttpStatus.CREATED);
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        Record nonElectronicRecord = recordsAPI.getRecord(nonElectronicId);
        FilePlanComponentsUtil.verifyFullNonElectronicRecord(nonElectronicRecord, name, title, description, box, file, shelf, storageLocation, numberOfCopies, physicalSize);
    }

    @Test(description="Non-electronic record can't be created in closed record folder")
    public void cantCreateInClosedFolder() {
        RecordCategoryChild recordFolder = this.createCategoryFolderInFilePlan();
        Assert.assertFalse((boolean)recordFolder.getProperties().getIsClosed());
        this.closeFolder(recordFolder.getId());
        this.getRestAPIFactory().getRecordFolderAPI().createRecord(FilePlanComponentsUtil.createNonElectronicRecordModel(), recordFolder.getId());
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(dataProvider="validRootContainers", description="Non-electronic record can only be created if all mandatory properties are given")
    public void allMandatoryPropertiesRequired(String folderId, String type) {
        this.logger.info((Object)("Root container:\n" + PojoUtility.toJson((Object)folderId)));
        if (type.equals("rma:recordFolder")) {
            RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
            Assert.assertFalse((boolean)recordFolderAPI.getRecordFolder(folderId).getProperties().getIsClosed());
            Record noNameOrTitle = Record.builder().nodeType("rma:nonElectronicDocument").build();
            Record titleOnly = Record.builder().nodeType("rma:nonElectronicDocument").properties(RecordProperties.builder().title("Title " + RandomData.getRandomAlphanumeric()).build()).build();
            Arrays.asList(noNameOrTitle, titleOnly).forEach(c -> {
                this.logger.info((Object)("Creating non-electronic record with body:\n" + PojoUtility.toJson((Object)c)));
                this.getRestAPIFactory().getRecordFolderAPI().createRecord(c, folderId);
                this.assertStatusCode(HttpStatus.BAD_REQUEST);
            });
        } else if ("rma:unfiledRecordContainer".equalsIgnoreCase(type)) {
            UnfiledContainerChild noNameOrTitle = UnfiledContainerChild.builder().nodeType("rma:nonElectronicDocument").build();
            UnfiledContainerChild titleOnly = UnfiledContainerChild.builder().nodeType("rma:nonElectronicDocument").properties(UnfiledContainerChildProperties.builder().title("Title " + RandomData.getRandomAlphanumeric()).build()).build();
            Arrays.asList(noNameOrTitle, titleOnly).forEach(c -> {
                this.logger.info((Object)("Creating non-electronic record with body:\n" + PojoUtility.toJson((Object)c)));
                this.getRestAPIFactory().getUnfiledContainersAPI().createUnfiledContainerChild(c, folderId);
                this.assertStatusCode(HttpStatus.BAD_REQUEST);
            });
        } else {
            UnfiledContainerChild noNameOrTitle = UnfiledContainerChild.builder().nodeType("rma:nonElectronicDocument").build();
            UnfiledContainerChild titleOnly = UnfiledContainerChild.builder().nodeType("rma:nonElectronicDocument").properties(UnfiledContainerChildProperties.builder().title("Title " + RandomData.getRandomAlphanumeric()).build()).build();
            Arrays.asList(noNameOrTitle, titleOnly).forEach(c -> {
                this.logger.info((Object)("Creating non-electronic record with body:\n" + PojoUtility.toJson((Object)c)));
                this.getRestAPIFactory().getUnfiledRecordFoldersAPI().createUnfiledRecordFolderChild(c, folderId);
                this.assertStatusCode(HttpStatus.BAD_REQUEST);
            });
        }
    }

    @Test(dataProvider="validRootContainers", description="Non-electronic record can't be created if user doesn't have RM privileges")
    public void cantCreateIfNoRmPrivileges(String folderId, String type) {
        UserModel user = this.createSiteManager("zzzuser");
        if (type.equals("rma:recordFolder")) {
            Record recordModel = Record.builder().properties(RecordProperties.builder().description("Description").title("Title").build()).name("Record Name").nodeType("rma:nonElectronicDocument").build();
            this.getRestAPIFactory().getRecordFolderAPI(user).createRecord(recordModel, folderId);
        } else if ("rma:unfiledRecordContainer".equalsIgnoreCase(type)) {
            UnfiledContainerChild recordModel = UnfiledContainerChild.builder().properties(UnfiledContainerChildProperties.builder().description("Description").title("Title").build()).name("Record Name").nodeType("rma:nonElectronicDocument").build();
            this.getRestAPIFactory().getUnfiledContainersAPI(user).createUnfiledContainerChild(recordModel, folderId);
        } else {
            UnfiledContainerChild recordModel = UnfiledContainerChild.builder().properties(UnfiledContainerChildProperties.builder().description("Description").title("Title").build()).name("Record Name").nodeType("rma:nonElectronicDocument").build();
            this.getRestAPIFactory().getUnfiledRecordFoldersAPI(user).createUnfiledRecordFolderChild(recordModel, folderId);
        }
        this.assertStatusCode(HttpStatus.FORBIDDEN);
    }

    private UserModel createSiteManager(String userName) {
        String siteId = this.getRestAPIFactory().getRMSiteAPI().getSite().getId();
        UserModel user = new UserModel(userName, userName);
        if (!this.getDataUser().isUserInRepo(userName)) {
            user = this.getDataUser().createUser(userName, userName);
            this.getDataUser().addUserToSite(user, new SiteModel(siteId), UserRole.SiteManager);
        }
        return user;
    }
}

