/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.recordfolders;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.common.ReviewPeriod;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.record.RecordProperties;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolder;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolderCollection;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolderProperties;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.Bug;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class RecordFolderTests
extends BaseRMRestTest {
    public static final String ELECTRONIC_RECORD_NAME = "Record electronic" + RandomData.getRandomAlphanumeric();
    public static final String NONELECTRONIC_RECORD_NAME = "Record nonelectronic" + RandomData.getRandomAlphanumeric();
    public static final String RECORD_CATEGORY_NAME = "CATEGORY NAME" + RandomData.getRandomAlphanumeric();
    private RecordCategory rootCategory;

    @BeforeClass(alwaysRun=true)
    public void preconditionRecordFolderTests() {
        this.rootCategory = this.createRootCategory(RECORD_CATEGORY_NAME);
    }

    @DataProvider
    public static Object[][] childrenNotAllowedForFolder() {
        return new String[][]{{"rma:filePlan"}, {"rma:transferContainer"}, {"rma:unfiledRecordContainer"}, {"rma:unfiledRecordFolder"}, {"rma:transfer"}, {"rma:recordCategory"}, {"cm:folder"}};
    }

    @DataProvider
    public Object[][] getInvalidNodesForRecordFolders() {
        return new String[][]{{this.getRestAPIFactory().getFilePlansAPI().getFilePlan("-filePlan-").getId()}, {this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainer("-unfiled-").getId()}, {this.getRestAPIFactory().getTransferContainerAPI().getTransferContainer("-transfers-").getId()}, {this.rootCategory.getId()}, {this.createUnfiledContainerChild("-unfiled-", "Unfiled Folder " + RandomData.getRandomAlphanumeric(), "rma:unfiledRecordFolder").getId()}, {this.createUnfiledContainerChild("-unfiled-", "Unfiled Record " + RandomData.getRandomAlphanumeric(), "cm:content").getId()}};
    }

    @Test(enabled=false, description="Create invalid types as children for a record folder", dataProvider="childrenNotAllowedForFolder")
    public void createInvalidChildrenForFolder(String nodeType) {
        RecordCategoryChild folder = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        Record record = Record.builder().name(ELECTRONIC_RECORD_NAME).nodeType(nodeType).build();
        this.getRestAPIFactory().getRecordFolderAPI().createRecord(record, folder.getId());
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(description="Check the details of a record folder")
    public void checkRecordFolderDetails() {
        RecordCategoryChild recordCategoryChild = this.createRecordFolder(this.rootCategory.getId(), TestData.RECORD_FOLDER_NAME);
        RecordFolder recordFolder = this.getRestAPIFactory().getRecordFolderAPI().getRecordFolder(recordCategoryChild.getId(), "include=isClosed");
        Assert.assertEquals((String)recordFolder.getNodeType(), (String)"rma:recordFolder");
        Assert.assertEquals((String)recordFolder.getName(), (String)TestData.RECORD_FOLDER_NAME);
        Assert.assertEquals((String)recordFolder.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
        Assert.assertEquals((String)recordFolder.getModifiedByUser().getId(), (String)this.getAdminUser().getUsername());
        Assert.assertEquals((String)recordFolder.getProperties().getTitle(), (String)("Title for " + TestData.RECORD_FOLDER_NAME));
        Assert.assertNotNull((Object)recordFolder.getProperties().getIdentifier(), (String)"The record folder doesn't have a identifier");
        Assert.assertFalse((boolean)recordFolder.getProperties().getVitalRecordIndicator(), (String)"The record folder has the vital record identifier");
        Assert.assertFalse((boolean)recordFolder.getProperties().getIsClosed(), (String)"The record folder is closed");
    }

    @Test(description="Update the details of a record folder")
    public void updateRecordFolderDetails() {
        RecordCategoryChild recordCategoryChild = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        String folderDescription = "The folder description is updated" + RandomData.getRandomAlphanumeric();
        String folderName = "The folder name is updated" + RandomData.getRandomAlphanumeric();
        String folderTitle = "Update title " + RandomData.getRandomAlphanumeric();
        String location = "Location " + RandomData.getRandomAlphanumeric();
        RecordFolder recordFolder = RecordFolder.builder().name(folderName).properties(RecordFolderProperties.builder().title(folderTitle).description(folderDescription).vitalRecordIndicator(Boolean.valueOf(true)).reviewPeriod(new ReviewPeriod("month", "1")).location(location).build()).build();
        RecordFolder updatedRecordFolder = this.getRestAPIFactory().getRecordFolderAPI().updateRecordFolder(recordFolder, recordCategoryChild.getId());
        this.assertStatusCode(HttpStatus.OK);
        AssertJUnit.assertEquals((String)updatedRecordFolder.getName(), (String)folderName);
        RecordFolderProperties recordFolderProperties = updatedRecordFolder.getProperties();
        AssertJUnit.assertEquals((String)recordFolderProperties.getDescription(), (String)folderDescription);
        AssertJUnit.assertEquals((String)recordFolderProperties.getTitle(), (String)folderTitle);
        Assert.assertTrue((boolean)recordFolderProperties.getVitalRecordIndicator());
        AssertJUnit.assertEquals((String)recordFolderProperties.getLocation(), (String)location);
        Assert.assertNotNull((Object)recordFolderProperties.getReviewPeriod().getPeriodType());
        Assert.assertNotNull((Object)recordFolderProperties.getReviewPeriod().getExpression());
    }

    @Test(description="Update the details for other nodes than record folder with the request used for record-folders ", dataProvider="getInvalidNodesForRecordFolders")
    public void updateOtherNodeTypesDetails(String nodeId) {
        String nodeDescription = "The folder description is updated" + RandomData.getRandomAlphanumeric();
        String nodeName = "The folder name is updated" + RandomData.getRandomAlphanumeric();
        String nodeTitle = "Update title " + RandomData.getRandomAlphanumeric();
        RecordFolder recordFolder = RecordFolder.builder().name(nodeName).properties(RecordFolderProperties.builder().title(nodeTitle).description(nodeDescription).vitalRecordIndicator(Boolean.valueOf(true)).reviewPeriod(new ReviewPeriod("month", "1")).build()).build();
        this.getRestAPIFactory().getRecordFolderAPI().updateRecordFolder(recordFolder, nodeId);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test(description="Delete invalid nodes type with the DELETE record folders request", dataProvider="getInvalidNodesForRecordFolders")
    public void deleteInvalidNodesRecordFolder(String nodeId) {
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        recordFolderAPI.deleteRecordFolder(nodeId);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test(description="Delete record folder")
    public void deleteRecordFolder() {
        RecordCategoryChild recordFolder = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        String recordFolderId = recordFolder.getId();
        recordFolderAPI.deleteRecordFolder(recordFolderId);
        this.assertStatusCode(HttpStatus.NO_CONTENT);
        recordFolderAPI.getRecordFolder(recordFolderId);
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @Test(description="A closed record folder can be reopened")
    @Bug(id="RM-4808")
    public void openClosedRecordFolder() {
        RecordCategoryChild recordFolder = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        Assert.assertFalse((boolean)recordFolder.getProperties().getIsClosed());
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        RecordFolder recordFolderModel = RecordFolder.builder().properties(RecordFolderProperties.builder().isClosed(Boolean.valueOf(true)).build()).build();
        RecordFolder updatedRecordFolder = recordFolderAPI.updateRecordFolder(recordFolderModel, recordFolder.getId());
        Assert.assertTrue((boolean)updatedRecordFolder.getProperties().getIsClosed());
        recordFolderModel = RecordFolder.builder().properties(RecordFolderProperties.builder().isClosed(Boolean.valueOf(false)).build()).build();
        updatedRecordFolder = recordFolderAPI.updateRecordFolder(recordFolderModel, recordFolder.getId());
        Assert.assertFalse((boolean)updatedRecordFolder.getProperties().getIsClosed());
    }

    @Test
    public void listRecordsFromRecordFolder() {
        Record child;
        int i;
        int NUMBER_OF_RECORDS = 5;
        String containerId = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recFolder")).getId();
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        ArrayList<Record> children = new ArrayList<Record>();
        for (i = 0; i < 5; ++i) {
            Record record = Record.builder().name(ELECTRONIC_RECORD_NAME + i).nodeType("cm:content").build();
            child = recordFolderAPI.createRecord(record, containerId, FilePlanComponentsUtil.createTempFile(ELECTRONIC_RECORD_NAME + i, ELECTRONIC_RECORD_NAME + i));
            children.add(child);
        }
        for (i = 0; i < 5; ++i) {
            Record nonelectronicRecord = Record.builder().properties(RecordProperties.builder().description("Description").title("Title").build()).name(NONELECTRONIC_RECORD_NAME + i).nodeType("rma:nonElectronicDocument").build();
            child = recordFolderAPI.createRecord(nonelectronicRecord, containerId);
            children.add(child);
        }
        RecordFolderCollection apiChildren = (RecordFolderCollection)recordFolderAPI.getRecordFolderChildren(containerId, "include=properties").assertThat().entriesListIsNotEmpty();
        this.assertStatusCode(HttpStatus.OK);
        apiChildren.getEntries().forEach(c -> {
            Record record = c.getEntry();
            Assert.assertNotNull((Object)record.getId());
            this.logger.info((Object)("Checking child " + record.getId()));
            try {
                Record createdComponent = children.stream().filter(child -> child.getId().equals(record.getId())).findFirst().orElseThrow();
                Assert.assertEquals((String)record.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
                Assert.assertEquals((String)record.getParentId(), (String)containerId);
                Assert.assertEquals((String)createdComponent.getName(), (String)record.getName(), (String)("Record Name" + record.getName() + " doesn't match the one returned on create"));
                Assert.assertTrue((boolean)createdComponent.getName().contains(createdComponent.getProperties().getIdentifier()), (String)("Record Name" + createdComponent.getName() + " doesn't contain the record identifier in response when creating"));
                Assert.assertEquals((String)createdComponent.getNodeType(), (String)record.getNodeType());
            }
            catch (NoSuchElementException e) {
                Assert.fail((String)("No child element for " + record.getId()));
            }
        });
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.deleteRecordCategory(this.rootCategory.getId());
    }
}

