/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import java.util.Arrays;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordcategory.RetentionPeriodProperty;
import org.alfresco.rest.rm.community.model.rules.ActionsOnRule;
import org.alfresco.rest.rm.community.model.rules.RuleDefinition;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainer;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildCollection;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.requests.gscore.api.FilesAPI;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.rest.v0.RulesAPI;
import org.alfresco.rest.v0.service.DispositionScheduleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeclareInPlaceRecordsTestLevel2
extends BaseRMRestTest {
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(DeclareInPlaceRecordsTestLevel2.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    private final String RECORDS_CATEGORY_ONE = this.TEST_PREFIX + "category";
    public static final String RECORD_FOLDER_ONE = "record-folder-one";
    public static final String RECORD_CATEGORY_TWO = "record-category-two" + System.currentTimeMillis();
    public static final String RECORD_FOLDER_TWO = "record-folder-two";
    private final String RULE_NAME = this.TEST_PREFIX + "rule unfiled";
    private String unfiledRecordsNodeRef;
    private RecordCategory RecordCategoryOne;
    private RecordCategory RecordCategoryTwo;
    private RecordCategoryChild recordFolder;
    private UnfiledContainer unfiledContainer;
    private FolderModel testFolder;
    private SiteModel testSite;
    private SiteModel privateSite;
    private UserModel testUser;
    @Autowired
    private DispositionScheduleService dispositionScheduleService;
    @Autowired
    private RulesAPI rulesAPI;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RecordsAPI recordsAPI;

    @BeforeClass(alwaysRun=true)
    public void preConditions() {
        Step.STEP((String)"Create RM Site");
        this.createRMSiteIfNotExists();
        this.privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
    }

    @Test
    @AlfrescoTest(jira="RM-2584")
    public void DeclareRecordOwnerDeleted() throws Exception {
        this.createTestPrecondition();
        FileModel uploadedDoc = ((DataContent)((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.testUser).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.dataUser.deleteUser(this.testUser);
        this.getRestAPIFactory().getFilesAPI(this.getDataUser().getAdminUser()).declareAsRecord(uploadedDoc.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertTrue((boolean)this.hasRecordAspect(uploadedDoc));
    }

    @Test
    @AlfrescoTest(jira="MNT-18558")
    public void inPlaceRecordVisibilityAfterFilingToCategoryWithCutOffStep() throws Exception {
        this.createTestPrecondition(this.RECORDS_CATEGORY_ONE);
        this.dispositionScheduleService.createCategoryRetentionSchedule(this.RECORDS_CATEGORY_ONE, Boolean.valueOf(true));
        this.dispositionScheduleService.addCutOffAfterPeriodStep(this.RECORDS_CATEGORY_ONE, "day|2", RetentionPeriodProperty.CREATED_DATE);
        this.recordFolder = this.createFolder(this.getAdminUser(), this.RecordCategoryOne.getId(), RECORD_FOLDER_ONE);
        this.fileToRuleAppliedOnUnfiledRecords();
        UserModel testUser = this.createSiteManager();
        FileModel uploadedDoc = ((DataContent)this.dataContent.usingSite(this.privateSite)).usingUser(testUser).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Record uploadedRecord = this.getRestAPIFactory().getFilesAPI(this.getDataUser().getAdminUser()).declareAsRecord(uploadedDoc.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        this.recordsAPI.completeRecord(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), uploadedRecord.getName());
        ((DataContent)this.dataContent.usingAdmin().usingSite(this.privateSite)).assertContentExist();
    }

    @Test
    @AlfrescoTest(jira="MNT-22138")
    public void filesVisibilityAfterFilingToCategoryWithCutOffAfterEventStep() throws Exception {
        this.RecordCategoryTwo = this.createRootCategory(RECORD_CATEGORY_TWO);
        this.dispositionScheduleService.createCategoryRetentionSchedule(RECORD_CATEGORY_TWO, Boolean.valueOf(true));
        this.dispositionScheduleService.addCutOffAfterPeriodStep(RECORD_CATEGORY_TWO, "day|2", RetentionPeriodProperty.CREATED_DATE);
        this.recordFolder = this.createFolder(this.getAdminUser(), this.RecordCategoryTwo.getId(), RECORD_FOLDER_TWO);
        UserModel siteConsumer = this.getDataUser().createRandomTestUser();
        this.getDataUser().addUserToSite(siteConsumer, this.privateSite, UserRole.SiteConsumer);
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(this.recordFolder.getId(), siteConsumer, UserPermissions.PERMISSION_READ_RECORDS);
        FileModel testFile = ((DataContent)this.dataContent.usingSite(new SiteModel(this.privateSite.getTitle()))).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        FileModel testFileNotFiled = ((DataContent)this.dataContent.usingSite(new SiteModel(this.privateSite.getTitle()))).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((FilesAPI)this.getRestAPIFactory().getFilesAPI().usingParams(new String[]{String.format("%s=%s", "parentId", this.recordFolder.getId())})).declareAsRecord(testFile.getNodeRefWithoutVersion());
        this.getRestAPIFactory().getRmRestWrapper().assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Verify the document in collaboration site is now a record");
        org.testng.Assert.assertTrue((boolean)this.hasRecordAspect(testFile), (String)"File should have record aspect");
        org.testng.Assert.assertFalse((boolean)this.hasRecordAspect(testFileNotFiled), (String)"File should not have record aspect");
    }

    private void createTestPrecondition(String categoryName) {
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.RM_ADMIN, "password", "Administrator");
        Step.STEP((String)"Create category");
        this.RecordCategoryOne = this.createRootCategory(categoryName, "Title");
        this.unfiledContainer = this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainer("-unfiled-");
        this.unfiledRecordsNodeRef = "workspace/SpacesStore/" + this.unfiledContainer.getId();
    }

    private void createTestPrecondition() {
        Step.STEP((String)"Create collab_user user");
        this.testUser = this.getDataUser().createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.getDataUser().addUserToSite(this.testUser, this.testSite, UserRole.SiteContributor);
        this.testFolder = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.testUser).createFolder();
    }

    private void fileToRuleAppliedOnUnfiledRecords() {
        this.unfiledRecordsRuleTeardown();
        RuleDefinition ruleDefinition = RuleDefinition.createNewRule().title(this.RULE_NAME).description(this.RULE_NAME).createRecordPath(false).path("/" + this.RECORDS_CATEGORY_ONE + "/record-folder-one").runInBackground(true).actions(Arrays.asList(ActionsOnRule.FILE_TO.getActionValue()));
        this.rulesAPI.createRule(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.unfiledRecordsNodeRef, ruleDefinition);
    }

    private void unfiledRecordsRuleTeardown() {
        this.rulesAPI.deleteAllRulesOnContainer(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.unfiledRecordsNodeRef);
    }

    public UserModel createSiteManager() {
        UserModel siteManager = this.getDataUser().createRandomTestUser();
        this.getDataUser().addUserToSite(siteManager, this.privateSite, UserRole.SiteManager);
        return siteManager;
    }

    @AfterClass
    public void cleanupCategory() {
        this.unfiledRecordsRuleTeardown();
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", RECORD_FOLDER_ONE);
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", this.RecordCategoryOne.getName());
        this.deleteRecordCategory(this.RecordCategoryOne.getId());
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", RECORD_FOLDER_TWO);
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "rm", this.RecordCategoryTwo.getName());
        this.deleteRecordCategory(this.RecordCategoryTwo.getId());
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.privateSite);
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.testSite);
        UnfiledContainerChildCollection unfiledContainerChildCollection = this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainerChildren(this.unfiledContainer.getId());
        unfiledContainerChildCollection.getEntries().forEach(unfiledChild -> {
            if (unfiledChild.getEntry().getIsRecord().booleanValue()) {
                this.getRestAPIFactory().getRecordsAPI().deleteRecord(unfiledChild.getEntry().getId());
            } else {
                this.getRestAPIFactory().getUnfiledRecordFoldersAPI().deleteUnfiledRecordFolder(unfiledChild.getEntry().getId());
            }
        });
    }
}

