/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.hold;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.dataprep.ContentActions;
import org.alfresco.rest.model.RestNodeAssociationModel;
import org.alfresco.rest.model.RestNodeAssociationModelCollection;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.hold.Hold;
import org.alfresco.rest.rm.community.model.hold.HoldChild;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.requests.gscore.api.FilePlanAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.CoreUtil;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AddToHoldsV1Tests
extends BaseRMRestTest {
    private static final String ACCESS_DENIED_ERROR_MESSAGE = "Access Denied.  You do not have the appropriate permissions to perform this operation.";
    private static final String INVALID_TYPE_ERROR_MESSAGE = "Only records, record folders or content can be added to a hold.";
    private static final String LOCKED_FILE_ERROR_MESSAGE = "Locked content can't be added to a hold.";
    private static final String HOLD = "HOLD" + CommonTestUtils.generateTestPrefix(AddToHoldsV1Tests.class);
    private String holdNodeRef;
    private SiteModel testSite;
    private FileModel documentHeld;
    private FileModel contentToAddToHold;
    private FileModel contentAddToHoldNoPermission;
    private Hold hold;
    private UserModel userAddHoldPermission;
    private final List<UserModel> users = new ArrayList<UserModel>();
    private final List<String> nodesToBeClean = new ArrayList<String>();
    @Autowired
    private RoleService roleService;
    @Autowired
    private ContentActions contentActions;

    @BeforeClass(alwaysRun=true)
    public void preconditionForAddContentToHold() {
        Step.STEP((String)"Create a hold.");
        this.hold = this.createHold("-filePlan-", Hold.builder().name(HOLD).description("Generalized hold case for tests").reason("Active content to be reviewed for the CASE McDermott, FINRA ").build(), this.getAdminUser());
        this.holdNodeRef = this.hold.getId();
        Step.STEP((String)"Create test files.");
        this.testSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.documentHeld = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.contentToAddToHold = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.contentAddToHoldNoPermission = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Add the content to the hold.");
        this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).addChildToHold(HoldChild.builder().id(this.documentHeld.getNodeRefWithoutVersion()).build(), this.hold.getId());
        Step.STEP((String)"Create users");
        this.userAddHoldPermission = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, this.holdNodeRef, UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING);
        this.users.add(this.userAddHoldPermission);
    }

    @Test
    public void retrieveTheContentOfTheHoldUsingV1API() {
        Step.STEP((String)"Retrieve the list of children from the hold and collect the entries that have the name of the active content held");
        List<String> documentNames = this.restClient.authenticateUser(this.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)CoreUtil.toContentModel(this.holdNodeRef)).listChildren().getEntries().stream().map(RestNodeModel::onModel).map(RestNodeModel::getName).filter(documentName -> documentName.equals(this.documentHeld.getName())).toList();
        Step.STEP((String)"Check the list of active content");
        Assert.assertEquals(documentNames, Set.of(this.documentHeld.getName()));
    }

    @Test
    public void retrieveTheHoldWhereTheContentIsAdded() {
        RestNodeAssociationModelCollection holdsEntries = ((Node)this.getRestAPIFactory().getNodeAPI((RepoTestModel)this.documentHeld).usingParams(new String[]{"where=(assocType='rma:frozenContent')"})).getParents();
        Hold retrievedHold = this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).getHold(((RestNodeAssociationModel)holdsEntries.getEntries().get(0)).getModel().getId());
        Assert.assertEquals((Object)retrievedHold, (Object)this.hold, (String)"Holds are not equal");
    }

    @DataProvider(name="validNodesForAddToHold")
    public Object[][] getValidNodesForAddToHold() {
        RecordCategoryChild recordFolder = this.createCategoryFolderInFilePlan();
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        this.nodesToBeClean.add(recordFolder.getParentId());
        Record electronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), recordFolder.getId(), FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.CREATED);
        Record nonElectronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createNonElectronicRecordModel(), recordFolder.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(recordFolder.getId(), this.userAddHoldPermission, UserPermissions.PERMISSION_FILING);
        RecordCategoryChild folderToHold = this.createCategoryFolderInFilePlan();
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(folderToHold.getId(), this.userAddHoldPermission, UserPermissions.PERMISSION_FILING);
        this.nodesToBeClean.add(folderToHold.getParentId());
        return new String[][]{{folderToHold.getId()}, {electronicRecord.getId()}, {nonElectronicRecord.getId()}, {this.contentToAddToHold.getNodeRefWithoutVersion()}};
    }

    @Test(dataProvider="validNodesForAddToHold")
    public void addValidNodesToHoldWithAllowedUser(String nodeId) throws Exception {
        Step.STEP((String)"Add node to hold with user with permission.");
        this.getRestAPIFactory().getHoldsAPI(this.userAddHoldPermission).addChildToHold(HoldChild.builder().id(nodeId).build(), this.hold.getId());
        Step.STEP((String)"Check the node is frozen.");
        Assert.assertTrue((boolean)this.hasAspect(nodeId, "rma:frozen"));
    }

    @DataProvider(name="userWithoutPermissionForAddToHold")
    public Object[][] getUserWithoutPermissionForAddToHold() {
        RecordCategoryChild recordFolder = this.createCategoryFolderInFilePlan();
        UserModel user = this.roleService.createUserWithRMRoleAndRMNodePermission(UserRoles.ROLE_RM_MANAGER.roleId, recordFolder.getId(), UserPermissions.PERMISSION_READ_RECORDS);
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(this.holdNodeRef, user, UserPermissions.PERMISSION_FILING);
        this.nodesToBeClean.add(recordFolder.getParentId());
        return new Object[][]{{this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteConsumer, this.holdNodeRef, UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_FILING), this.contentAddToHoldNoPermission.getNodeRefWithoutVersion()}, {this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, this.holdNodeRef, UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_READ_RECORDS), this.contentAddToHoldNoPermission.getNodeRefWithoutVersion()}, {this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.testSite, UserRole.SiteCollaborator, this.holdNodeRef, UserRoles.ROLE_RM_POWER_USER, UserPermissions.PERMISSION_READ_RECORDS), this.contentAddToHoldNoPermission.getNodeRefWithoutVersion()}, {user, recordFolder.getId()}};
    }

    @Test(dataProvider="userWithoutPermissionForAddToHold")
    public void addContentToHoldWithUserWithoutHoldPermission(UserModel userModel, String nodeToBeAddedToHold) throws Exception {
        this.users.add(userModel);
        Step.STEP((String)"Add the node to the hold with user without permission.");
        this.getRestAPIFactory().getHoldsAPI(userModel).addChildToHold(HoldChild.builder().id(nodeToBeAddedToHold).build(), this.holdNodeRef);
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        this.getRestAPIFactory().getRmRestWrapper().assertLastError().containsSummary(ACCESS_DENIED_ERROR_MESSAGE);
        Step.STEP((String)"Check the node is not frozen.");
        AssertJUnit.assertFalse((boolean)this.hasAspect(nodeToBeAddedToHold, "rma:frozen"));
    }

    @DataProvider(name="invalidNodesForAddToHold")
    public Object[][] getInvalidNodesForAddToHold() {
        FileModel contentLocked = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.contentActions.checkOut(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.testSite.getId(), contentLocked.getName());
        RecordCategory category = this.createRootCategory(RandomData.getRandomAlphanumeric());
        this.nodesToBeClean.add(category.getId());
        return new Object[][]{{this.getFilePlan("-filePlan-").getId(), 400, INVALID_TYPE_ERROR_MESSAGE}, {this.getTransferContainer("-transfers-").getId(), 400, INVALID_TYPE_ERROR_MESSAGE}, {category.getId(), 400, INVALID_TYPE_ERROR_MESSAGE}, {this.getUnfiledContainer("-unfiled-").getId(), 400, INVALID_TYPE_ERROR_MESSAGE}, {this.createUnfiledContainerChild("-unfiled-", "Unfiled Folder " + RandomData.getRandomAlphanumeric(), "rma:unfiledRecordFolder").getId(), 400, INVALID_TYPE_ERROR_MESSAGE}, {((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createFolder().getNodeRef(), 400, INVALID_TYPE_ERROR_MESSAGE}, {contentLocked.getNodeRefWithoutVersion(), 400, LOCKED_FILE_ERROR_MESSAGE}};
    }

    @Test(dataProvider="invalidNodesForAddToHold")
    public void addInvalidNodesToHold(String itemNodeRef, int responseCode, String errorMessage) throws Exception {
        Step.STEP((String)"Add the node to the hold ");
        this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).addChildToHold(HoldChild.builder().id(itemNodeRef).build(), this.holdNodeRef);
        this.assertStatusCode(HttpStatus.valueOf((int)responseCode));
        this.getRestAPIFactory().getRmRestWrapper().assertLastError().containsSummary(errorMessage);
        Step.STEP((String)"Check node is not frozen.");
        AssertJUnit.assertFalse((boolean)this.hasAspect(itemNodeRef, "rma:frozen"));
    }

    private Hold createHold(String parentId, Hold hold, UserModel user) {
        FilePlanAPI filePlanAPI = this.getRestAPIFactory().getFilePlansAPI(user);
        return filePlanAPI.createHold(hold, parentId);
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpAddContentToHold() {
        this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).deleteHold(this.holdNodeRef);
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.testSite);
        this.users.forEach(user -> ((DataUser)this.getDataUser().usingAdmin()).deleteUser(user));
        this.nodesToBeClean.forEach(this::deleteRecordCategory);
    }
}

