/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.model.RestNodeBodyMoveCopyModel;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.record.RecordBodyFile;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordCategoryAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.rest.v0.service.DispositionScheduleService;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DeleteRecordTests
extends BaseRMRestTest {
    @Autowired
    private DispositionScheduleService dispositionScheduleService;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RecordsAPI recordsAPI;
    @Autowired
    private RoleService roleService;
    private RecordCategoryChild recordFolder;
    private UnfiledContainerChild unfiledRecordFolder;

    @BeforeClass(alwaysRun=true)
    public void setupDeleteRecordTests() {
        this.testSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.recordFolder = this.createCategoryFolderInFilePlan();
        this.unfiledRecordFolder = this.createUnfiledContainerChild("-unfiled-", RandomData.getRandomName((String)"Unfiled Folder "), "rma:unfiledRecordFolder");
    }

    @DataProvider(name="recordsToBeDeleted")
    public Object[][] getRecordsToBeDeleted() {
        return new String[][]{{this.getRestAPIFactory().getRecordFolderAPI().createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), this.recordFolder.getId(), FilePlanComponentsUtil.getFile("money.JPG")).getId()}, {this.getRestAPIFactory().getRecordFolderAPI().createRecord(FilePlanComponentsUtil.createNonElectronicRecordModel(), this.recordFolder.getId()).getId()}, {this.getRestAPIFactory().getUnfiledContainersAPI().uploadRecord(FilePlanComponentsUtil.createElectronicUnfiledContainerChildModel(), "-unfiled-", FilePlanComponentsUtil.getFile("money.JPG")).getId()}, {this.getRestAPIFactory().getUnfiledContainersAPI().createUnfiledContainerChild(FilePlanComponentsUtil.createNonElectronicUnfiledContainerChildModel(), "-unfiled-").getId()}, {this.getRestAPIFactory().getUnfiledRecordFoldersAPI().uploadRecord(FilePlanComponentsUtil.createElectronicUnfiledContainerChildModel(), this.unfiledRecordFolder.getId(), FilePlanComponentsUtil.getFile("money.JPG")).getId()}, {this.getRestAPIFactory().getUnfiledRecordFoldersAPI().createUnfiledRecordFolderChild(FilePlanComponentsUtil.createNonElectronicUnfiledContainerChildModel(), this.unfiledRecordFolder.getId()).getId()}};
    }

    @Test(dataProvider="recordsToBeDeleted", description="Admin user can delete records")
    @AlfrescoTest(jira="RM-4363")
    public void adminCanDeleteRecords(String recordId) {
        this.deleteAndVerify(recordId);
    }

    @Test(description="User without write permissions can't delete a record")
    @AlfrescoTest(jira="RM-4363")
    public void userWithoutWritePermissionsCantDeleteRecord() {
        UnfiledContainerChild nonElectronicRecord = UnfiledContainerChild.builder().name("Record " + RandomData.getRandomAlphanumeric()).nodeType("rma:nonElectronicDocument").build();
        UnfiledContainerChild newRecord = this.getRestAPIFactory().getUnfiledContainersAPI().createUnfiledContainerChild(nonElectronicRecord, "-unfiled-");
        this.assertStatusCode(HttpStatus.CREATED);
        UserModel deleteUser = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_MANAGER.roleId);
        this.getRestAPIFactory().getRecordsAPI(deleteUser).deleteRecord(newRecord.getId());
        this.assertStatusCode(HttpStatus.FORBIDDEN);
    }

    @Test(description="User without delete records capability can't delete a record")
    @AlfrescoTest(jira="RM-4363")
    public void userWithoutDeleteRecordsCapabilityCantDeleteRecord() {
        UserModel deleteUser = this.roleService.createUserWithRMRole(UserRoles.ROLE_RM_POWER_USER.roleId);
        RecordCategoryAPI recordCategoryAPI = this.getRestAPIFactory().getRecordCategoryAPI();
        this.getRestAPIFactory().getRMUserAPI().addUserPermission(recordCategoryAPI.getRecordCategory(this.recordFolder.getParentId()).getId(), deleteUser, UserPermissions.PERMISSION_FILING);
        this.assertStatusCode(HttpStatus.OK);
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        Record newRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createNonElectronicRecordModel(), this.recordFolder.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI(deleteUser);
        recordsAPI.getRecord(newRecord.getId());
        this.assertStatusCode(HttpStatus.OK);
        recordsAPI.deleteRecord(newRecord.getId());
        this.assertStatusCode(HttpStatus.FORBIDDEN);
    }

    @Test(description="Deleting copy of record doesn't delete original content")
    @AlfrescoTest(jira="MNT-18806")
    public void deleteCopyOfRecord() {
        Step.STEP((String)"Create another record category with a folder.");
        RecordCategoryChild recordFolderB = this.createCategoryFolderInFilePlan();
        Step.STEP((String)"Create a record in first folder and copy it into second folder.");
        String recordId = this.getRestAPIFactory().getRecordFolderAPI().createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), this.recordFolder.getId(), FilePlanComponentsUtil.getFile("money.JPG")).getId();
        String copyId = this.copyNode(recordId, recordFolderB.getId()).getId();
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Check that it's possible to load the original content.");
        this.getNodeContent(recordId);
        this.assertStatusCode(HttpStatus.OK);
        Step.STEP((String)"Delete the copy.");
        this.deleteAndVerify(copyId);
        Step.STEP((String)"Check that the original record node and content still exist.");
        this.checkNodeExists(recordId);
        this.getNodeContent(recordId);
    }

    @Test(description="Deleting record doesn't delete the content for the copies")
    @AlfrescoTest(jira="MNT-20145")
    public void deleteOriginOfRecord() {
        Step.STEP((String)"Create a file.");
        FileModel testFile = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Create a copy of the file.");
        RestNodeModel copyOfTestFile = this.copyNode(testFile.getNodeRefWithoutVersion(), this.testSite.getGuid());
        Step.STEP((String)"Declare original file as record");
        this.getRestAPIFactory().getFilesAPI().declareAsRecord(testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Delete the record.");
        this.deleteAndVerify(testFile.getNodeRefWithoutVersion());
        Step.STEP((String)"Check that it's possible to load the copy content.");
        this.getNodeContent(copyOfTestFile.getId());
        this.assertStatusCode(HttpStatus.OK);
    }

    @Test(description="Destroying record doesn't delete the content for the associated copy")
    @AlfrescoTest(jira="MNT-20145")
    public void destroyOfRecord() {
        Step.STEP((String)"Create a file.");
        FileModel testFile = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        FolderModel folderModel = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createFolder();
        Step.STEP((String)"Create a copy of the file.");
        RestNodeModel copy = this.copyNode(testFile.getNodeRefWithoutVersion(), folderModel.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Declare the file as record.");
        this.getRestAPIFactory().getFilesAPI().declareAsRecord(testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Create a record category with a disposition schedule.");
        RecordCategory recordCategory = this.createRootCategory(RandomData.getRandomName((String)"Category with disposition"));
        this.dispositionScheduleService.createCategoryRetentionSchedule(recordCategory.getName(), Boolean.valueOf(true));
        Step.STEP((String)"Add retention schedule cut off and destroy step with immediate period.");
        this.dispositionScheduleService.addCutOffImmediatelyStep(recordCategory.getName());
        this.dispositionScheduleService.addDestroyWithGhostingImmediatelyAfterCutOff(recordCategory.getName());
        Step.STEP((String)"Create a record folder and file the record");
        RecordCategoryChild recFolder = this.createFolder(recordCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        RecordBodyFile recordBodyFile = RecordBodyFile.builder().targetParentId(recFolder.getId()).build();
        Record recordFiled = this.getRestAPIFactory().getRecordsAPI().fileRecord(recordBodyFile, testFile.getNodeRefWithoutVersion());
        this.completeRecord(recordFiled.getId());
        this.assertStatusCode(HttpStatus.OK);
        Step.STEP((String)"Execute the disposition schedule steps.");
        this.rmRolesAndActionsAPI.executeAction(this.getAdminUser().getUsername(), this.getAdminUser().getUsername(), recordFiled.getName(), BaseAPI.RM_ACTIONS.CUT_OFF);
        this.rmRolesAndActionsAPI.executeAction(this.getAdminUser().getUsername(), this.getAdminUser().getUsername(), recordFiled.getName(), BaseAPI.RM_ACTIONS.DESTROY);
        Step.STEP((String)"Check that it's possible to load the copy content.");
        this.getNodeContent(copy.getId());
        this.assertStatusCode(HttpStatus.OK);
    }

    @Test(description="Deleting record made from version doesn't delete the content for the file")
    @AlfrescoTest(jira="MNT-20145")
    public void deleteVersionDeclaredAsRecord() {
        Step.STEP((String)"Create a file.");
        FileModel testFile = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Declare file version as record.");
        this.recordsAPI.declareDocumentVersionAsRecord(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.testSite.getId(), testFile.getName());
        UnfiledContainerChild unfiledContainerChild = this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainerChildren("-unfiled-").getEntries().stream().filter(child -> child.getEntry().getName().startsWith(testFile.getName().substring(0, testFile.getName().indexOf(".")))).findFirst().get().getEntry();
        Step.STEP((String)"Delete the record.");
        this.deleteAndVerify(unfiledContainerChild.getId());
        Step.STEP((String)"Check that it's possible to load the file declared version as record.");
        this.getNodeContent(testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.OK);
    }

    private void deleteAndVerify(String recordId) {
        org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        recordsAPI.deleteRecord(recordId);
        this.assertStatusCode(HttpStatus.NO_CONTENT);
        recordsAPI.getRecord(recordId);
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    private RestNodeModel copyNode(String nodeId, String destinationFolder) {
        Node node = this.getNode(nodeId);
        RestNodeBodyMoveCopyModel copyBody = new RestNodeBodyMoveCopyModel();
        copyBody.setTargetParentId(destinationFolder);
        try {
            return node.copy(copyBody);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem copying record.", e);
        }
    }

    private RestResponse getNodeContent(String nodeId) {
        try {
            return this.getNode(nodeId).getNodeContent();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load content for node.", e);
        }
    }

    private void checkNodeExists(String nodeId) {
        try {
            this.getNode(nodeId).getNode();
        }
        catch (Exception e) {
            throw new RuntimeException("Node does not exist.", e);
        }
    }

    private Node getNode(String recordId) {
        RepoTestModel repoTestModel = new RepoTestModel(){};
        repoTestModel.setNodeRef(recordId);
        return this.getRestAPIFactory().getNodeAPI(repoTestModel);
    }

    @AfterClass(alwaysRun=true)
    public void cleanupDeleteRecordTests() {
        this.dataSite.deleteSite(this.testSite);
        this.deleteRecordCategory(this.recordFolder.getParentId());
        this.getRestAPIFactory().getUnfiledRecordFoldersAPI().deleteUnfiledRecordFolder(this.unfiledRecordFolder.getId());
    }
}

