/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.audit;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.RMAuditAPI;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.test.util.AssertionErrors;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ElectronicRecordAuditLogTest
extends BaseRMRestTest {
    private Optional<UserModel> rmAdmin;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RMAuditAPI auditLog;
    @Autowired
    private RecordsAPI recordApi;
    private static final String AUDIT_ELECTRONIC_RECORD = CommonTestUtils.generateTestPrefix(ElectronicRecordAuditLogTest.class) + "electronic record";
    private static final String AUDIT_COMPLETE_REOPEN_ELECTRONIC_RECORD = "Complete Reopen Electronic Record";
    public static final String TITLE = "Title";
    public static final String DESCRIPTION = "Description";
    private RecordCategory category1;
    private RecordCategoryChild recordFolder1;
    private Record electronicRecord;
    private Record electronicRecord2;

    @BeforeClass(alwaysRun=true)
    public void electronicRecordsAuditLogSetup() {
        this.createRMSiteIfNotExists();
        this.rmAdmin = Optional.ofNullable(this.getDataUser().createRandomTestUser());
        this.rmRolesAndActionsAPI.assignRoleToUser(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.rmAdmin.get().getUsername(), "Administrator");
        this.auditLog.clearAuditLog(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword());
        this.category1 = this.createRootCategory(TITLE, DESCRIPTION);
        this.recordFolder1 = this.createFolder(this.category1.getId(), TITLE);
        this.electronicRecord = this.createElectronicRecord(this.recordFolder1.getId(), AUDIT_ELECTRONIC_RECORD, this.rmAdmin.get());
    }

    @Test(description="Audit log for newly filed electronic record")
    @AlfrescoTest(jira="RM-4303")
    public void newElectronicRecordAudit() {
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"File To Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("File to")));
        AssertionErrors.assertTrue((String)"Updated metadata Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Updated Metadata")));
    }

    @Test(dependsOnMethods={"newElectronicRecordAudit"}, description="Viewing electronic record audit log is itself an auditable event")
    @AlfrescoTest(jira="RM-4303")
    public void electronicRecordAuditIsEvent() {
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Audit View Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Audit View")));
    }

    @Test(dependsOnMethods={"electronicRecordAuditIsEvent"}, description="Rename electronic record is an edit metadata event")
    @AlfrescoTest(jira="RM-4303")
    public void renameElectronicRecord() {
        this.auditLog.clearAuditLog(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword());
        Record renameElectronicRecord = FilePlanComponentsUtil.createRecordModel("edited " + this.electronicRecord.getName(), "", "");
        this.getRestAPIFactory().getRecordsAPI().updateRecord(renameElectronicRecord, this.electronicRecord.getId());
        this.assertStatusCode(HttpStatus.OK);
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Updated metadata Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Updated Metadata")));
    }

    @Test(dependsOnMethods={"newElectronicRecordAudit"}, description="Complete and reopen electronic record")
    @AlfrescoTest(jira="RM-4303")
    public void completeAndReopenElectronicRecord() {
        this.electronicRecord2 = this.createElectronicRecord(this.recordFolder1.getId(), AUDIT_COMPLETE_REOPEN_ELECTRONIC_RECORD);
        this.recordApi.completeRecord(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword(), this.electronicRecord2.getName());
        try {
            Utility.sleep((int)1000, (int)30000, () -> {
                org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
                List aspects = recordsAPI.getRecord(this.electronicRecord2.getId()).getAspectNames();
                AssertionErrors.assertTrue((String)"Record is not completed.", (boolean)aspects.contains("rma:declaredRecord"));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        List auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Complete Record Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Complete Record")));
        this.recordApi.reOpenRecord(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword(), this.electronicRecord2.getName());
        try {
            Utility.sleep((int)1000, (int)30000, () -> {
                org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
                List aspects = recordsAPI.getRecord(this.electronicRecord2.getId()).getAspectNames();
                Assert.assertFalse((boolean)aspects.contains("rma:declaredRecord"));
            });
        }
        catch (InterruptedException e) {
            Assert.fail((String)"InterruptedException received while waiting for results.");
        }
        auditEntries = this.auditLog.getRMAuditLogAll(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 100);
        AssertionErrors.assertTrue((String)"Reopen Record Event is not present.", (boolean)auditEntries.stream().anyMatch(x -> x.getEvent().startsWith("Reopen Record")));
    }

    @Test(dependsOnMethods={"completeAndReopenElectronicRecord"}, description="File electronic record's audit log as record")
    @AlfrescoTest(jira="RM-4303")
    public void fileElectronicRecordAuditLogAsRecord() {
        HttpResponse auditRecordHttpResponse = this.auditLog.logsAuditLogAsRecord(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword(), this.getRecordNodeRef(this.electronicRecord2.getId()), this.getFolderNodeRef(this.recordFolder1.getId()));
        JSONObject auditRecordProperties = this.getAuditPropertyValues(auditRecordHttpResponse);
        Record auditRecord = this.getRestAPIFactory().getRecordsAPI().getRecord(auditRecordProperties.get("record").toString().replace("workspace://SpacesStore/", ""));
        AssertJUnit.assertTrue((boolean)auditRecordProperties.get("recordName").toString().endsWith(".html"));
        AssertJUnit.assertTrue((boolean)auditRecord.getAspectNames().stream().noneMatch(x -> x.startsWith("rma:declaredRecord")));
    }

    private String getFolderNodeRef(String folderId) {
        return "workspace://SpacesStore/" + folderId;
    }

    private String getRecordNodeRef(String recordId) {
        return "workspace/SpacesStore/" + recordId;
    }

    private JSONObject getAuditPropertyValues(HttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        String responseString = null;
        try {
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject result = new JSONObject(responseString);
        return result;
    }

    @AfterMethod
    private void closeAuditLog() {
        this.auditLog.clearAuditLog(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword());
    }

    @AfterClass(alwaysRun=true)
    private void electronicRecordAuditLogCleanup() {
        this.deleteRecord(this.electronicRecord.getId());
        this.deleteRecordFolder(this.recordFolder1.getId());
        this.deleteRecordCategory(this.category1.getId());
        ((DataUser)this.dataUser.usingAdmin()).deleteUser(new UserModel(this.rmAdmin.get().getUsername(), this.rmAdmin.get().getPassword()));
    }
}

