/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.requests.gscore.api;

import io.restassured.response.ResponseBody;
import org.alfresco.rest.core.RMRestWrapper;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.record.RecordBodyFile;
import org.alfresco.rest.rm.community.requests.RMModelRequest;
import org.alfresco.rest.rm.community.util.ParameterCheck;
import org.alfresco.rest.rm.community.util.PojoUtility;
import org.springframework.http.HttpMethod;

public class RecordsAPI
extends RMModelRequest {
    public RecordsAPI(RMRestWrapper rmRestWrapper) {
        super(rmRestWrapper);
    }

    public ResponseBody<?> getRecordContent(String recordId) {
        ParameterCheck.mandatoryString("recordId", recordId);
        return this.getRmRestWrapper().processHtmlResponse(RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"records/{recordId}/content", (String[])new String[]{recordId})).getBody();
    }

    public Record fileRecord(RecordBodyFile recordBodyFile, String recordId) {
        ParameterCheck.mandatoryObject("recordBodyFile", (Object)recordBodyFile);
        ParameterCheck.mandatoryString("recordId", recordId);
        return this.fileRecord(recordBodyFile, recordId, "");
    }

    public Record fileRecord(RecordBodyFile recordBodyFile, String recordId, String parameters) {
        ParameterCheck.mandatoryObject("requestBodyFile", (Object)recordBodyFile);
        ParameterCheck.mandatoryString("recordId", recordId);
        return this.getRmRestWrapper().processModel(Record.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)PojoUtility.toJson((Object)recordBodyFile), (String)"/records/{recordId}/file?{parameters}", (String[])new String[]{recordId, parameters}));
    }

    public Record completeRecord(String recordId) {
        ParameterCheck.mandatoryString("recordId", recordId);
        return this.completeRecord(recordId, "");
    }

    public Record completeRecord(String recordId, String parameters) {
        ParameterCheck.mandatoryString("recordId", recordId);
        return this.getRmRestWrapper().processModel(Record.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.POST, (String)"/records/{recordId}/complete?{parameters}", (String[])new String[]{recordId, parameters}));
    }

    public void deleteRecord(String recordId) {
        ParameterCheck.mandatoryString("recordId", recordId);
        this.getRmRestWrapper().processEmptyModel(RestRequest.simpleRequest((HttpMethod)HttpMethod.DELETE, (String)"records/{recordId}", (String[])new String[]{recordId}));
    }

    public Record getRecord(String recordId) {
        ParameterCheck.mandatoryString("recordId", recordId);
        return this.getRecord(recordId, "");
    }

    public Record getRecord(String recordId, String parameters) {
        ParameterCheck.mandatoryString("recordId", recordId);
        return this.getRmRestWrapper().processModel(Record.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"records/{recordId}?{parameters}", (String[])new String[]{recordId, parameters}));
    }

    public Record updateRecord(Record recordModel, String recordId) {
        ParameterCheck.mandatoryObject("recordModel", (Object)recordModel);
        ParameterCheck.mandatoryString("recordId", recordId);
        return this.updateRecord(recordModel, recordId, "");
    }

    public Record updateRecord(Record recordModel, String recordId, String parameters) {
        ParameterCheck.mandatoryObject("recordModel", (Object)recordModel);
        ParameterCheck.mandatoryString("recordId", recordId);
        return this.getRmRestWrapper().processModel(Record.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)PojoUtility.toJson((Object)recordModel), (String)"records/{recordId}?{parameters}", (String[])new String[]{recordId, parameters}));
    }
}

