/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0.service;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import org.alfresco.rest.rm.community.model.audit.AuditEntry;
import org.alfresco.rest.rm.community.model.audit.AuditEvents;
import org.alfresco.rest.v0.RMAuditAPI;
import org.alfresco.utility.data.DataUserAIS;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.testng.AssertJUnit;

@Service
public class RMAuditService {
    @Autowired
    private RMAuditAPI rmAuditAPI;
    @Autowired
    private DataUserAIS dataUser;

    public void clearAuditLog() {
        Step.STEP((String)"Clean audit logs.");
        this.rmAuditAPI.clearAuditLog(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword());
    }

    public List<AuditEntry> getAuditEntriesFilteredByEvent(UserModel user, AuditEvents auditEvent) {
        Step.STEP((String)("Get the list of audit entries for the " + auditEvent.eventDisplayName + " event."));
        return this.rmAuditAPI.getRMAuditLog(user.getUsername(), user.getPassword(), 100, auditEvent.event);
    }

    public void checkAuditLogForEvent(UserModel user, AuditEvents auditEvent, UserModel auditUser, String nodeName, List<Object> changedValues) {
        List<AuditEntry> auditEntries = this.getAuditEntriesFilteredByEvent(user, auditEvent);
        AssertJUnit.assertTrue((String)("The list of events is not filtered by " + auditEvent.event), (boolean)auditEntries.stream().allMatch(auditEntry -> auditEntry.getEvent().equals(auditEvent.eventDisplayName)));
        LocalDateTime eventTimestamp = LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()).truncatedTo(ChronoUnit.MINUTES);
        AssertJUnit.assertTrue((String)"The event details are not audited", (boolean)auditEntries.stream().anyMatch(auditEntry -> auditEntry.getNodeName().equals(nodeName) && auditEntry.getUserName().equals(auditUser.getUsername()) && CollectionUtils.isEqualCollection(auditEntry.getChangedValues(), (Collection)changedValues) && !auditEntry.getTimestamp().isEmpty() && LocalDateTime.ofInstant(Instant.parse(auditEntry.getTimestamp()), ZoneId.systemDefault()).truncatedTo(ChronoUnit.MINUTES).compareTo(eventTimestamp) <= 0));
    }

    public void checkAuditLogForEvent(UserModel user, AuditEvents auditEvent, UserModel auditUser, String nodeName, String nodePath, List<Object> changedValues) {
        List<AuditEntry> auditEntries = this.getAuditEntriesFilteredByEvent(user, auditEvent);
        AssertJUnit.assertTrue((String)("The list of events is not filtered by " + auditEvent.event), (boolean)auditEntries.stream().allMatch(auditEntry -> auditEntry.getEvent().equals(auditEvent.eventDisplayName)));
        LocalDateTime eventTimestamp = LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()).truncatedTo(ChronoUnit.MINUTES);
        AssertJUnit.assertTrue((String)"The event details are not audited", (boolean)auditEntries.stream().anyMatch(auditEntry -> auditEntry.getNodeName().equals(nodeName) && auditEntry.getUserName().equals(auditUser.getUsername()) && auditEntry.getPath().equals(nodePath) && CollectionUtils.isEqualCollection(auditEntry.getChangedValues(), (Collection)changedValues) && !auditEntry.getTimestamp().isEmpty() && LocalDateTime.ofInstant(Instant.parse(auditEntry.getTimestamp()), ZoneId.systemDefault()).truncatedTo(ChronoUnit.MINUTES).compareTo(eventTimestamp) <= 0));
    }
}

