/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.record.RecordBodyFile;
import org.alfresco.rest.rm.community.model.record.RecordContent;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildProperties;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledContainerAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledRecordFolderAPI;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.Bug;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FileRecordsTests
extends BaseRMRestTest {
    private UnfiledContainerChild electronicRecord = UnfiledContainerChild.builder().name(TestData.ELECTRONIC_RECORD_NAME).nodeType("cm:content").content(RecordContent.builder().mimeType("text/plain").build()).build();
    private UnfiledContainerChild nonelectronicRecord = UnfiledContainerChild.builder().properties(UnfiledContainerChildProperties.builder().description(TestData.NONELECTRONIC_RECORD_NAME).title("Title").build()).name(TestData.NONELECTRONIC_RECORD_NAME).nodeType("rma:nonElectronicDocument").build();
    private String targetFolderId;
    private String folderToLink;
    private String closedFolderId;
    private String unfiledRecordFolderId;

    @BeforeClass(alwaysRun=true)
    public void setupFileRecordsTests() {
        this.targetFolderId = this.createCategoryFolderInFilePlan().getId();
        this.folderToLink = this.createCategoryFolderInFilePlan().getId();
        this.closedFolderId = this.createCategoryFolderInFilePlan().getId();
        this.closeFolder(this.closedFolderId);
        this.unfiledRecordFolderId = this.createUnfiledContainerChild("-unfiled-", "Unfiled Folder " + RandomData.getRandomAlphanumeric(), "rma:unfiledRecordFolder").getId();
    }

    @DataProvider(name="invalidContainersToFile")
    public Object[][] getFolderContainers() {
        return new String[][]{{"-filePlan-"}, {"-unfiled-"}, {"-transfers-"}, {this.createRootCategory(this.getAdminUser(), "Category " + RandomData.getRandomAlphanumeric()).getId()}, {this.createUnfiledContainerChild("-unfiled-", "Unfiled Folder " + RandomData.getRandomAlphanumeric(), "rma:unfiledRecordFolder").getId()}};
    }

    @DataProvider(name="unfiledRecordsFromUnfiledRecordsContainer")
    public Object[][] getRecordsFromUnfiledRecordsContainer() {
        UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
        return new String[][]{{unfiledContainersAPI.uploadRecord(this.electronicRecord, "-unfiled-", FilePlanComponentsUtil.createTempFile(TestData.ELECTRONIC_RECORD_NAME, TestData.ELECTRONIC_RECORD_NAME)).getId()}, {unfiledContainersAPI.createUnfiledContainerChild(this.nonelectronicRecord, "-unfiled-").getId()}};
    }

    @DataProvider(name="unfiledRecordsFromUnfiledRecordFolder")
    public Object[][] getRecordsFromUnfiledRecordFolder() {
        UnfiledRecordFolderAPI unfiledRecordFoldersAPI = this.getRestAPIFactory().getUnfiledRecordFoldersAPI();
        return new String[][]{{unfiledRecordFoldersAPI.uploadRecord(this.electronicRecord, this.unfiledRecordFolderId, FilePlanComponentsUtil.createTempFile(TestData.ELECTRONIC_RECORD_NAME, TestData.ELECTRONIC_RECORD_NAME)).getId()}, {unfiledRecordFoldersAPI.createUnfiledRecordFolderChild(this.nonelectronicRecord, this.unfiledRecordFolderId).getId()}};
    }

    @Test(dataProvider="unfiledRecordsFromUnfiledRecordsContainer")
    @AlfrescoTest(jira="RM-7060")
    public void fileRecordFromUnfiledContainerToOpenFolder(String unfiledRecordId) throws Exception {
        Record recordFiled = this.fileRecordToFolder(unfiledRecordId, this.targetFolderId);
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertEquals((String)recordFiled.getParentId(), (String)this.targetFolderId);
        Assert.assertTrue((boolean)this.isRecordChildOfRecordFolder(unfiledRecordId, this.targetFolderId), (String)(unfiledRecordId + " is not filed to " + this.targetFolderId));
        Assert.assertFalse((boolean)this.isRecordChildOfUnfiledContainer(unfiledRecordId), (String)(unfiledRecordId + " exists in Unfiled Records"));
        Assert.assertTrue((boolean)this.hasAspect(unfiledRecordId, "rma:recordSearch"), (String)"recordSearch aspect is lost after filing!");
    }

    @Test(dataProvider="unfiledRecordsFromUnfiledRecordFolder")
    @AlfrescoTest(jira="RM-7060")
    public void fileRecordFromUnfiledRecordFolderToOpenFolder(String unfiledRecordId) throws Exception {
        Record recordFiled = this.fileRecordToFolder(unfiledRecordId, this.targetFolderId);
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertEquals((String)recordFiled.getParentId(), (String)this.targetFolderId);
        Assert.assertTrue((boolean)this.isRecordChildOfRecordFolder(unfiledRecordId, this.targetFolderId), (String)(unfiledRecordId + " is not filed to " + this.targetFolderId));
        Assert.assertFalse((boolean)this.isRecordChildOfUnfiledRecordFolder(unfiledRecordId), (String)(unfiledRecordId + " exists in " + this.unfiledRecordFolderId));
        Assert.assertTrue((boolean)this.hasAspect(unfiledRecordId, "rma:recordSearch"), (String)"recordSearch aspect is lost after filing!");
    }

    @Test(dataProvider="unfiledRecordsFromUnfiledRecordsContainer")
    public void fileRecordFromUnfiledContainerToClosedFolder(String unfiledRecordId) {
        this.fileRecordToFolder(unfiledRecordId, this.closedFolderId);
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        Assert.assertFalse((boolean)this.isRecordChildOfRecordFolder(unfiledRecordId, this.closedFolderId), (String)(unfiledRecordId + " is filed to " + this.closedFolderId));
        Assert.assertTrue((boolean)this.isRecordChildOfUnfiledContainer(unfiledRecordId), (String)(unfiledRecordId + " doesn't exist in Unfiled Records"));
    }

    @Test(dataProvider="unfiledRecordsFromUnfiledRecordFolder")
    public void fileRecordFromUnfiledRecordFolderToClosedFolder(String unfiledRecordId) {
        this.fileRecordToFolder(unfiledRecordId, this.closedFolderId);
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        Assert.assertFalse((boolean)this.isRecordChildOfRecordFolder(unfiledRecordId, this.closedFolderId), (String)(unfiledRecordId + " is filed to " + this.closedFolderId));
        Assert.assertTrue((boolean)this.isRecordChildOfUnfiledRecordFolder(unfiledRecordId), (String)(unfiledRecordId + " doesn't exist in " + this.unfiledRecordFolderId));
    }

    @Test(dataProvider="unfiledRecordsFromUnfiledRecordsContainer")
    @Bug(id="RM-4578")
    public void linkRecordInto(String unfiledRecordId) {
        Record recordFiled = this.fileRecordToFolder(unfiledRecordId, this.targetFolderId);
        this.assertStatusCode(HttpStatus.CREATED);
        Record recordLink = this.fileRecordToFolder(unfiledRecordId, this.folderToLink);
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertEquals((String)recordLink.getParentId(), (String)this.targetFolderId);
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        Assert.assertTrue((boolean)recordFolderAPI.getRecordFolderChildren(this.targetFolderId).getEntries().stream().anyMatch(c -> c.getEntry().getId().equals(recordFiled.getId()) && c.getEntry().getParentId().equals(this.targetFolderId)));
        Assert.assertTrue((boolean)recordFolderAPI.getRecordFolderChildren(this.folderToLink).getEntries().stream().anyMatch(c -> c.getEntry().getId().equals(recordFiled.getId()) && c.getEntry().getParentId().equals(this.targetFolderId) && !c.getEntry().getParentId().equals(this.folderToLink)));
    }

    @Test(dataProvider="invalidContainersToFile", description="File the unfiled record to the container that is not a record folder")
    public void invalidContainerToFile(String containerId) {
        UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
        UnfiledContainerChild recordElectronic = unfiledContainersAPI.uploadRecord(this.electronicRecord, "-unfiled-", FilePlanComponentsUtil.createTempFile(TestData.ELECTRONIC_RECORD_NAME, TestData.ELECTRONIC_RECORD_NAME));
        UnfiledContainerChild recordNonElect = unfiledContainersAPI.createUnfiledContainerChild(this.nonelectronicRecord, "-unfiled-");
        this.fileRecordToFolder(recordElectronic.getId(), containerId);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
        this.fileRecordToFolder(recordNonElect.getId(), containerId);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    private Record fileRecordToFolder(String recordId, String targetFolderId) {
        RecordBodyFile recordBodyFile = RecordBodyFile.builder().targetParentId(targetFolderId).build();
        return this.getRestAPIFactory().getRecordsAPI().fileRecord(recordBodyFile, recordId);
    }

    private boolean isRecordChildOfRecordFolder(String recordId, String recordFolderId) {
        return this.getRestAPIFactory().getRecordFolderAPI().getRecordFolderChildren(recordFolderId).getEntries().stream().anyMatch(c -> c.getEntry().getId().equals(recordId));
    }

    private boolean isRecordChildOfUnfiledRecordFolder(String recordId) {
        return this.getRestAPIFactory().getUnfiledRecordFoldersAPI().getUnfiledRecordFolderChildren(this.unfiledRecordFolderId).getEntries().stream().anyMatch(c -> c.getEntry().getId().equals(recordId));
    }

    private boolean isRecordChildOfUnfiledContainer(String recordId) {
        return this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainerChildren("-unfiled-").getEntries().stream().anyMatch(c -> c.getEntry().getId().equals(recordId));
    }
}

