/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.unfiledrecordfolders;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.DataProviderClass;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildCollection;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildProperties;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledRecordFolder;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledRecordFolderAPI;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.utility.data.RandomData;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class UnfiledRecordsFolderTests
extends BaseRMRestTest {
    public static final String ELECTRONIC_RECORD_NAME = RandomData.getRandomName((String)"Record electronic");
    public static final String NONELECTRONIC_RECORD_NAME = RandomData.getRandomName((String)"Record nonelectronic");
    private RecordCategory rootCategory;
    private UnfiledContainerChild unfiledRecordFolder;
    private UnfiledContainerChild rootUnfiledRecordFolder;
    private UnfiledContainerChild unfiledRecord;

    @BeforeClass(alwaysRun=true)
    public void preconditionUnfiledRecordsFolderTests() {
        this.rootCategory = this.createRootCategory(RandomData.getRandomName((String)"CATEGORY NAME"));
        this.rootUnfiledRecordFolder = this.createUnfiledContainerChild("-unfiled-", RandomData.getRandomName((String)"RootUnfiledRecFolder"), "rma:unfiledRecordFolder");
        this.unfiledRecord = this.createUnfiledContainerChild("-unfiled-", RandomData.getRandomName((String)"Unfiled Record"), "cm:content");
    }

    @DataProvider(name="validChildren")
    public Object[][] childrenForUnfiledRecord() {
        return new String[][]{{"rma:unfiledRecordFolder"}, {"cm:content"}, {"rma:nonElectronicDocument"}};
    }

    @DataProvider(name="invalidNodesForDelete")
    public Object[][] getInvalidNodes() {
        return new String[][]{{this.getRestAPIFactory().getFilePlansAPI().getFilePlan("-filePlan-").getId()}, {this.getRestAPIFactory().getUnfiledContainersAPI().getUnfiledContainer("-unfiled-").getId()}, {this.getRestAPIFactory().getTransferContainerAPI().getTransferContainer("-transfers-").getId()}, {this.rootCategory.getId()}, {this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recFolder")).getId()}, {this.unfiledRecord.getId()}};
    }

    @Test(description="Create a child into unfiled record folder based on the relativePath. Containers in the relativePath that do not exist are created before the node is created", dataProvider="validChildren")
    public void createUnfiledRecordFolderWithRelativePath(String nodeType) {
        String relativePath = LocalDateTime.now().getYear() + "/" + String.valueOf(LocalDateTime.now().getMonth()) + "/" + LocalDateTime.now().getDayOfMonth();
        UnfiledContainerChild unfiledChildModel = UnfiledContainerChild.builder().name(RandomData.getRandomName((String)"UnfiledRecordFolder")).nodeType(nodeType).relativePath(relativePath).build();
        UnfiledContainerChild unfiledRecordFolderChild = this.getRestAPIFactory().getUnfiledRecordFoldersAPI().createUnfiledRecordFolderChild(unfiledChildModel, this.rootUnfiledRecordFolder.getId(), "include=path");
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertEquals((String)unfiledRecordFolderChild.getNodeType(), (String)nodeType);
        Assert.assertTrue((boolean)unfiledRecordFolderChild.getPath().getName().contains(relativePath));
        Assert.assertEquals((String)this.getRestAPIFactory().getUnfiledRecordFoldersAPI().getUnfiledRecordFolder(unfiledRecordFolderChild.getParentId()).getNodeType(), (String)"rma:unfiledRecordFolder");
        String newRelativePath = LocalDateTime.now().getYear() + "/" + String.valueOf(LocalDateTime.now().getMonth()) + "/" + (LocalDateTime.now().getDayOfMonth() + 1);
        UnfiledContainerChild newUnfiledFolderModel = UnfiledContainerChild.builder().name(RandomData.getRandomName((String)"UnfiledRecordFolder")).nodeType(nodeType).relativePath(newRelativePath).build();
        UnfiledContainerChild newUnfiledRecordFolderChild = this.getRestAPIFactory().getUnfiledRecordFoldersAPI().createUnfiledRecordFolderChild(newUnfiledFolderModel, this.rootUnfiledRecordFolder.getId(), "include=path");
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertTrue((boolean)newUnfiledRecordFolderChild.getPath().getName().contains(newRelativePath));
        Assert.assertFalse((boolean)this.getRestAPIFactory().getUnfiledRecordFoldersAPI().getUnfiledRecordFolder(newUnfiledRecordFolderChild.getParentId()).equals((Object)"rma:unfiledRecordFolder"));
        Assert.assertEquals((String)newUnfiledRecordFolderChild.getNodeType(), (String)nodeType);
    }

    @Test(dataProvider="invalidRootTypes", dataProviderClass=DataProviderClass.class, description="Only unfiled records folders and records  can be created as children for unfiled container root")
    public void createInvalidUnfiledChildren(String filePlanComponentType) {
        UnfiledContainerChild unfiledFolderModel = FilePlanComponentsUtil.createUnfiledContainerChildModel(RandomData.getRandomName((String)"UnfiledRecFolder"), filePlanComponentType);
        this.getRestAPIFactory().getUnfiledRecordFoldersAPI().createUnfiledRecordFolderChild(unfiledFolderModel, this.rootUnfiledRecordFolder.getId());
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(description="Child unfiled records folder can be created in a parent unfiled records folder")
    public void childUnfiledRecordsFolderCanBeCreated() {
        String unfiledParentFolderName = "UnfiledParentFolder" + RandomData.getRandomAlphanumeric();
        String unfiledChildFolderName = "UnfiledChildFolder " + RandomData.getRandomAlphanumeric();
        UnfiledContainerChild unfiledParentFolder = this.createUnfiledRecordsFolderChild(this.rootUnfiledRecordFolder.getId(), unfiledParentFolderName, "rma:unfiledRecordFolder");
        Assert.assertEquals((String)unfiledParentFolderName, (String)unfiledParentFolder.getName());
        UnfiledContainerChild unfiledChildFolderModel = UnfiledContainerChild.builder().name(unfiledChildFolderName).nodeType("rma:unfiledRecordFolder").properties(UnfiledContainerChildProperties.builder().title("Title for " + unfiledChildFolderName).description("This is the description for" + unfiledChildFolderName).build()).build();
        UnfiledContainerChild unfiledChildFolder = this.getRestAPIFactory().getUnfiledRecordFoldersAPI().createUnfiledRecordFolderChild(unfiledChildFolderModel, unfiledParentFolder.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        Assert.assertTrue((boolean)unfiledChildFolder.getIsUnfiledRecordFolder());
        Assert.assertFalse((boolean)unfiledChildFolder.getIsRecord());
        Assert.assertEquals((String)unfiledChildFolder.getName(), (String)unfiledChildFolderName);
        Assert.assertEquals((String)unfiledChildFolder.getNodeType(), (String)"rma:unfiledRecordFolder");
        Assert.assertEquals((String)unfiledChildFolder.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
        UnfiledRecordFolder unfiledChildRecordFolder = this.getRestAPIFactory().getUnfiledRecordFoldersAPI().getUnfiledRecordFolder(unfiledChildFolder.getId());
        UnfiledContainerChildProperties unfiledChildFolderProperties = unfiledChildRecordFolder.getProperties();
        Assert.assertEquals((String)unfiledChildFolderProperties.getTitle(), (String)("Title for " + unfiledChildFolderName));
        Assert.assertEquals((String)unfiledChildFolderProperties.getDescription(), (String)("This is the description for" + unfiledChildFolderName));
        Assert.assertEquals((String)unfiledChildFolder.getParentId(), (String)unfiledParentFolder.getId());
        UnfiledContainerChildCollection parentsChildren = this.getRestAPIFactory().getUnfiledRecordFoldersAPI().getUnfiledRecordFolderChildren(unfiledParentFolder.getId());
        this.assertStatusCode(HttpStatus.OK);
        List childIds = parentsChildren.getEntries().stream().map(c -> c.getEntry().getId()).collect(Collectors.toList());
        Assert.assertTrue((boolean)childIds.contains(unfiledChildFolder.getId()));
        Assert.assertEquals((int)1, (int)childIds.size());
    }

    @Test(description="Unfiled record folder")
    public void editUnfiledRecordsFolder() {
        String modified = "Modified ";
        String unfiledFolderName = "UnfiledFolderToModify" + RandomData.getRandomAlphanumeric();
        UnfiledContainerChild unfiledFolderToModify = this.createUnfiledRecordsFolderChild(this.rootUnfiledRecordFolder.getId(), unfiledFolderName, "rma:unfiledRecordFolder");
        Assert.assertEquals((String)unfiledFolderName, (String)unfiledFolderToModify.getName());
        UnfiledRecordFolder unfiledChildFolderModel = UnfiledRecordFolder.builder().name(modified + unfiledFolderName).properties(UnfiledContainerChildProperties.builder().title(modified + unfiledFolderToModify.getProperties().getTitle()).description(modified + unfiledFolderToModify.getProperties().getDescription()).build()).build();
        UnfiledRecordFolder updatedRecordFolder = this.getRestAPIFactory().getUnfiledRecordFoldersAPI().updateUnfiledRecordFolder(unfiledChildFolderModel, unfiledFolderToModify.getId());
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((String)unfiledChildFolderModel.getName(), (String)updatedRecordFolder.getName());
        Assert.assertEquals((String)unfiledChildFolderModel.getProperties().getTitle(), (String)updatedRecordFolder.getProperties().getTitle());
        Assert.assertEquals((String)unfiledChildFolderModel.getProperties().getDescription(), (String)updatedRecordFolder.getProperties().getDescription());
        UnfiledRecordFolder renamedUnfiledFolder = this.getRestAPIFactory().getUnfiledRecordFoldersAPI().getUnfiledRecordFolder(unfiledFolderToModify.getId());
        Assert.assertEquals((String)(modified + unfiledFolderToModify.getName()), (String)renamedUnfiledFolder.getName());
        Assert.assertEquals((String)(modified + unfiledFolderToModify.getProperties().getTitle()), (String)renamedUnfiledFolder.getProperties().getTitle());
        Assert.assertEquals((String)(modified + unfiledFolderToModify.getProperties().getDescription()), (String)renamedUnfiledFolder.getProperties().getDescription());
    }

    @Test(description="Delete unfiled record folder")
    public void deleteUnfiledRecordsFolder() {
        String unfiledFolderName = "UnfiledFolderToDelete" + RandomData.getRandomAlphanumeric();
        String nonElectronicRecordName = "NonElectronicRecord" + RandomData.getRandomAlphanumeric();
        String electronicRecordName = "ElectronicRecord" + RandomData.getRandomAlphanumeric();
        UnfiledContainerChild unfiledFolderToDelete = this.createUnfiledRecordsFolderChild(this.rootUnfiledRecordFolder.getId(), unfiledFolderName, "rma:unfiledRecordFolder");
        Assert.assertEquals((String)unfiledFolderName, (String)unfiledFolderToDelete.getName());
        UnfiledContainerChild nonElectronicRecord = this.createUnfiledRecordsFolderChild(unfiledFolderToDelete.getId(), nonElectronicRecordName, "rma:nonElectronicDocument");
        Assert.assertEquals((String)nonElectronicRecord.getParentId(), (String)unfiledFolderToDelete.getId());
        UnfiledContainerChild electronicRecord = this.createUnfiledRecordsFolderChild(unfiledFolderToDelete.getId(), electronicRecordName, "cm:content");
        Assert.assertEquals((String)electronicRecord.getParentId(), (String)unfiledFolderToDelete.getId());
        this.getRestAPIFactory().getUnfiledRecordFoldersAPI().deleteUnfiledRecordFolder(unfiledFolderToDelete.getId());
        this.assertStatusCode(HttpStatus.NO_CONTENT);
        this.getRestAPIFactory().getUnfiledRecordFoldersAPI().getUnfiledRecordFolder(unfiledFolderToDelete.getId());
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @Test(description="Delete invalid nodes type with the DELETE unfiled record folders request", dataProvider="invalidNodesForDelete")
    public void deleteInvalidNodesUnfiled(String nodeId) {
        this.getRestAPIFactory().getUnfiledRecordFoldersAPI().deleteUnfiledRecordFolder(nodeId);
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test
    public void readRecordsFromUnfiledRecordFolder() {
        this.unfiledRecordFolder = this.createUnfiledContainerChild("-unfiled-", RandomData.getRandomName((String)"UnfiledRecordFolder"), "rma:unfiledRecordFolder");
        String containerId = this.unfiledRecordFolder.getId();
        UnfiledRecordFolderAPI unfiledRecordFoldersAPI = this.getRestAPIFactory().getUnfiledRecordFoldersAPI();
        ArrayList<UnfiledContainerChild> children = new ArrayList<UnfiledContainerChild>();
        for (int i = 0; i < 5; ++i) {
            UnfiledContainerChild record = UnfiledContainerChild.builder().name(ELECTRONIC_RECORD_NAME + i).nodeType("cm:content").build();
            UnfiledContainerChild child = unfiledRecordFoldersAPI.uploadRecord(record, containerId, FilePlanComponentsUtil.createTempFile(ELECTRONIC_RECORD_NAME + i, ELECTRONIC_RECORD_NAME + i));
            children.add(child);
            UnfiledContainerChild nonelectronicRecord = UnfiledContainerChild.builder().properties(UnfiledContainerChildProperties.builder().description("Description").title("Title").build()).name(NONELECTRONIC_RECORD_NAME + i).nodeType("rma:nonElectronicDocument").build();
            child = unfiledRecordFoldersAPI.createUnfiledRecordFolderChild(nonelectronicRecord, containerId);
            children.add(child);
        }
        UnfiledContainerChildCollection apiChildren = (UnfiledContainerChildCollection)unfiledRecordFoldersAPI.getUnfiledRecordFolderChildren(containerId, "include=properties").assertThat().entriesListIsNotEmpty();
        this.assertStatusCode(HttpStatus.OK);
        apiChildren.getEntries().forEach(c -> {
            UnfiledContainerChild record = c.getEntry();
            Assert.assertNotNull((Object)record.getId());
            this.logger.info((Object)("Checking child " + record.getId()));
            try {
                UnfiledContainerChild createdComponent = children.stream().filter(child -> child.getId().equals(record.getId())).findFirst().orElseThrow();
                Assert.assertEquals((String)record.getCreatedByUser().getId(), (String)this.getAdminUser().getUsername());
                Assert.assertEquals((String)record.getParentId(), (String)containerId);
                Assert.assertTrue((boolean)record.getIsRecord());
                Assert.assertFalse((boolean)record.getIsUnfiledRecordFolder());
                Assert.assertEquals((String)createdComponent.getName(), (String)record.getName(), (String)("The record name " + record.getName() + " is not equal with the record name returned when creating the record " + createdComponent.getName()));
                String identifier = " \\(" + record.getProperties().getIdentifier() + "\\)";
                String regex = "(" + NONELECTRONIC_RECORD_NAME + "|" + ELECTRONIC_RECORD_NAME + ")[0-9]+" + identifier;
                Assert.assertTrue((boolean)record.getName().matches(regex), (String)("The record name:" + record.getName() + " doesn't match the expression " + regex));
                Assert.assertTrue((boolean)createdComponent.getName().contains(createdComponent.getProperties().getIdentifier()));
                Assert.assertEquals((String)createdComponent.getNodeType(), (String)record.getNodeType());
            }
            catch (NoSuchElementException e) {
                Assert.fail((String)("No child element for " + record.getId()));
            }
        });
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.deleteRecordCategory(this.rootCategory.getId());
        this.getRestAPIFactory().getRecordsAPI().deleteRecord(this.unfiledRecord.getId());
        this.getRestAPIFactory().getUnfiledRecordFoldersAPI().deleteUnfiledRecordFolder(this.rootUnfiledRecordFolder.getId());
        this.getRestAPIFactory().getUnfiledRecordFoldersAPI().deleteUnfiledRecordFolder(this.unfiledRecordFolder.getId());
    }
}

