/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0;

import java.io.IOException;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.alfresco.dataprep.AlfrescoHttpClient;
import org.alfresco.dataprep.AlfrescoHttpClientFactory;
import org.alfresco.dataprep.UserService;
import org.alfresco.rest.core.v0.APIUtils;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.core.v0.RMEvents;
import org.alfresco.utility.data.DataUserAIS;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.testng.AssertJUnit;

@Component
public class RMRolesAndActionsAPI
extends BaseAPI {
    private static final String RM_ROLES = "{0}rma/admin/rmroles";
    private static final String RM_ROLES_ROLE = "{0}rma/admin/rmroles/{1}";
    private static final String RM_ROLES_AUTHORITIES = "{0}rm/roles/{1}/authorities/{2}?alf_ticket={3}";
    private static final Logger LOGGER = LoggerFactory.getLogger(RMRolesAndActionsAPI.class);
    private static final String MOVE_ACTIONS_API = "action/rm-move-to/site/rm/documentLibrary/{0}";
    @Autowired
    private AlfrescoHttpClientFactory alfrescoHttpClientFactory;
    @Autowired
    private UserService userService;
    @Autowired
    private DataUserAIS dataUser;

    public Set<String> getConfiguredRoles(String adminUser, String adminPassword) {
        JSONObject jsonObject = this.doGetRequest(adminUser, adminPassword, "{0}rma/admin/rmroles?is=true", new String[0]).getJSONObject("data");
        return jsonObject.toMap().keySet();
    }

    public Set<String> getCapabilitiesForRole(String adminUser, String adminPassword, String role) {
        JSONObject jsonObject = this.doGetRequest(adminUser, adminPassword, "{0}rma/admin/rmroles?is=true", new String[0]).getJSONObject("data");
        AssertJUnit.assertTrue((String)("Could not find role '" + role + "' in " + String.valueOf(jsonObject.keySet())), (boolean)jsonObject.has(role));
        return jsonObject.getJSONObject(role).getJSONObject("capabilities").keySet();
    }

    private JSONObject roleRequestBody(String roleName, String roleDisplayLabel, Set<String> capabilities) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("name", (Object)roleName);
        requestBody.put("displayLabel", (Object)roleDisplayLabel);
        JSONArray capabilitiesArray = new JSONArray();
        capabilities.forEach(arg_0 -> ((JSONArray)capabilitiesArray).put(arg_0));
        requestBody.put("capabilities", (Object)capabilitiesArray);
        return requestBody;
    }

    public void createRole(String adminUser, String adminPassword, String roleName, String roleDisplayLabel, Set<String> capabilities) {
        this.doPostJsonRequest(adminUser, adminPassword, 200, this.roleRequestBody(roleName, roleDisplayLabel, capabilities), RM_ROLES, new String[0]);
    }

    public void updateRole(String adminUser, String adminPassword, String roleName, String roleDisplayLabel, Set<String> capabilities) {
        this.doPutJsonRequest(adminUser, adminPassword, 200, this.roleRequestBody(roleName, roleDisplayLabel, capabilities), RM_ROLES_ROLE, roleName);
    }

    public void deleteRole(String adminUser, String adminPassword, String roleName) {
        this.doDeleteRequest(adminUser, adminPassword, MessageFormat.format(RM_ROLES_ROLE, "{0}", roleName), new String[0]);
        AssertJUnit.assertFalse((String)("Failed to delete role " + roleName + " with " + adminUser), (boolean)this.getConfiguredRoles(adminUser, adminPassword).contains(roleName));
    }

    public void createUserAndAssignToRole(String adminUser, String adminPassword, String userName, String password, String role) {
        if (!this.userService.userExists(adminUser, adminPassword, userName)) {
            this.dataUser.createUser(userName, password);
        }
        this.assignRoleToUser(adminUser, adminPassword, userName, role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignRoleToUser(String adminUser, String adminPassword, String userName, String role) {
        HttpResponse response;
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        String reqURL = MessageFormat.format(RM_ROLES_AUTHORITIES, client.getApiUrl(), role, userName, client.getAlfTicket(adminUser, adminPassword));
        HttpPost request = null;
        try {
            request = new HttpPost(reqURL);
            response = client.execute(adminUser, adminPassword, (HttpRequestBase)request);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
            client.close();
        }
        AssertJUnit.assertEquals((String)("Assigning role " + role + " to user " + userName + " failed."), (int)200, (int)response.getStatusLine().getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void moveTo(String user, String password, String contentPath, String destinationPath) {
        contentNodeRef = RMRolesAndActionsAPI.getNodeRefSpacesStore() + this.getItemNodeRef(user, password, contentPath);
        client = this.alfrescoHttpClientFactory.getObject();
        url = MessageFormat.format(client.getAlfrescoUrl() + "alfresco/s/slingshot/doclib/action/rm-move-to/site/rm/documentLibrary/{0}", new Object[]{destinationPath});
        request = new HttpPost(url);
        success = false;
        try {
            body = new JSONObject();
            body.put("nodeRefs", (Object)new JSONArray(Arrays.asList(new String[]{contentNodeRef})));
            se = new StringEntity(body.toString(), "UTF-8");
            se.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
            request.setEntity((HttpEntity)se);
            response = client.execute(user, password, (HttpRequestBase)request);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    json = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
                    success = (Boolean)json.get("overallSuccess");
                    ** break;
lbl19:
                    // 1 sources

                    break;
                }
                case 404: {
                    RMRolesAndActionsAPI.LOGGER.info("The provided paths couldn't be found " + response.toString());
                    ** break;
lbl23:
                    // 1 sources

                    break;
                }
                default: {
                    RMRolesAndActionsAPI.LOGGER.error("Unable to move: " + response.toString());
                    break;
                }
            }
        }
        catch (IOException | JSONException e) {
            RMRolesAndActionsAPI.LOGGER.error(e.toString());
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
            client.close();
        }
        AssertJUnit.assertTrue((String)("Moving " + contentPath + " to " + destinationPath + " failed."), (boolean)success);
    }

    public void moveToAndExpectFailure(String user, String password, String contentPath, String destinationPath) {
        try {
            this.moveTo(user, password, contentPath, destinationPath);
        }
        catch (AssertionError e) {
            return;
        }
        AssertJUnit.fail((String)("Moving " + contentPath + " to " + destinationPath + " succeeded unexpectedly."));
    }

    public HttpResponse executeAction(String user, String password, String contentName, BaseAPI.RM_ACTIONS action) {
        return this.executeAction(user, password, contentName, action, null, 200);
    }

    public HttpResponse executeActionAndExpectResponseCode(String user, String password, String contentName, BaseAPI.RM_ACTIONS action, int status) {
        return this.executeAction(user, password, contentName, action, null, status);
    }

    public HttpResponse executeAction(String user, String password, String contentName, BaseAPI.RM_ACTIONS action, ZonedDateTime date) {
        return this.executeAction(user, password, contentName, action, date, 200);
    }

    private JSONObject actionsRequestBody(String user, String password, String contentName, BaseAPI.RM_ACTIONS action, JSONObject actionsParams) {
        String recNodeRef = RMRolesAndActionsAPI.getNodeRefSpacesStore() + this.contentService.getNodeRef(user, password, "rm", contentName);
        JSONObject requestParams = new JSONObject();
        requestParams.put("name", (Object)action.getAction());
        requestParams.put("nodeRef", (Object)recNodeRef);
        if (actionsParams != null) {
            requestParams.put("params", (Object)actionsParams);
        }
        return requestParams;
    }

    public HttpResponse executeAction(String user, String password, String contentName, BaseAPI.RM_ACTIONS action, ZonedDateTime date, int status) {
        JSONObject actionParams = new JSONObject();
        if (date != null) {
            actionParams.put("asOfDate", (Object)new JSONObject().put("iso8601", (Object)APIUtils.ISO_INSTANT_FORMATTER.format(date)));
        }
        JSONObject requestParams = this.actionsRequestBody(user, password, contentName, action, actionParams);
        return this.doPostJsonRequest(user, password, status, requestParams, "{0}rma/actions/ExecutionQueue", new String[0]);
    }

    public HttpResponse completeEvent(String user, String password, String nodeName, RMEvents event, Instant date) {
        date = date != null ? date : Instant.now();
        JSONObject actionParams = new JSONObject().put("eventName", (Object)event.getEventName()).put("eventCompletedBy", (Object)user).put("eventCompletedAt", (Object)new JSONObject().put("iso8601", (Object)APIUtils.ISO_INSTANT_FORMATTER.format(date)));
        JSONObject requestParams = this.actionsRequestBody(user, password, nodeName, BaseAPI.RM_ACTIONS.COMPLETE_EVENT, actionParams);
        return this.doPostJsonRequest(user, password, 200, requestParams, "{0}rma/actions/ExecutionQueue", new String[0]);
    }

    public HttpResponse undoEvent(String user, String password, String contentName, RMEvents event) {
        JSONObject requestParams = this.actionsRequestBody(user, password, contentName, BaseAPI.RM_ACTIONS.UNDO_EVENT, new JSONObject().put("eventName", (Object)event.getEventName()));
        return this.doPostJsonRequest(user, password, 200, requestParams, "{0}rma/actions/ExecutionQueue", new String[0]);
    }

    public void deleteAllItemsInContainer(String username, String password, String siteId, String containerName) {
        for (CmisObject item : this.contentService.getFolderObject(this.contentService.getCMISSession(username, password), siteId, containerName).getChildren()) {
            item.delete();
        }
        AssertJUnit.assertFalse((String)("Not all items were deleted from " + containerName), (boolean)this.contentService.getFolderObject(this.contentService.getCMISSession(username, password), siteId, containerName).getChildren().getHasMoreItems());
    }

    public HttpResponse updateMetadata(String username, String password, String itemNodeRef, Map<BaseAPI.RMProperty, String> properties) {
        JSONObject requestParams = new JSONObject();
        this.addPropertyToRequest(requestParams, "prop_cm_name", properties, BaseAPI.RMProperty.NAME);
        this.addPropertyToRequest(requestParams, "prop_cm_title", properties, BaseAPI.RMProperty.TITLE);
        this.addPropertyToRequest(requestParams, "prop_cm_description", properties, BaseAPI.RMProperty.DESCRIPTION);
        this.addPropertyToRequest(requestParams, "prop_cm_author", properties, BaseAPI.RMProperty.AUTHOR);
        this.addPropertyToRequest(requestParams, "prop_dod_originator", properties, BaseAPI.RMProperty.ORIGINATOR);
        this.addPropertyToRequest(requestParams, "prop_dod_originatingOrganization", properties, BaseAPI.RMProperty.ORIGINATING_ORGANIZATION);
        this.addPropertyToRequest(requestParams, "prop_dod_publicationDate", properties, BaseAPI.RMProperty.PUBLICATION_DATE);
        return this.doPostJsonRequest(username, password, 200, requestParams, MessageFormat.format("{0}node/{1}/formprocessor", "{0}", itemNodeRef), new String[0]);
    }
}

