/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0.service;

import java.util.HashMap;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.rm.community.model.recordcategory.RetentionPeriodProperty;
import org.alfresco.rest.v0.RecordCategoriesAPI;
import org.alfresco.utility.data.DataUserAIS;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DispositionScheduleService
extends BaseAPI {
    @Autowired
    private RecordCategoriesAPI recordCategoriesAPI;
    @Autowired
    private DataUserAIS dataUser;

    public void addRetainAfterPeriodStep(String categoryName, String period) {
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> retainStep = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        retainStep.put(BaseAPI.RETENTION_SCHEDULE.NAME, "retain");
        retainStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD, period);
        retainStep.put(BaseAPI.RETENTION_SCHEDULE.DESCRIPTION, "Retain after a period step");
        this.recordCategoriesAPI.addDispositionScheduleSteps(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), categoryName, retainStep);
    }

    public void addCutOffImmediatelyStep(String categoryName) {
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> cutOffStep = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.NAME, "cutoff");
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD, "immediately");
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.DESCRIPTION, "Cut off immediately step");
        this.recordCategoriesAPI.addDispositionScheduleSteps(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), categoryName, cutOffStep);
    }

    public void addCutOffAfterPeriodStep(String categoryName, String period, RetentionPeriodProperty periodProperty) {
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> cutOffStep = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.NAME, "cutoff");
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD, period);
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD_PROPERTY, periodProperty.getPeriodProperty());
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.DESCRIPTION, "Cut off after a period step");
        this.recordCategoriesAPI.addDispositionScheduleSteps(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), categoryName, cutOffStep);
    }

    public void addDestroyWithGhostingImmediatelyAfterCutOff(String categoryName) {
        this.addDestroyWithGhostingAfterPeriodStep(categoryName, "immediately", RetentionPeriodProperty.CUT_OFF_DATE);
    }

    public void addDestroyWithGhostingAfterPeriodStep(String categoryName, String period, RetentionPeriodProperty periodProperty) {
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> destroyStep = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        destroyStep.put(BaseAPI.RETENTION_SCHEDULE.NAME, "destroy");
        destroyStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD, period);
        destroyStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD_PROPERTY, periodProperty.getPeriodProperty());
        destroyStep.put(BaseAPI.RETENTION_SCHEDULE.DESCRIPTION, "Destroy after a period step with keep metadata");
        destroyStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_GHOST, "on");
        this.recordCategoriesAPI.addDispositionScheduleSteps(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), categoryName, destroyStep);
    }

    public void addDestroyWithoutGhostingAfterPeriodStep(String categoryName, String period, RetentionPeriodProperty periodProperty) {
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> destroyStep = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        destroyStep.put(BaseAPI.RETENTION_SCHEDULE.NAME, "destroy");
        destroyStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD, period);
        destroyStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD_PROPERTY, periodProperty.getPeriodProperty());
        destroyStep.put(BaseAPI.RETENTION_SCHEDULE.DESCRIPTION, "Destroy after a period step");
        this.recordCategoriesAPI.addDispositionScheduleSteps(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), categoryName, destroyStep);
    }

    public void addCutOffAfterEventStep(String categoryName, String events) {
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> cutOffStep = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.NAME, "cutoff");
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_EVENTS, events);
        cutOffStep.put(BaseAPI.RETENTION_SCHEDULE.DESCRIPTION, "Cut off after event step");
        this.recordCategoriesAPI.addDispositionScheduleSteps(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), categoryName, cutOffStep);
    }

    public void addTransferAfterEventStep(String categoryName, String location, String events) {
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> transferStep = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.NAME, "transfer");
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_LOCATION, location);
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_EVENTS, events);
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.DESCRIPTION, "Transfer after event step");
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.COMBINE_DISPOSITION_STEP_CONDITIONS, "false");
        transferStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_ELIGIBLE_FIRST_EVENT, "true");
        this.recordCategoriesAPI.addDispositionScheduleSteps(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), categoryName, transferStep);
    }

    public void addAccessionStep(String categoryName, Boolean timeOrEvent, String events, String period, RetentionPeriodProperty periodProperty, Boolean combineConditions) {
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> accessionStep = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        accessionStep.put(BaseAPI.RETENTION_SCHEDULE.NAME, "accession");
        accessionStep.put(BaseAPI.RETENTION_SCHEDULE.COMBINE_DISPOSITION_STEP_CONDITIONS, Boolean.toString(combineConditions));
        accessionStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD, period);
        accessionStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_PERIOD_PROPERTY, periodProperty.getPeriodProperty());
        if (!timeOrEvent.booleanValue()) {
            accessionStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_ELIGIBLE_FIRST_EVENT, Boolean.toString(timeOrEvent));
        }
        accessionStep.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_EVENTS, events);
        accessionStep.put(BaseAPI.RETENTION_SCHEDULE.DESCRIPTION, "Accession step with time and event conditions.");
        this.recordCategoriesAPI.addDispositionScheduleSteps(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), categoryName, accessionStep);
    }

    public void createCategoryRetentionSchedule(UserModel user, String categoryName, Boolean appliedToRecords) {
        this.recordCategoriesAPI.createRetentionSchedule(user.getUsername(), user.getPassword(), categoryName);
        String retentionScheduleNodeRef = this.recordCategoriesAPI.getDispositionScheduleNodeRef(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), categoryName);
        HashMap<BaseAPI.RETENTION_SCHEDULE, String> retentionScheduleGeneralFields = new HashMap<BaseAPI.RETENTION_SCHEDULE, String>();
        retentionScheduleGeneralFields.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_AUTHORITY, "Authority");
        retentionScheduleGeneralFields.put(BaseAPI.RETENTION_SCHEDULE.RETENTION_INSTRUCTIONS, "Instructions");
        this.recordCategoriesAPI.setRetentionScheduleGeneralFields(this.dataUser.getAdminUser().getUsername(), this.dataUser.getAdminUser().getPassword(), retentionScheduleNodeRef, retentionScheduleGeneralFields, appliedToRecords);
    }

    public void createCategoryRetentionSchedule(String categoryName, Boolean appliedToRecords) {
        this.createCategoryRetentionSchedule(this.dataUser.getAdminUser(), categoryName, appliedToRecords);
    }
}

