/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildProperties;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledContainerAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledRecordFolderAPI;
import org.alfresco.rest.rm.community.utils.AlfrescoRetryAnalyzer;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class UpdateRecordsTests
extends BaseRMRestTest {
    @Autowired
    private RoleService roleService;
    private RecordCategory rootCategory;
    private UnfiledContainerChild unfiledRecordFolder;
    private final List<UnfiledContainerChild> unfiledRecords = new ArrayList<UnfiledContainerChild>();
    private UserModel updateUser;

    @BeforeClass(alwaysRun=true)
    public void preconditionUpdateRecordsTests() {
        this.rootCategory = this.createRootCategory(RandomData.getRandomName((String)"CATEGORY NAME"));
        this.unfiledRecordFolder = this.createUnfiledContainerChild("-unfiled-", RandomData.getRandomName((String)"UnfiledRecordFolder"), "rma:unfiledRecordFolder");
        this.updateUser = this.roleService.createUserWithRMRoleAndCategoryPermission(UserRoles.ROLE_RM_SECURITY_OFFICER.roleId, this.rootCategory, UserPermissions.PERMISSION_FILING);
    }

    @DataProvider(name="incompleteRecords")
    public Object[][] getIncompleteRecords() {
        String recordFolderId = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recFolder1")).getId();
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        Record electronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), recordFolderId, FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.CREATED);
        Record nonElectronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createNonElectronicRecordModel(), recordFolderId);
        this.assertStatusCode(HttpStatus.CREATED);
        UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
        UnfiledContainerChild electronicRecord1 = unfiledContainersAPI.uploadRecord(FilePlanComponentsUtil.createElectronicUnfiledContainerChildModel(), "-unfiled-", FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.CREATED);
        this.unfiledRecords.add(electronicRecord1);
        UnfiledContainerChild nonElectronicRecord1 = unfiledContainersAPI.createUnfiledContainerChild(FilePlanComponentsUtil.createNonElectronicUnfiledContainerChildModel(), "-unfiled-");
        this.assertStatusCode(HttpStatus.CREATED);
        this.unfiledRecords.add(nonElectronicRecord1);
        UnfiledRecordFolderAPI unfiledRecordFoldersAPI = this.getRestAPIFactory().getUnfiledRecordFoldersAPI();
        UnfiledContainerChild electronicRecord2 = unfiledRecordFoldersAPI.uploadRecord(FilePlanComponentsUtil.createElectronicUnfiledContainerChildModel(), this.unfiledRecordFolder.getId(), FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.CREATED);
        UnfiledContainerChild nonElectronicRecord2 = unfiledRecordFoldersAPI.createUnfiledRecordFolderChild(FilePlanComponentsUtil.createNonElectronicUnfiledContainerChildModel(), this.unfiledRecordFolder.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        return new String[][]{{electronicRecord.getId()}, {nonElectronicRecord.getId()}, {electronicRecord1.getId()}, {nonElectronicRecord1.getId()}, {electronicRecord2.getId()}, {nonElectronicRecord2.getId()}};
    }

    @DataProvider(name="completeRecords")
    public Object[][] getCompleteRecords() {
        String recordFolderId = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recFolder2")).getId();
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        Record electronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), recordFolderId, FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.CREATED);
        this.completeRecord(electronicRecord.getId());
        Record nonElectronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createNonElectronicRecordModel(), recordFolderId);
        this.assertStatusCode(HttpStatus.CREATED);
        this.completeRecord(nonElectronicRecord.getId());
        UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
        UnfiledContainerChild electronicRecord1 = unfiledContainersAPI.uploadRecord(FilePlanComponentsUtil.createElectronicUnfiledContainerChildModel(), "-unfiled-", FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.CREATED);
        this.completeRecord(electronicRecord1.getId());
        this.unfiledRecords.add(electronicRecord1);
        UnfiledContainerChild nonElectronicRecord1 = unfiledContainersAPI.createUnfiledContainerChild(FilePlanComponentsUtil.createNonElectronicUnfiledContainerChildModel(), "-unfiled-");
        this.assertStatusCode(HttpStatus.CREATED);
        this.completeRecord(nonElectronicRecord1.getId());
        this.unfiledRecords.add(nonElectronicRecord1);
        UnfiledRecordFolderAPI unfiledRecordFoldersAPI = this.getRestAPIFactory().getUnfiledRecordFoldersAPI();
        UnfiledContainerChild electronicRecord2 = unfiledRecordFoldersAPI.uploadRecord(FilePlanComponentsUtil.createElectronicUnfiledContainerChildModel(), this.unfiledRecordFolder.getId(), FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.CREATED);
        this.completeRecord(electronicRecord2.getId());
        UnfiledContainerChild nonElectronicRecord2 = unfiledRecordFoldersAPI.createUnfiledRecordFolderChild(FilePlanComponentsUtil.createNonElectronicUnfiledContainerChildModel(), this.unfiledRecordFolder.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        this.completeRecord(nonElectronicRecord2.getId());
        return new String[][]{{electronicRecord.getId(), nonElectronicRecord.getId()}, {electronicRecord1.getId(), nonElectronicRecord1.getId()}, {electronicRecord2.getId(), nonElectronicRecord2.getId()}};
    }

    @Test(dataProvider="incompleteRecords", description="Incomplete records can be updated")
    @AlfrescoTest(jira="RM-4362")
    public void incompleteRecordsCanBeUpdated(String recordId) {
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        Record record = recordsAPI.getRecord(recordId);
        String newName = this.getModifiedPropertyValue(record.getName());
        String newTitle = this.getModifiedPropertyValue(record.getProperties().getTitle());
        String newDescription = this.getModifiedPropertyValue(record.getProperties().getDescription());
        recordsAPI.updateRecord(FilePlanComponentsUtil.createRecordModel(newName, newDescription, newTitle), record.getId());
        this.assertStatusCode(HttpStatus.OK);
        Record updatedRecord = recordsAPI.getRecord(record.getId());
        Assert.assertEquals((String)updatedRecord.getName(), (String)newName);
        Assert.assertEquals((String)updatedRecord.getProperties().getTitle(), (String)newTitle);
        Assert.assertEquals((String)updatedRecord.getProperties().getDescription(), (String)newDescription);
    }

    @Test(description="User with Edit Metadata capabilities can update incomplete record's metadata")
    @AlfrescoTest(jira="RM-4362")
    public void userWithEditMetadataCapsCanUpdateMetadata() {
        RecordCategoryChild recFolder = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recFolder"));
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        Record electronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), recFolder.getId(), FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.CREATED);
        Record nonElectronicRecord = recordFolderAPI.createRecord(FilePlanComponentsUtil.createNonElectronicRecordModel(), recFolder.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI(this.updateUser);
        for (Record record : Arrays.asList(electronicRecord, nonElectronicRecord)) {
            recordsAPI.getRecord(record.getId());
            this.assertStatusCode(HttpStatus.OK);
            String newName = this.getModifiedPropertyValue(record.getName());
            String newTitle = this.getModifiedPropertyValue(record.getProperties().getTitle());
            String newDescription = this.getModifiedPropertyValue(record.getProperties().getDescription());
            recordsAPI.updateRecord(FilePlanComponentsUtil.createRecordModel(newName, newDescription, newTitle), record.getId());
            this.assertStatusCode(HttpStatus.OK);
            Record updatedRecord = recordsAPI.getRecord(record.getId());
            Assert.assertEquals((String)updatedRecord.getName(), (String)newName);
            Assert.assertEquals((String)updatedRecord.getProperties().getTitle(), (String)newTitle);
            Assert.assertEquals((String)updatedRecord.getProperties().getDescription(), (String)newDescription);
            Assert.assertEquals((String)updatedRecord.getModifiedByUser().getId(), (String)this.updateUser.getUsername());
        }
    }

    @Test(dataProvider="completeRecords", description="Complete records can't be updated", retryAnalyzer=AlfrescoRetryAnalyzer.class)
    @AlfrescoTest(jira="RM-4362")
    @Bug(id="APPS-132")
    public void completeRecordsCantBeUpdated(String electronicRecordId, String nonElectronicRecordId) {
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        Record electronicRecord = recordsAPI.getRecord(electronicRecordId);
        Record nonElectronicRecord = recordsAPI.getRecord(nonElectronicRecordId);
        for (Record record : Arrays.asList(electronicRecord, nonElectronicRecord)) {
            String newName = this.getModifiedPropertyValue(record.getName());
            String newTitle = this.getModifiedPropertyValue(record.getProperties().getTitle());
            String newDescription = this.getModifiedPropertyValue(record.getProperties().getDescription());
            Record recordModel = FilePlanComponentsUtil.createRecordModel(newName, newDescription, newTitle);
            recordsAPI.updateRecord(recordModel, record.getId());
            this.assertStatusCode(HttpStatus.FORBIDDEN);
            Record updatedRecord = recordsAPI.getRecord(record.getId());
            Assert.assertEquals((String)updatedRecord.getName(), (String)record.getName());
            Assert.assertEquals((String)updatedRecord.getProperties().getTitle(), (String)record.getProperties().getTitle());
            Assert.assertEquals((String)updatedRecord.getProperties().getDescription(), (String)record.getProperties().getDescription());
        }
    }

    private String getModifiedPropertyValue(String originalValue) {
        String MODIFIED_PREFIX = "modified_";
        return MODIFIED_PREFIX + originalValue;
    }

    @Test(description="Cannot remove mandatory aspects from record")
    @AlfrescoTest(jira="RM-4926")
    public void electronicRecordMandatoryAspectsCannotBeRemoved() {
        List<String> expectedAspects = Arrays.asList("rma:record", "rma:filePlanComponent", "rma:recordComponentIdentifier", "rma:commonRecordDetails");
        ArrayList emptyAspectList = new ArrayList();
        Record recordModelToUpdate = Record.builder().aspectNames(emptyAspectList).build();
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        String recordFolderId = this.createRecordFolder(this.rootCategory.getId(), RandomData.getRandomName((String)"recordFolder")).getId();
        Record electronicRecord = this.getRestAPIFactory().getRecordFolderAPI().createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), recordFolderId, FilePlanComponentsUtil.getFile("money.JPG"));
        Assert.assertTrue((boolean)electronicRecord.getAspectNames().containsAll(expectedAspects));
        recordsAPI.updateRecord(recordModelToUpdate, electronicRecord.getId());
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
        UnfiledContainerChild unfiledRecordModel = UnfiledContainerChild.builder().properties(UnfiledContainerChildProperties.builder().description(TestData.NONELECTRONIC_RECORD_NAME).title("Title").build()).name(TestData.NONELECTRONIC_RECORD_NAME).nodeType("rma:nonElectronicDocument").build();
        UnfiledContainerChild unfiledRecord = this.getRestAPIFactory().getUnfiledRecordFoldersAPI().createUnfiledRecordFolderChild(unfiledRecordModel, this.unfiledRecordFolder.getId());
        Assert.assertTrue((boolean)unfiledRecord.getAspectNames().containsAll(expectedAspects));
        recordsAPI.updateRecord(recordModelToUpdate, unfiledRecord.getId());
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.deleteRecordCategory(this.rootCategory.getId());
        this.getRestAPIFactory().getUnfiledRecordFoldersAPI().deleteUnfiledRecordFolder(this.unfiledRecordFolder.getId());
        this.unfiledRecords.forEach(unfiledRecord -> this.getRestAPIFactory().getRecordsAPI().deleteRecord(unfiledRecord.getId()));
        this.getDataUser().deleteUser(this.updateUser);
    }
}

