/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.audit.AuditEvents;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.rest.v0.service.RMAuditService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.UserModel;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class AuditAccessTests
extends BaseRMRestTest {
    private Optional<UserModel> deletedUser;
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(AuditAccessTests.class);
    private static final String DELETE_USER_EVENT = "Delete User";
    private final String record1 = this.TEST_PREFIX + "RM-2967 uploaded record";
    private final String classifiedRecord = this.TEST_PREFIX + "RM-2967 classified record";
    private final String folderName = this.TEST_PREFIX + "RM-2967 folder";
    private final String categoryName = this.TEST_PREFIX + "RM-2967 category";
    private final String editedCategoryName = "edited " + this.categoryName;
    private final String editedFolderName = "edited " + this.folderName;
    private final String editedRecordName = "edited " + this.record1;
    private final String login_successfull = "Login Successful";
    private RecordCategory categoryAll;
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RecordsAPI recordsAPI;
    @Autowired
    private RMAuditService rmAuditService;

    @Test(priority=1)
    @AlfrescoTest(jira="RM-2967")
    public void deleteRMUsersShowFullAuditTest() {
        this.createTestPrecondition();
        this.updateCategoryMetadata();
        this.updateFolderMetadata();
        this.updateRecordMetadata();
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(this.deletedUser.get().getUsername(), this.deletedUser.get().getPassword(), "rm", this.editedFolderName);
        this.rmRolesAndActionsAPI.deleteAllItemsInContainer(this.deletedUser.get().getUsername(), this.deletedUser.get().getPassword(), "rm", this.editedCategoryName);
        Optional.of(this.deletedUser).ifPresent(x -> this.getDataUser().deleteUser((UserModel)x.get()));
        List auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(((DataUser)this.getDataUser().usingAdmin()).getAdminUser(), AuditEvents.DELETE_PERSON);
        AssertJUnit.assertTrue((String)"Delete user event not found in the audit log.", (boolean)auditEntries.stream().anyMatch(auditEntry -> auditEntry.getEvent().equals(DELETE_USER_EVENT)));
    }

    @Test(priority=2)
    public void filterEventsByLoginSuccessful() {
        this.createRMSiteIfNotExists();
        List auditEntries = this.rmAuditService.getAuditEntriesFilteredByEvent(((DataUser)this.getDataUser().usingAdmin()).getAdminUser(), AuditEvents.LOGIN_SUCCESSFUL);
        Assert.assertFalse((String)"Audit results should contain at least one Login Successful event", (boolean)auditEntries.isEmpty());
        AssertJUnit.assertTrue((String)"Audit results contain only Login Successful events", (boolean)auditEntries.stream().allMatch(e -> e.getEvent().startsWith(AuditEvents.LOGIN_SUCCESSFUL.toString()) || e.getEvent().startsWith("Login Successful")));
    }

    private void createTestPrecondition() {
        this.createRMSiteIfNotExists();
        this.createDeletedUser();
        this.categoryAll = this.createCategoryIfDoesNotExist(this.categoryName, this.deletedUser.get());
        this.createRecordFolderInCategory(this.folderName, this.categoryAll, this.deletedUser.get());
        this.recordsAPI.uploadElectronicRecord(this.deletedUser.get().getUsername(), this.deletedUser.get().getPassword(), this.getDefaultElectronicRecordProperties(this.record1), this.folderName, CMISUtil.DocumentType.TEXT_PLAIN);
        this.recordsAPI.uploadElectronicRecord(this.deletedUser.get().getUsername(), this.deletedUser.get().getPassword(), this.getDefaultElectronicRecordProperties(this.classifiedRecord), this.folderName, CMISUtil.DocumentType.TEXT_PLAIN);
    }

    private void createDeletedUser() {
        this.deletedUser = Optional.ofNullable(this.getDataUser().createRandomTestUser());
        this.rmRolesAndActionsAPI.assignRoleToUser(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.deletedUser.get().getUsername(), "Administrator");
    }

    private void updateCategoryMetadata() {
        HashMap<BaseAPI.RMProperty, String> categoryProperties = new HashMap<BaseAPI.RMProperty, String>();
        categoryProperties.put(BaseAPI.RMProperty.NAME, this.editedCategoryName);
        categoryProperties.put(BaseAPI.RMProperty.TITLE, "edited Title");
        categoryProperties.put(BaseAPI.RMProperty.DESCRIPTION, "edited Description");
        String categoryNodeRef = "workspace/SpacesStore/" + this.rmRolesAndActionsAPI.getItemNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "/" + this.categoryName);
        this.rmRolesAndActionsAPI.updateMetadata(this.deletedUser.get().getUsername(), this.deletedUser.get().getPassword(), categoryNodeRef, categoryProperties);
    }

    private void updateFolderMetadata() {
        HashMap<BaseAPI.RMProperty, String> folderProperties = new HashMap<BaseAPI.RMProperty, String>();
        folderProperties.put(BaseAPI.RMProperty.NAME, this.editedFolderName);
        folderProperties.put(BaseAPI.RMProperty.TITLE, "edited Title");
        folderProperties.put(BaseAPI.RMProperty.DESCRIPTION, "edited Description");
        String folderNodeRef = "workspace/SpacesStore/" + this.rmRolesAndActionsAPI.getItemNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "/" + this.editedCategoryName + "/" + this.folderName);
        this.rmRolesAndActionsAPI.updateMetadata(this.deletedUser.get().getUsername(), this.deletedUser.get().getPassword(), folderNodeRef, folderProperties);
    }

    private void updateRecordMetadata() {
        HashMap<BaseAPI.RMProperty, String> recordProperties = new HashMap<BaseAPI.RMProperty, String>();
        recordProperties.put(BaseAPI.RMProperty.NAME, this.editedRecordName);
        recordProperties.put(BaseAPI.RMProperty.TITLE, "edited Title");
        recordProperties.put(BaseAPI.RMProperty.AUTHOR, "edited author");
        recordProperties.put(BaseAPI.RMProperty.DESCRIPTION, "edited Description");
        String recordName = this.recordsAPI.getRecordFullName(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.editedFolderName, this.record1);
        String recordNodeRef = "workspace/SpacesStore/" + this.rmRolesAndActionsAPI.getItemNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), "/" + this.editedCategoryName + "/" + this.editedFolderName + "/" + recordName);
        this.rmRolesAndActionsAPI.updateMetadata(this.deletedUser.get().getUsername(), this.deletedUser.get().getPassword(), recordNodeRef, recordProperties);
    }

    private RecordCategory createCategoryIfDoesNotExist(String CATEGORY_ALL, UserModel deletedUser) {
        return this.createRootCategory(deletedUser, CATEGORY_ALL);
    }

    private RecordCategoryChild createRecordFolderInCategory(String FOLDER_SEARCH, RecordCategory recordCategory, UserModel deletedUser) {
        return this.createFolder(deletedUser, recordCategory.getId(), FOLDER_SEARCH);
    }

    private Map<BaseAPI.RMProperty, String> getDefaultElectronicRecordProperties(String recordName) {
        HashMap<BaseAPI.RMProperty, String> defaultProperties = new HashMap<BaseAPI.RMProperty, String>();
        defaultProperties.put(BaseAPI.RMProperty.NAME, recordName);
        defaultProperties.put(BaseAPI.RMProperty.TITLE, "Title");
        defaultProperties.put(BaseAPI.RMProperty.DESCRIPTION, "Description");
        defaultProperties.put(BaseAPI.RMProperty.CONTENT, "This is some test content");
        return defaultProperties;
    }
}

