/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v23;

import java.util.Arrays;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.v23.RMv23SavedSearchesPatch;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.search.SavedSearchDetails;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class RMv23SavedSearchesPatchUnitTest {
    @Mock
    private NodeService nodeService;
    @Mock
    private SiteService siteService;
    @Mock
    private SiteInfo siteInfo;
    @Mock
    private RecordsManagementSearchServiceImpl recordsManagementSearchService;
    @Mock
    private SavedSearchDetails mockSavedSearchDetails1;
    @Mock
    private SavedSearchDetails mockSavedSearchDetails2;
    @InjectMocks
    private RMv23SavedSearchesPatch patch;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void executePatch() {
        NodeRef noderef1 = new NodeRef("foo://123/456");
        NodeRef noderef2 = new NodeRef("bar://123/456");
        List<SavedSearchDetails> searches = Arrays.asList(this.mockSavedSearchDetails1, this.mockSavedSearchDetails2);
        Mockito.when((Object)this.mockSavedSearchDetails1.getNodeRef()).thenReturn((Object)noderef1);
        Mockito.when((Object)this.mockSavedSearchDetails2.getNodeRef()).thenReturn((Object)noderef2);
        Mockito.when((Object)this.recordsManagementSearchService.getSavedSearches("rm")).thenReturn(searches);
        Mockito.when((Object)this.siteService.getSite("rm")).thenReturn((Object)this.siteInfo);
        this.patch.applyInternal();
        ((NodeService)Mockito.verify((Object)this.nodeService, (VerificationMode)Mockito.times((int)1))).addAspect(noderef1, RecordsManagementModel.ASPECT_SAVED_SEARCH, null);
        ((NodeService)Mockito.verify((Object)this.nodeService, (VerificationMode)Mockito.times((int)1))).addAspect(noderef2, RecordsManagementModel.ASPECT_SAVED_SEARCH, null);
    }

    @Test
    public void testPatchDoesntRunWithoutRmSite() {
        Mockito.when((Object)this.siteService.getSite("rm")).thenReturn(null);
        this.patch.applyInternal();
        ((NodeService)Mockito.verify((Object)this.nodeService, (VerificationMode)Mockito.times((int)0))).addAspect((NodeRef)Matchers.any(NodeRef.class), (QName)Matchers.any(QName.class), Matchers.anyMap());
    }
}

