/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v32;

import java.io.InputStream;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.patch.v32.RMv32HoldReportUpdatePatch;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.VersionService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class RMv32HoldReportUpdatePatchUnitTest {
    @Mock
    private NodeService mockedNodeService;
    @Mock
    private ContentService mockedContentService;
    @Mock
    private VersionService mockedVersionService;
    @Mock
    private ContentWriter mockedContentWriter;
    @InjectMocks
    private RMv32HoldReportUpdatePatch patch;
    private NodeRef hold_report;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.hold_report = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "rmr_holdReport");
    }

    @Test
    public void testReportContentIsUpdatedAfterUpgrade() {
        Mockito.when((Object)this.mockedNodeService.exists(this.hold_report)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedNodeService.hasAspect(this.hold_report, ContentModel.ASPECT_VERSIONABLE)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedContentService.getWriter(this.hold_report, ContentModel.PROP_CONTENT, true)).thenReturn((Object)this.mockedContentWriter);
        this.patch.applyInternal();
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)1))).addAspect(this.hold_report, ContentModel.ASPECT_VERSIONABLE, null);
        ((VersionService)Mockito.verify((Object)this.mockedVersionService, (VerificationMode)Mockito.times((int)1))).createVersion((NodeRef)Matchers.anyObject(), Matchers.anyMap());
        ((ContentWriter)Mockito.verify((Object)this.mockedContentWriter, (VerificationMode)Mockito.times((int)1))).putContent((InputStream)Matchers.anyObject());
    }
}

