/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.hold;

import java.util.HashSet;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldServicePolicies;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.role.Role;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.GUID;

public class CreateHoldTest
extends BaseRMTestCase
implements HoldServicePolicies.BeforeCreateHoldPolicy,
HoldServicePolicies.OnCreateHoldPolicy {
    private String testUser = null;
    private boolean beforeCreateHoldFlag = false;
    private boolean onCreateHoldFlag = false;

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setupTestUsersImpl(NodeRef filePlan) {
        super.setupTestUsersImpl(filePlan);
        this.testUser = GUID.generate();
        this.createPerson(this.testUser);
        this.siteService.setMembership(this.siteId, this.testUser, "SiteConsumer");
        HashSet<Capability> capabilities = new HashSet<Capability>(2);
        capabilities.add(this.capabilityService.getCapability("ViewRecords"));
        capabilities.add(this.capabilityService.getCapability("CreateHold"));
        Role role = this.filePlanRoleService.createRole(filePlan, GUID.generate(), GUID.generate(), capabilities);
        this.filePlanRoleService.assignRoleToAuthority(filePlan, role.getName(), this.testUser);
    }

    public void testFilingPermissionOnCreatedHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(this.testUser){
            private NodeRef hold;

            @Override
            public void given() throws Exception {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        CreateHoldTest.this.filePlanPermissionService.setPermission(CreateHoldTest.this.holdsContainer, CreateHoldTest.this.testUser, "Filing");
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName());
            }

            @Override
            public void when() throws Exception {
                this.hold = CreateHoldTest.this.holdService.createHold(CreateHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
            }

            @Override
            public void then() throws Exception {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)CreateHoldTest.this.permissionService.hasPermission(this.hold, "Filing"));
            }
        });
    }

    public void testPolicyNotificationForCreateHold() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            BehaviourDefinition<ClassBehaviourBinding> beforeCreateHoldBehaviour;
            BehaviourDefinition<ClassBehaviourBinding> onCreateHoldBehaviour;

            @Override
            public void given() {
                this.beforeCreateHoldBehaviour = CreateHoldTest.this.policyComponent.bindClassBehaviour(HoldServicePolicies.BeforeCreateHoldPolicy.QNAME, RecordsManagementModel.TYPE_HOLD_CONTAINER, (Behaviour)new JavaBehaviour((Object)CreateHoldTest.this, "beforeCreateHold", Behaviour.NotificationFrequency.EVERY_EVENT));
                this.onCreateHoldBehaviour = CreateHoldTest.this.policyComponent.bindClassBehaviour(HoldServicePolicies.OnCreateHoldPolicy.QNAME, RecordsManagementModel.TYPE_HOLD, (Behaviour)new JavaBehaviour((Object)CreateHoldTest.this, "onCreateHold", Behaviour.NotificationFrequency.EVERY_EVENT));
                TestCase.assertFalse((boolean)CreateHoldTest.this.beforeCreateHoldFlag);
                TestCase.assertFalse((boolean)CreateHoldTest.this.onCreateHoldFlag);
            }

            @Override
            public void when() {
                NodeRef hold = CreateHoldTest.this.holdService.createHold(CreateHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)CreateHoldTest.this.beforeCreateHoldFlag);
                TestCase.assertTrue((boolean)CreateHoldTest.this.onCreateHoldFlag);
            }

            @Override
            public void after() {
                CreateHoldTest.this.policyComponent.removeClassDefinition(this.beforeCreateHoldBehaviour);
                CreateHoldTest.this.policyComponent.removeClassDefinition(this.onCreateHoldBehaviour);
            }
        });
    }

    public void beforeCreateHold(String name, String reason) {
        this.beforeCreateHoldFlag = true;
    }

    public void onCreateHold(NodeRef hold) {
        this.onCreateHoldFlag = true;
    }
}

