/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementPolicies;
import org.alfresco.module.org_alfresco_module_rm.admin.CustomMetadataException;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMListOfValuesConstraint;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementCustomModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDefinition;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDisplayName;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipType;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.springframework.util.CollectionUtils;

public class RecordsManagementAdminServiceImplTest
extends BaseRMTestCase
implements RecordsManagementModel,
RecordsManagementPolicies.BeforeCreateReference,
RecordsManagementPolicies.OnCreateReference {
    private static final long testRunID = System.currentTimeMillis();
    private List<QName> createdCustomProperties;
    private List<QName> madeCustomisable;
    private boolean beforeMarker = false;
    private boolean onMarker = false;
    private boolean inTest = false;

    @Override
    protected void setUp() throws Exception {
        this.createdCustomProperties = new ArrayList<QName>();
        this.madeCustomisable = new ArrayList<QName>();
        super.setUp();
    }

    @Override
    protected void setupTestData() {
        super.setupTestData();
    }

    @Override
    protected void tearDown() throws Exception {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                for (QName createdCustomProperty : RecordsManagementAdminServiceImplTest.this.createdCustomProperties) {
                    RecordsManagementAdminServiceImplTest.this.rmAdminService.removeCustomPropertyDefinition(createdCustomProperty);
                }
                for (QName customisable : RecordsManagementAdminServiceImplTest.this.madeCustomisable) {
                    RecordsManagementAdminServiceImplTest.this.rmAdminService.unmakeCustomisable(customisable);
                }
                return null;
            }
        });
        super.tearDown();
    }

    public void testGetCustomisable() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                Set list = RecordsManagementAdminServiceImplTest.this.rmAdminService.getCustomisable();
                TestCase.assertNotNull((Object)list);
                TestCase.assertTrue((boolean)list.containsAll(CollectionUtils.arrayToList((Object)new QName[]{RecordsManagementModel.ASPECT_RECORD, RecordsManagementModel.TYPE_RECORD_FOLDER, RecordsManagementModel.TYPE_NON_ELECTRONIC_DOCUMENT, RecordsManagementModel.TYPE_RECORD_CATEGORY})));
                return null;
            }
        });
    }

    public void testIsCustomisable() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                TestCase.assertFalse((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.isCustomisable(ContentModel.TYPE_CONTENT));
                TestCase.assertFalse((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.isCustomisable(ContentModel.ASPECT_DUBLINCORE));
                TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.isCustomisable(RecordsManagementModel.TYPE_RECORD_FOLDER));
                TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.isCustomisable(RecordsManagementModel.ASPECT_RECORD));
                return null;
            }
        });
    }

    public void testAddCustomPropertyDefinition() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<QName>(){

            public QName run() throws Exception {
                TestCase.assertFalse((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.existsCustomProperty(QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"myRecordProp1")));
                return RecordsManagementAdminServiceImplTest.this.rmAdminService.addCustomPropertyDefinition(QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"myRecordProp1"), RecordsManagementModel.ASPECT_RECORD, "Label1", DataTypeDefinition.TEXT, "Title", "Description");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(QName result) throws Exception {
                try {
                    TestCase.assertNotNull((Object)result);
                    TestCase.assertEquals((Object)QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"myRecordProp1"), (Object)result);
                    TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.existsCustomProperty(result));
                    Map propDefs = RecordsManagementAdminServiceImplTest.this.rmAdminService.getCustomPropertyDefinitions(RecordsManagementModel.ASPECT_RECORD);
                    TestCase.assertNotNull((Object)propDefs);
                    TestCase.assertTrue((boolean)propDefs.containsKey(result));
                    PropertyDefinition propDef = (PropertyDefinition)propDefs.get(result);
                    TestCase.assertNotNull((Object)propDef);
                    TestCase.assertEquals((Object)DataTypeDefinition.TEXT, (Object)propDef.getDataType().getName());
                    TestCase.assertEquals((String)"Description", (String)propDef.getDescription((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
                    TestCase.assertEquals((String)"Label1", (String)propDef.getTitle((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
                }
                finally {
                    RecordsManagementAdminServiceImplTest.this.createdCustomProperties.add(result);
                }
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<QName>(){

            public QName run() throws Exception {
                return RecordsManagementAdminServiceImplTest.this.rmAdminService.addCustomPropertyDefinition(null, RecordsManagementModel.ASPECT_RECORD, "Label2", DataTypeDefinition.TEXT, "Title", "Description");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(QName result) throws Exception {
                try {
                    TestCase.assertNotNull((Object)result);
                    TestCase.assertEquals((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)result.getNamespaceURI());
                    TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.existsCustomProperty(result));
                    Map propDefs = RecordsManagementAdminServiceImplTest.this.rmAdminService.getCustomPropertyDefinitions(RecordsManagementModel.ASPECT_RECORD);
                    TestCase.assertNotNull((Object)propDefs);
                    TestCase.assertTrue((boolean)propDefs.containsKey(result));
                    PropertyDefinition propDef = (PropertyDefinition)propDefs.get(result);
                    TestCase.assertNotNull((Object)propDef);
                    TestCase.assertEquals((Object)DataTypeDefinition.TEXT, (Object)propDef.getDataType().getName());
                    TestCase.assertEquals((String)"Description", (String)propDef.getDescription((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
                    TestCase.assertEquals((String)"Label2", (String)propDef.getTitle((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
                }
                finally {
                    RecordsManagementAdminServiceImplTest.this.createdCustomProperties.add(result);
                }
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<QName>(){

            public QName run() throws Exception {
                return RecordsManagementAdminServiceImplTest.this.rmAdminService.addCustomPropertyDefinition(null, RecordsManagementModel.ASPECT_RECORD, "Label3", DataTypeDefinition.TEXT, "Title", "Description", "default", false, false, false, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test(QName result) throws Exception {
                try {
                    TestCase.assertNotNull((Object)result);
                    TestCase.assertEquals((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)result.getNamespaceURI());
                    TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.existsCustomProperty(result));
                    Map propDefs = RecordsManagementAdminServiceImplTest.this.rmAdminService.getCustomPropertyDefinitions(RecordsManagementModel.ASPECT_RECORD);
                    TestCase.assertNotNull((Object)propDefs);
                    TestCase.assertTrue((boolean)propDefs.containsKey(result));
                    PropertyDefinition propDef = (PropertyDefinition)propDefs.get(result);
                    TestCase.assertNotNull((Object)propDef);
                    TestCase.assertEquals((Object)DataTypeDefinition.TEXT, (Object)propDef.getDataType().getName());
                    TestCase.assertEquals((String)"Description", (String)propDef.getDescription((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
                    TestCase.assertEquals((String)"Label3", (String)propDef.getTitle((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
                    TestCase.assertEquals((String)"default", (String)propDef.getDefaultValue());
                    TestCase.assertFalse((boolean)propDef.isMandatory());
                    TestCase.assertFalse((boolean)propDef.isMultiValued());
                    TestCase.assertFalse((boolean)propDef.isProtected());
                }
                finally {
                    RecordsManagementAdminServiceImplTest.this.createdCustomProperties.add(result);
                }
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Can not create a property with the same id twice", CustomMetadataException.class){

            public void run() throws Exception {
                RecordsManagementAdminServiceImplTest.this.rmAdminService.addCustomPropertyDefinition(QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"myRecordProp1"), RecordsManagementModel.ASPECT_RECORD, "Label1", DataTypeDefinition.TEXT, "Title", "Description");
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Can not add a custom property to a type that isn't registered as customisable", CustomMetadataException.class){

            public void run() throws Exception {
                RecordsManagementAdminServiceImplTest.this.rmAdminService.addCustomPropertyDefinition(QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"myContentProp"), ContentModel.TYPE_CONTENT, "Label1", DataTypeDefinition.TEXT, "Title", "Description");
            }
        });
    }

    public void testMakeCustomisable() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<QName>(){

            public QName run() throws Exception {
                TestCase.assertFalse((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.isCustomisable(RecordsManagementAdminServiceImplTest.this.TYPE_CUSTOM_TYPE));
                RecordsManagementAdminServiceImplTest.this.rmAdminService.makeCustomisable(RecordsManagementAdminServiceImplTest.this.TYPE_CUSTOM_TYPE);
                RecordsManagementAdminServiceImplTest.this.madeCustomisable.add(RecordsManagementAdminServiceImplTest.this.TYPE_CUSTOM_TYPE);
                TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.isCustomisable(RecordsManagementAdminServiceImplTest.this.TYPE_CUSTOM_TYPE));
                return RecordsManagementAdminServiceImplTest.this.rmAdminService.addCustomPropertyDefinition(QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"myNewProperty"), RecordsManagementAdminServiceImplTest.this.TYPE_CUSTOM_TYPE, "Label", DataTypeDefinition.TEXT, "Title", "Description");
            }

            public void test(QName result) throws Exception {
                TestCase.assertNotNull((Object)result);
                TestCase.assertEquals((Object)QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"myNewProperty"), (Object)result);
                TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.existsCustomProperty(result));
                Map propDefs = RecordsManagementAdminServiceImplTest.this.rmAdminService.getCustomPropertyDefinitions(RecordsManagementAdminServiceImplTest.this.TYPE_CUSTOM_TYPE);
                TestCase.assertNotNull((Object)propDefs);
                TestCase.assertEquals((int)1, (int)propDefs.size());
                TestCase.assertTrue((boolean)propDefs.containsKey(result));
                PropertyDefinition propDef = (PropertyDefinition)propDefs.get(result);
                TestCase.assertNotNull((Object)propDef);
                TestCase.assertEquals((Object)DataTypeDefinition.TEXT, (Object)propDef.getDataType().getName());
                TestCase.assertEquals((String)"Description", (String)propDef.getDescription((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
                TestCase.assertEquals((String)"Label", (String)propDef.getTitle((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<QName>(){

            public QName run() throws Exception {
                TestCase.assertFalse((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.isCustomisable(RecordsManagementAdminServiceImplTest.this.ASPECT_CUSTOM_ASPECT));
                RecordsManagementAdminServiceImplTest.this.rmAdminService.makeCustomisable(RecordsManagementAdminServiceImplTest.this.ASPECT_CUSTOM_ASPECT);
                RecordsManagementAdminServiceImplTest.this.madeCustomisable.add(RecordsManagementAdminServiceImplTest.this.ASPECT_CUSTOM_ASPECT);
                TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.isCustomisable(RecordsManagementAdminServiceImplTest.this.ASPECT_CUSTOM_ASPECT));
                return RecordsManagementAdminServiceImplTest.this.rmAdminService.addCustomPropertyDefinition(QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"myNewAspectProperty"), RecordsManagementAdminServiceImplTest.this.ASPECT_CUSTOM_ASPECT, "Label", DataTypeDefinition.TEXT, "Title", "Description");
            }

            public void test(QName result) throws Exception {
                TestCase.assertNotNull((Object)result);
                TestCase.assertEquals((Object)QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"myNewAspectProperty"), (Object)result);
                TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.rmAdminService.existsCustomProperty(result));
                Map propDefs = RecordsManagementAdminServiceImplTest.this.rmAdminService.getCustomPropertyDefinitions(RecordsManagementAdminServiceImplTest.this.ASPECT_CUSTOM_ASPECT);
                TestCase.assertNotNull((Object)propDefs);
                TestCase.assertEquals((int)1, (int)propDefs.size());
                TestCase.assertTrue((boolean)propDefs.containsKey(result));
                PropertyDefinition propDef = (PropertyDefinition)propDefs.get(result);
                TestCase.assertNotNull((Object)propDef);
                TestCase.assertEquals((Object)DataTypeDefinition.TEXT, (Object)propDef.getDataType().getName());
                TestCase.assertEquals((String)"Description", (String)propDef.getDescription((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
                TestCase.assertEquals((String)"Label", (String)propDef.getTitle((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
            }
        });
    }

    public void testUseCustomProperty() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<QName>(){

            public QName run() throws Exception {
                RecordsManagementAdminServiceImplTest.this.rmAdminService.makeCustomisable(RecordsManagementAdminServiceImplTest.this.TYPE_CUSTOM_TYPE);
                RecordsManagementAdminServiceImplTest.this.madeCustomisable.add(RecordsManagementAdminServiceImplTest.this.TYPE_CUSTOM_TYPE);
                RecordsManagementAdminServiceImplTest.this.rmAdminService.addCustomPropertyDefinition(QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"myNewProperty"), RecordsManagementAdminServiceImplTest.this.TYPE_CUSTOM_TYPE, "Label", DataTypeDefinition.TEXT, "Title", "Description");
                RecordsManagementAdminServiceImplTest.this.rmAdminService.makeCustomisable(RecordsManagementAdminServiceImplTest.this.ASPECT_CUSTOM_ASPECT);
                RecordsManagementAdminServiceImplTest.this.madeCustomisable.add(RecordsManagementAdminServiceImplTest.this.ASPECT_CUSTOM_ASPECT);
                RecordsManagementAdminServiceImplTest.this.rmAdminService.addCustomPropertyDefinition(QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"myNewAspectProperty"), RecordsManagementAdminServiceImplTest.this.ASPECT_CUSTOM_ASPECT, "Label", DataTypeDefinition.TEXT, "Title", "Description");
                return null;
            }
        });
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<QName>(){

            public QName run() throws Exception {
                NodeRef customInstance1 = RecordsManagementAdminServiceImplTest.this.nodeService.createNode(RecordsManagementAdminServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myCustomInstance1"), RecordsManagementAdminServiceImplTest.this.TYPE_CUSTOM_TYPE).getChildRef();
                NodeRef customInstance2 = RecordsManagementAdminServiceImplTest.this.nodeService.createNode(RecordsManagementAdminServiceImplTest.this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myCustomInstance2"), ContentModel.TYPE_CONTENT).getChildRef();
                RecordsManagementAdminServiceImplTest.this.nodeService.addAspect(customInstance2, RecordsManagementAdminServiceImplTest.this.ASPECT_CUSTOM_ASPECT, null);
                TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.nodeService.hasAspect(customInstance1, QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"rmtcustomTypeCustomProperties")));
                TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.nodeService.hasAspect(customInstance2, QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"rmtcustomAspectCustomProperties")));
                RecordsManagementAdminServiceImplTest.this.nodeService.removeAspect(customInstance2, RecordsManagementAdminServiceImplTest.this.ASPECT_CUSTOM_ASPECT);
                TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.nodeService.hasAspect(customInstance1, QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"rmtcustomTypeCustomProperties")));
                TestCase.assertFalse((boolean)RecordsManagementAdminServiceImplTest.this.nodeService.hasAspect(customInstance2, QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)"rmtcustomAspectCustomProperties")));
                return null;
            }
        }, AuthenticationUtil.getSystemUserName());
    }

    public void testCreateAndUseCustomChildReference() throws Exception {
        long now = System.currentTimeMillis();
        this.createAndUseCustomReference(RelationshipType.PARENTCHILD, null, "superseded" + now, "superseding" + now);
    }

    public void testCreateAndUseCustomNonChildReference() throws Exception {
        long now = System.currentTimeMillis();
        this.createAndUseCustomReference(RelationshipType.BIDIRECTIONAL, "supporting" + now, null, null);
    }

    private void createAndUseCustomReference(final RelationshipType refType, final String label, final String source, final String target) throws Exception {
        final NodeRef testRecord1 = (NodeRef)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef result = RecordsManagementAdminServiceImplTest.this.utils.createRecord(RecordsManagementAdminServiceImplTest.this.rmFolder, "testRecordA" + System.currentTimeMillis());
                return result;
            }
        });
        final NodeRef testRecord2 = (NodeRef)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef result = RecordsManagementAdminServiceImplTest.this.utils.createRecord(RecordsManagementAdminServiceImplTest.this.rmFolder, "testRecordB" + System.currentTimeMillis());
                return result;
            }
        });
        final QName generatedQName = (QName)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<QName>(){

            public QName execute() throws Throwable {
                RecordsManagementAdminServiceImplTest.this.utils.completeRecord(testRecord1);
                RecordsManagementAdminServiceImplTest.this.utils.completeRecord(testRecord2);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("referenceType", refType.toString());
                if (label != null) {
                    params.put("label", label);
                }
                if (source != null) {
                    params.put("source", source);
                }
                if (target != null) {
                    params.put("target", target);
                }
                RelationshipDisplayName displayName = label != null ? new RelationshipDisplayName(label, label) : new RelationshipDisplayName(source, target);
                RelationshipDefinition relationshipDefinition = RecordsManagementAdminServiceImplTest.this.relationshipService.createRelationshipDefinition(displayName);
                QName qNameResult = QName.createQName((String)"rmc", (String)relationshipDefinition.getUniqueName(), (NamespacePrefixResolver)RecordsManagementAdminServiceImplTest.this.namespaceService);
                System.out.println("Creating new " + String.valueOf(refType) + " reference definition: " + String.valueOf(qNameResult));
                System.out.println("  params- label: '" + label + "' source: '" + source + "' target: '" + target + "'");
                return qNameResult;
            }
        });
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                RelationshipDefinition relationshipDefinition = RecordsManagementAdminServiceImplTest.this.relationshipService.getRelationshipDefinition(generatedQName.getLocalName());
                TestCase.assertNotNull((String)"Relationship definition from relationshipService was null.", (Object)relationshipDefinition);
                TestCase.assertEquals((String)generatedQName.getLocalName(), (String)relationshipDefinition.getUniqueName());
                TestCase.assertTrue((boolean)refType.equals((Object)relationshipDefinition.getType()));
                RecordsManagementAdminServiceImplTest.this.nodeService.addAspect(testRecord1, RecordsManagementCustomModel.ASPECT_CUSTOM_ASSOCIATIONS, null);
                if (RelationshipType.PARENTCHILD.equals((Object)refType)) {
                    RecordsManagementAdminServiceImplTest.this.nodeService.addChild(testRecord1, testRecord2, generatedQName, generatedQName);
                } else {
                    RecordsManagementAdminServiceImplTest.this.nodeService.createAssociation(testRecord1, testRecord2, generatedQName);
                }
                return null;
            }
        });
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List childAssocs = RecordsManagementAdminServiceImplTest.this.nodeService.getChildAssocs(testRecord1);
                List retrievedAssocs = RecordsManagementAdminServiceImplTest.this.nodeService.getTargetAssocs(testRecord1, RegexQNamePattern.MATCH_ALL);
                ChildAssociationRef newlyAddedRef = null;
                if (RelationshipType.PARENTCHILD.equals((Object)refType)) {
                    for (ChildAssociationRef caRef : childAssocs) {
                        QName refInstanceQName = caRef.getQName();
                        if (!generatedQName.equals((Object)refInstanceQName)) continue;
                        newlyAddedRef = caRef;
                    }
                } else {
                    for (AssociationRef aRef : retrievedAssocs) {
                        QName refQName = aRef.getTypeQName();
                        if (!generatedQName.equals((Object)refQName)) continue;
                        newlyAddedRef = aRef;
                    }
                }
                TestCase.assertNotNull((String)"newlyAddedRef was null.", newlyAddedRef);
                AspectDefinition customAssocsAspect = RecordsManagementAdminServiceImplTest.this.dictionaryService.getAspect(RecordsManagementCustomModel.ASPECT_CUSTOM_ASSOCIATIONS);
                TestCase.assertNotNull((Object)customAssocsAspect);
                if (RelationshipType.PARENTCHILD.equals((Object)refType)) {
                    TestCase.assertNotNull((String)"The customReference is not returned from the dictionaryService.", customAssocsAspect.getChildAssociations().get(generatedQName));
                } else {
                    TestCase.assertNotNull((String)"The customReference is not returned from the dictionaryService.", customAssocsAspect.getAssociations().get(generatedQName));
                }
                return null;
            }
        });
    }

    public void testGetAllProperties() {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                System.out.println("Available custom properties:");
                Map props = RecordsManagementAdminServiceImplTest.this.rmAdminService.getCustomPropertyDefinitions();
                for (QName prop : props.keySet()) {
                    System.out.println("   - " + prop.toString());
                    String propId = ((PropertyDefinition)props.get(prop)).getTitle((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService);
                    TestCase.assertNotNull((String)("null client-id for " + String.valueOf(prop)), (Object)propId);
                    System.out.println("       " + propId);
                }
                return null;
            }
        });
    }

    public void testGetAllReferences() {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                System.out.println("Available relationship definitions:");
                Set relationshipDefinitions = RecordsManagementAdminServiceImplTest.this.relationshipService.getRelationshipDefinitions();
                for (RelationshipDefinition relationshipDefinition : relationshipDefinitions) {
                    String uniqueName = relationshipDefinition.getUniqueName();
                    RelationshipDisplayName displayName = relationshipDefinition.getDisplayName();
                    System.out.println("    - " + uniqueName);
                    System.out.println("      " + displayName.toString());
                }
                return null;
            }
        });
    }

    public void testGetAllConstraints() {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                System.out.println("Available custom constraints:");
                List constraints = RecordsManagementAdminServiceImplTest.this.rmAdminService.getCustomConstraintDefinitions(RecordsManagementCustomModel.RM_CUSTOM_MODEL);
                for (ConstraintDefinition constraint : constraints) {
                    System.out.println("   - " + String.valueOf(constraint.getName()));
                    System.out.println("       " + constraint.getTitle((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateReference() throws Exception {
        this.inTest = true;
        try {
            Pair testRecords = (Pair)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Pair<NodeRef, NodeRef>>(){

                public Pair<NodeRef, NodeRef> execute() throws Throwable {
                    NodeRef rec1 = RecordsManagementAdminServiceImplTest.this.utils.createRecord(RecordsManagementAdminServiceImplTest.this.rmFolder, "testRecordA" + System.currentTimeMillis());
                    NodeRef rec2 = RecordsManagementAdminServiceImplTest.this.utils.createRecord(RecordsManagementAdminServiceImplTest.this.rmFolder, "testRecordB" + System.currentTimeMillis());
                    Pair result = new Pair((Object)rec1, (Object)rec2);
                    return result;
                }
            });
            final NodeRef testRecord1 = (NodeRef)testRecords.getFirst();
            final NodeRef testRecord2 = (NodeRef)testRecords.getSecond();
            this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    RecordsManagementAdminServiceImplTest.this.utils.completeRecord(testRecord1);
                    RecordsManagementAdminServiceImplTest.this.utils.completeRecord(testRecord2);
                    RecordsManagementAdminServiceImplTest.this.policyComponent.bindClassBehaviour(RecordsManagementPolicies.BEFORE_CREATE_REFERENCE, (Object)this, (Behaviour)new JavaBehaviour((Object)RecordsManagementAdminServiceImplTest.this, "beforeCreateReference", Behaviour.NotificationFrequency.EVERY_EVENT));
                    RecordsManagementAdminServiceImplTest.this.policyComponent.bindClassBehaviour(RecordsManagementPolicies.ON_CREATE_REFERENCE, (Object)this, (Behaviour)new JavaBehaviour((Object)RecordsManagementAdminServiceImplTest.this, "onCreateReference", Behaviour.NotificationFrequency.EVERY_EVENT));
                    TestCase.assertFalse((boolean)RecordsManagementAdminServiceImplTest.this.beforeMarker);
                    TestCase.assertFalse((boolean)RecordsManagementAdminServiceImplTest.this.onMarker);
                    RecordsManagementAdminServiceImplTest.this.relationshipService.addRelationship(RecordsManagementCustomModel.CUSTOM_REF_VERSIONS.getLocalName(), testRecord1, testRecord2);
                    TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.beforeMarker);
                    TestCase.assertTrue((boolean)RecordsManagementAdminServiceImplTest.this.onMarker);
                    return null;
                }
            });
        }
        finally {
            this.inTest = false;
        }
    }

    public void beforeCreateReference(NodeRef fromNodeRef, NodeRef toNodeRef, QName reference) {
        this.beforeMarker = true;
    }

    public void onCreateReference(NodeRef fromNodeRef, NodeRef toNodeRef, QName reference) {
        this.onMarker = true;
    }

    public void testCreateCustomConstraints() throws Exception {
        final int beforeCnt = (Integer)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            public Integer execute() throws Throwable {
                List result = RecordsManagementAdminServiceImplTest.this.rmAdminService.getCustomConstraintDefinitions(RecordsManagementCustomModel.RM_CUSTOM_MODEL);
                TestCase.assertNotNull((Object)result);
                return result.size();
            }
        });
        final String conTitle = "test title - " + testRunID;
        final ArrayList<String> allowedValues = new ArrayList<String>(3);
        allowedValues.add("RED");
        allowedValues.add("AMBER");
        allowedValues.add("GREEN");
        final QName testCon = (QName)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<QName>(){

            public QName execute() throws Throwable {
                String conLocalName = "test-" + testRunID;
                QName result = QName.createQName((String)"http://www.alfresco.org/model/rmcustom/1.0", (String)conLocalName);
                RecordsManagementAdminServiceImplTest.this.rmAdminService.addCustomConstraintDefinition(result, conTitle, true, allowedValues, RMListOfValuesConstraint.MatchLogic.AND);
                return result;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List customConstraintDefs = RecordsManagementAdminServiceImplTest.this.rmAdminService.getCustomConstraintDefinitions(RecordsManagementCustomModel.RM_CUSTOM_MODEL);
                TestCase.assertEquals((int)(beforeCnt + 1), (int)customConstraintDefs.size());
                boolean found = false;
                for (ConstraintDefinition conDef : customConstraintDefs) {
                    if (!conDef.getName().equals((Object)testCon)) continue;
                    TestCase.assertEquals((String)conTitle, (String)conDef.getTitle((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
                    Constraint con = conDef.getConstraint();
                    TestCase.assertTrue((boolean)(con instanceof RMListOfValuesConstraint));
                    TestCase.assertEquals((String)"LIST", (String)((RMListOfValuesConstraint)con).getType());
                    TestCase.assertEquals((int)3, (int)((RMListOfValuesConstraint)con).getAllowedValues().size());
                    found = true;
                    break;
                }
                TestCase.assertTrue((boolean)found);
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                allowedValues.clear();
                allowedValues.add("RED");
                allowedValues.add("YELLOW");
                RecordsManagementAdminServiceImplTest.this.rmAdminService.changeCustomConstraintValues(testCon, allowedValues);
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List customConstraintDefs = RecordsManagementAdminServiceImplTest.this.rmAdminService.getCustomConstraintDefinitions(RecordsManagementCustomModel.RM_CUSTOM_MODEL);
                TestCase.assertEquals((int)(beforeCnt + 1), (int)customConstraintDefs.size());
                boolean found = false;
                for (ConstraintDefinition conDef : customConstraintDefs) {
                    if (!conDef.getName().equals((Object)testCon)) continue;
                    TestCase.assertEquals((String)conTitle, (String)conDef.getTitle((MessageLookup)RecordsManagementAdminServiceImplTest.this.dictionaryService));
                    Constraint con = conDef.getConstraint();
                    TestCase.assertTrue((boolean)(con instanceof RMListOfValuesConstraint));
                    TestCase.assertEquals((String)"LIST", (String)((RMListOfValuesConstraint)con).getType());
                    TestCase.assertEquals((int)2, (int)((RMListOfValuesConstraint)con).getAllowedValues().size());
                    found = true;
                    break;
                }
                TestCase.assertTrue((boolean)found);
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String propLocalName = "myProp-" + testRunID;
                QName dataType = DataTypeDefinition.TEXT;
                String propTitle = "My property title";
                String description = "My property description";
                String defaultValue = null;
                boolean multiValued = false;
                boolean mandatory = false;
                boolean isProtected = false;
                QName propName = RecordsManagementAdminServiceImplTest.this.rmAdminService.addCustomPropertyDefinition(null, RecordsManagementModel.ASPECT_RECORD, propLocalName, dataType, propTitle, description, defaultValue, multiValued, mandatory, isProtected, testCon);
                RecordsManagementAdminServiceImplTest.this.createdCustomProperties.add(propName);
                return null;
            }
        });
    }
}

