/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.bootstrap;

import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;

public class ModuleCompatibilityComponent
implements ApplicationListener<ContextRefreshedEvent> {
    private static Log logger = LogFactory.getLog(ModuleCompatibilityComponent.class);
    private static final String RM_ENT_MODULE_ID = "alfresco-rm-enterprise-repo";
    private DescriptorService descriptorService;
    private ModuleService moduleService;

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setModuleService(ModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        RepoUsage.LicenseMode licenseMode = RepoUsage.LicenseMode.UNKNOWN;
        ApplicationContext applicationContext = contextRefreshedEvent.getApplicationContext();
        LicenseDescriptor license = this.descriptorService.getLicenseDescriptor();
        if (license != null) {
            licenseMode = license.getLicenseMode();
        }
        boolean isRMEnterprise = this.isRMEnterprise();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Module compatibility information:");
            logger.debug((Object)("   Repository licence mode = " + licenseMode.toString()));
            logger.debug((Object)("   RM Enterprise installed = " + isRMEnterprise));
        }
        if (RepoUsage.LicenseMode.ENTERPRISE.equals((Object)licenseMode) && !isRMEnterprise) {
            this.closeApplicationContext(applicationContext, "Running Community Records Management Module on Enterprise Alfresco One is not a supported configuration.");
        } else if (!RepoUsage.LicenseMode.ENTERPRISE.equals((Object)licenseMode) && isRMEnterprise) {
            this.closeApplicationContext(applicationContext, "Running Enterprise Records Management module on Community Alfresco One is not a supported configuration.");
        }
    }

    private boolean isRMEnterprise() {
        return this.moduleService.getModule(RM_ENT_MODULE_ID) != null;
    }

    private void closeApplicationContext(ApplicationContext applicationContext, String message) {
        if (logger.isErrorEnabled()) {
            logger.error((Object)message);
        }
        ((ConfigurableApplicationContext)applicationContext).close();
    }
}

