/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.model.Assoc;
import org.alfresco.rest.api.model.AssocChild;
import org.alfresco.rest.api.model.ContentInfo;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.jacksonextensions.BeanPropertiesFilter;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.FilePlan;
import org.alfresco.rm.rest.api.model.RMNode;
import org.alfresco.rm.rest.api.model.Record;
import org.alfresco.rm.rest.api.model.RecordCategory;
import org.alfresco.rm.rest.api.model.RecordCategoryChild;
import org.alfresco.rm.rest.api.model.RecordFolder;
import org.alfresco.rm.rest.api.model.Transfer;
import org.alfresco.rm.rest.api.model.TransferChild;
import org.alfresco.rm.rest.api.model.TransferContainer;
import org.alfresco.rm.rest.api.model.UnfiledChild;
import org.alfresco.rm.rest.api.model.UnfiledContainer;
import org.alfresco.rm.rest.api.model.UnfiledContainerChild;
import org.alfresco.rm.rest.api.model.UnfiledRecordFolder;
import org.alfresco.rm.rest.api.model.UnfiledRecordFolderChild;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class ApiNodesModelFactory {
    public static final List<String> EXCLUDED_NS = Arrays.asList("http://www.alfresco.org/model/system/1.0");
    public static final List<QName> EXCLUDED_ASPECTS = Arrays.asList(new QName[0]);
    public static final List<QName> EXCLUDED_PROPS = Arrays.asList(ContentModel.PROP_NAME, ContentModel.PROP_MODIFIER, ContentModel.PROP_MODIFIED, ContentModel.PROP_CREATOR, ContentModel.PROP_CREATED, ContentModel.PROP_CONTENT, ContentModel.PROP_INITIAL_VERSION, ContentModel.PROP_AUTO_VERSION_PROPS, ContentModel.PROP_AUTO_VERSION);
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private Nodes nodes;
    private FilePlanComponentsApiUtils apiUtils;
    private PersonService personService;
    private DispositionService dispositionService;
    private ServiceRegistry serviceRegistry;

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public DispositionService getDispositionService() {
        return this.dispositionService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    private void mapBasicInfo(RMNode rmNode, FileInfo info, BeanPropertiesFilter propertyFilter, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        if (propertyFilter.isAllowed("id")) {
            rmNode.setNodeRef(info.getNodeRef());
        }
        if (propertyFilter.isAllowed("parentId")) {
            rmNode.setParentId(this.nodeService.getPrimaryParent(info.getNodeRef()).getParentRef());
        }
        if (propertyFilter.isAllowed("name")) {
            rmNode.setName(info.getName());
        }
        if (propertyFilter.isAllowed("nodeType")) {
            rmNode.setNodeType(info.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService));
        }
        if (propertyFilter.isAllowed("modifiedAt")) {
            rmNode.setModifiedAt(info.getModifiedDate());
        }
        if (propertyFilter.isAllowed("modifiedByUser")) {
            if (mapUserInfo == null) {
                mapUserInfo = new HashMap<String, UserInfo>(2);
            }
            UserInfo modifer = Node.lookupUserInfo((String)((String)info.getProperties().get(ContentModel.PROP_MODIFIER)), mapUserInfo, (PersonService)this.personService);
            rmNode.setModifiedByUser(modifer);
        }
        if (propertyFilter.isAllowed("createdAt")) {
            rmNode.setCreatedAt(info.getCreatedDate());
        }
        if (propertyFilter.isAllowed("createdByUser")) {
            if (mapUserInfo == null) {
                mapUserInfo = new HashMap<String, UserInfo>(2);
            }
            UserInfo creator = Node.lookupUserInfo((String)((String)info.getProperties().get(ContentModel.PROP_CREATOR)), mapUserInfo, (PersonService)this.personService);
            rmNode.setCreatedByUser(creator);
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("aspectNames")) {
            rmNode.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("properties")) {
            rmNode.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
    }

    private void mapOptionalInfo(RMNode rmNode, FileInfo info, List<String> includeParam, boolean isMinimalInfo) {
        if (includeParam == null || includeParam.isEmpty()) {
            return;
        }
        if (includeParam.contains("allowableOperations")) {
            rmNode.setAllowableOperations(this.apiUtils.getAllowableOperations(info.getNodeRef(), info.getType()));
        }
        if (includeParam.contains("path")) {
            rmNode.setPath(this.nodes.lookupPathInfo(info.getNodeRef(), null));
        }
        if (isMinimalInfo && includeParam.contains("aspectNames")) {
            rmNode.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (isMinimalInfo && includeParam.contains("properties")) {
            rmNode.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
    }

    private void mapUnfiledChildInfo(UnfiledChild unfiledChild, FileInfo info, BeanPropertiesFilter propertyFilter) {
        if (RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER.equals((Object)info.getType())) {
            if (propertyFilter.isAllowed("isUnfiledRecordFolder")) {
                unfiledChild.setIsUnfiledRecordFolder(true);
            }
            if (propertyFilter.isAllowed("isRecord")) {
                unfiledChild.setIsRecord(false);
            }
        } else {
            if (propertyFilter.isAllowed("isUnfiledRecordFolder")) {
                unfiledChild.setIsUnfiledRecordFolder(false);
            }
            if (propertyFilter.isAllowed("isRecord")) {
                unfiledChild.setIsRecord(true);
            }
        }
    }

    private void mapTransferContainerInfo(TransferContainer transferContainer, FileInfo info, Map<String, UserInfo> mapUserInfo, BeanPropertiesFilter propertyFilter, List<String> includeParam, boolean isMinimalInfo) {
        if (propertyFilter.isAllowed("id")) {
            transferContainer.setNodeRef(info.getNodeRef());
        }
        if (propertyFilter.isAllowed("parentId")) {
            transferContainer.setParentId(this.nodeService.getPrimaryParent(info.getNodeRef()).getParentRef());
        }
        if (propertyFilter.isAllowed("name")) {
            transferContainer.setName(info.getName());
        }
        if (propertyFilter.isAllowed("nodeType")) {
            transferContainer.setNodeType(info.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService));
        }
        if (propertyFilter.isAllowed("modifiedAt")) {
            transferContainer.setModifiedAt(info.getModifiedDate());
        }
        if (propertyFilter.isAllowed("modifiedByUser")) {
            if (mapUserInfo == null) {
                mapUserInfo = new HashMap<String, UserInfo>(2);
            }
            UserInfo modifer = Node.lookupUserInfo((String)((String)info.getProperties().get(ContentModel.PROP_MODIFIER)), mapUserInfo, (PersonService)this.personService);
            transferContainer.setModifiedByUser(modifer);
        }
        if (propertyFilter.isAllowed("createdAt")) {
            transferContainer.setCreatedAt(info.getCreatedDate());
        }
        if (propertyFilter.isAllowed("createdByUser")) {
            if (mapUserInfo == null) {
                mapUserInfo = new HashMap<String, UserInfo>(2);
            }
            UserInfo creator = Node.lookupUserInfo((String)((String)info.getProperties().get(ContentModel.PROP_CREATOR)), mapUserInfo, (PersonService)this.personService);
            transferContainer.setCreatedByUser(creator);
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("aspectNames")) {
            transferContainer.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("properties")) {
            transferContainer.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
        if (includeParam == null || includeParam.isEmpty()) {
            return;
        }
        if (includeParam.contains("allowableOperations")) {
            transferContainer.setAllowableOperations(this.apiUtils.getAllowableOperations(info.getNodeRef(), info.getType()));
        }
        if (isMinimalInfo && includeParam.contains("aspectNames")) {
            transferContainer.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (isMinimalInfo && includeParam.contains("properties")) {
            transferContainer.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
    }

    private void mapTransferInfo(Transfer transfer, FileInfo info, Map<String, UserInfo> mapUserInfo, BeanPropertiesFilter propertyFilter, List<String> includeParam, boolean isMinimalInfo) {
        if (propertyFilter.isAllowed("id")) {
            transfer.setNodeRef(info.getNodeRef());
        }
        if (propertyFilter.isAllowed("parentId")) {
            transfer.setParentId(this.nodeService.getPrimaryParent(info.getNodeRef()).getParentRef());
        }
        if (propertyFilter.isAllowed("name")) {
            transfer.setName(info.getName());
        }
        if (propertyFilter.isAllowed("nodeType")) {
            transfer.setNodeType(info.getType().toPrefixString((NamespacePrefixResolver)this.namespaceService));
        }
        if (propertyFilter.isAllowed("createdAt")) {
            transfer.setCreatedAt(info.getCreatedDate());
        }
        if (propertyFilter.isAllowed("createdByUser")) {
            if (mapUserInfo == null) {
                mapUserInfo = new HashMap<String, UserInfo>(2);
            }
            UserInfo creator = Node.lookupUserInfo((String)((String)info.getProperties().get(ContentModel.PROP_CREATOR)), mapUserInfo, (PersonService)this.personService);
            transfer.setCreatedByUser(creator);
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("aspectNames")) {
            transfer.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("properties")) {
            transfer.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
        if (isMinimalInfo && includeParam == null || includeParam.isEmpty()) {
            return;
        }
        if (includeParam.contains("allowableOperations")) {
            transfer.setAllowableOperations(this.apiUtils.getAllowableOperations(info.getNodeRef(), info.getType()));
        }
        if (isMinimalInfo && includeParam.contains("aspectNames")) {
            transfer.setAspectNames(this.mapFromNodeAspects(this.nodeService.getAspects(info.getNodeRef())));
        }
        if (isMinimalInfo && includeParam.contains("properties")) {
            transfer.setProperties(this.mapFromNodeProperties(info.getProperties()));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("transferAccessionIndicator") || isMinimalInfo && includeParam.contains("transferAccessionIndicator")) {
            transfer.setTransferAccessionIndicator((Boolean)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_TRANSFER_ACCESSION_INDICATOR));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("transferLocation") || isMinimalInfo && includeParam.contains("transferLocation")) {
            transfer.setTransferLocation((String)((Object)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_TRANSFER_LOCATION)));
        }
        if (!isMinimalInfo && propertyFilter.isAllowed("transferPDFIndicator") || isMinimalInfo && includeParam.contains("transferPDFIndicator")) {
            transfer.setTransferPDFIndicator((Boolean)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_TRANSFER_PDF_INDICATOR));
        }
    }

    private void mapTransferChildInfo(TransferChild transferChild, FileInfo info, List<String> includeParam, boolean isMinimalInfo) {
        if (includeParam == null || includeParam.isEmpty()) {
            return;
        }
        if (RecordsManagementModel.TYPE_RECORD_FOLDER.equals((Object)info.getType())) {
            if (isMinimalInfo && includeParam.contains("isRecordFolder")) {
                transferChild.setIsRecordFolder(true);
            }
            if (isMinimalInfo && includeParam.contains("isRecord")) {
                transferChild.setIsRecord(false);
            }
            if (isMinimalInfo && includeParam.contains("isClosed")) {
                transferChild.setIsClosed((Boolean)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_IS_CLOSED));
            }
        } else {
            if (isMinimalInfo && includeParam.contains("isRecordFolder")) {
                transferChild.setIsRecordFolder(false);
            }
            if (isMinimalInfo && includeParam.contains("isRecord")) {
                transferChild.setIsRecord(true);
            }
            if (isMinimalInfo && includeParam.contains("isClosed")) {
                transferChild.setIsClosed(null);
            }
        }
    }

    private void mapRecordCategoryChildInfo(RecordCategoryChild recordCategoryChild, FileInfo info, List<String> includeParam, BeanPropertiesFilter propertyFilter, boolean isMinimalInfo) {
        if (isMinimalInfo && (includeParam == null || includeParam.isEmpty())) {
            return;
        }
        if (RecordsManagementModel.TYPE_RECORD_FOLDER.equals((Object)info.getType())) {
            if (!isMinimalInfo && propertyFilter.isAllowed("isRecordFolder") || isMinimalInfo && includeParam.contains("isRecordFolder")) {
                recordCategoryChild.setIsRecordFolder(true);
            }
            if (!isMinimalInfo && propertyFilter.isAllowed("isRecordCategory") || isMinimalInfo && includeParam.contains("isRecordCategory")) {
                recordCategoryChild.setIsRecordCategory(false);
            }
            if (!isMinimalInfo && propertyFilter.isAllowed("isClosed") || isMinimalInfo && includeParam.contains("isClosed")) {
                recordCategoryChild.setIsClosed((Boolean)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_IS_CLOSED));
            }
            if (includeParam.contains("hasRetentionSchedule")) {
                recordCategoryChild.setHasRetentionSchedule(null);
            }
        } else {
            if (!isMinimalInfo && propertyFilter.isAllowed("isRecordFolder") || isMinimalInfo && includeParam.contains("isRecordFolder")) {
                recordCategoryChild.setIsRecordFolder(false);
            }
            if (!isMinimalInfo && propertyFilter.isAllowed("isRecordCategory") || isMinimalInfo && includeParam.contains("isRecordCategory")) {
                recordCategoryChild.setIsRecordCategory(true);
            }
            if (includeParam.contains("hasRetentionSchedule")) {
                DispositionSchedule ds = this.dispositionService.getDispositionSchedule(info.getNodeRef());
                recordCategoryChild.setHasRetentionSchedule(ds != null);
            }
            if (!isMinimalInfo && propertyFilter.isAllowed("isClosed") || isMinimalInfo && includeParam.contains("isClosed")) {
                recordCategoryChild.setIsClosed(null);
            }
        }
    }

    private void mapRecordInfo(Record record, FileInfo info, List<String> includeParam) {
        Serializable val;
        if (includeParam == null || includeParam.isEmpty()) {
            return;
        }
        if (includeParam.contains("isCompleted")) {
            record.setIsCompleted(this.nodeService.hasAspect(info.getNodeRef(), RecordsManagementModel.ASPECT_DECLARED_RECORD));
        }
        if (includeParam.contains("content") && (val = (Serializable)info.getProperties().get(ContentModel.PROP_CONTENT)) != null && val instanceof ContentData) {
            ContentData cd = (ContentData)val;
            String mimeType = cd.getMimetype();
            String mimeTypeName = (String)this.serviceRegistry.getMimetypeService().getDisplaysByMimetype().get(mimeType);
            ContentInfo contentInfo = new ContentInfo(mimeType, mimeTypeName, Long.valueOf(cd.getSize()), cd.getEncoding());
            record.setContent(contentInfo);
        }
    }

    private List<String> mapFromNodeAspects(Set<QName> nodeAspects) {
        return this.nodes.mapFromNodeAspects(nodeAspects, EXCLUDED_NS, EXCLUDED_ASPECTS);
    }

    private Map<String, Object> mapFromNodeProperties(Map<QName, Serializable> properties) {
        return this.nodes.mapFromNodeProperties(properties, new ArrayList(), new HashMap(), EXCLUDED_NS, EXCLUDED_PROPS);
    }

    private void mapAssociations(RMNode rmNode, FileInfo info, List<String> includeParam) {
        if (includeParam.contains("association")) {
            QName assocTypeQName;
            NodeRef nodeRef = info.getNodeRef();
            ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(nodeRef);
            if (parentAssocRef == null || parentAssocRef.getParentRef() == null || !parentAssocRef.getParentRef().equals((Object)rmNode.getParentId())) {
                List parentAssocRefs = this.nodeService.getParentAssocs(nodeRef);
                for (ChildAssociationRef pAssocRef : parentAssocRefs) {
                    if (!pAssocRef.getParentRef().equals((Object)rmNode.getParentId())) continue;
                    parentAssocRef = pAssocRef;
                    break;
                }
            }
            if (parentAssocRef != null && (assocTypeQName = parentAssocRef.getTypeQName()) != null && !EXCLUDED_NS.contains(assocTypeQName.getNamespaceURI())) {
                AssocChild childAssoc = new AssocChild(assocTypeQName.toPrefixString((NamespacePrefixResolver)this.namespaceService), parentAssocRef.isPrimary());
                rmNode.setAssociation((Assoc)childAssoc);
            }
        }
    }

    public FilePlan createFilePlan(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        FilePlan filePlan = new FilePlan();
        this.mapBasicInfo(filePlan, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(filePlan, info, parameters.getInclude(), isMinimalInfo);
        return filePlan;
    }

    public RecordCategory createRecordCategory(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        RecordCategory recordCategory = new RecordCategory();
        this.mapBasicInfo(recordCategory, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(recordCategory, info, parameters.getInclude(), isMinimalInfo);
        if (parameters.getInclude().contains("hasRetentionSchedule")) {
            DispositionSchedule ds = this.dispositionService.getDispositionSchedule(info.getNodeRef());
            recordCategory.setHasRetentionSchedule(ds != null);
        }
        return recordCategory;
    }

    public RecordFolder createRecordFolder(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        RecordFolder recordFolder = new RecordFolder();
        this.mapBasicInfo(recordFolder, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(recordFolder, info, parameters.getInclude(), isMinimalInfo);
        if (parameters.getInclude().contains("isClosed")) {
            recordFolder.setIsClosed((Boolean)this.nodeService.getProperty(info.getNodeRef(), RecordsManagementModel.PROP_IS_CLOSED));
        }
        return recordFolder;
    }

    public UnfiledContainer createUnfiledContainer(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        UnfiledContainer unfiledContainer = new UnfiledContainer();
        this.mapBasicInfo(unfiledContainer, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(unfiledContainer, info, parameters.getInclude(), isMinimalInfo);
        return unfiledContainer;
    }

    public TransferContainer createTransferContainer(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        TransferContainer transferContainer = new TransferContainer();
        this.mapTransferContainerInfo(transferContainer, info, mapUserInfo, parameters.getFilter(), parameters.getInclude(), isMinimalInfo);
        return transferContainer;
    }

    public Transfer createTransfer(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        Transfer transfer = new Transfer();
        this.mapTransferInfo(transfer, info, mapUserInfo, parameters.getFilter(), parameters.getInclude(), isMinimalInfo);
        return transfer;
    }

    public TransferChild createTransferChild(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        TransferChild transferChild = new TransferChild();
        this.mapBasicInfo(transferChild, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(transferChild, info, parameters.getInclude(), isMinimalInfo);
        this.mapTransferChildInfo(transferChild, info, parameters.getInclude(), isMinimalInfo);
        return transferChild;
    }

    public UnfiledContainerChild createUnfiledContainerChild(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        UnfiledContainerChild unfiledContainerChild = new UnfiledContainerChild();
        this.mapBasicInfo(unfiledContainerChild, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(unfiledContainerChild, info, parameters.getInclude(), isMinimalInfo);
        this.mapUnfiledChildInfo(unfiledContainerChild, info, parameters.getFilter());
        if (unfiledContainerChild.getIsRecord().booleanValue()) {
            this.mapAssociations(unfiledContainerChild, info, parameters.getInclude());
        }
        return unfiledContainerChild;
    }

    public UnfiledRecordFolder createUnfiledRecordFolder(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        UnfiledRecordFolder unfiledChild = new UnfiledRecordFolder();
        this.mapBasicInfo(unfiledChild, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(unfiledChild, info, parameters.getInclude(), isMinimalInfo);
        return unfiledChild;
    }

    public UnfiledRecordFolderChild createUnfiledRecordFolderChild(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        UnfiledRecordFolderChild unfiledRecordFolderChild = new UnfiledRecordFolderChild();
        this.mapBasicInfo(unfiledRecordFolderChild, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(unfiledRecordFolderChild, info, parameters.getInclude(), isMinimalInfo);
        this.mapUnfiledChildInfo(unfiledRecordFolderChild, info, parameters.getFilter());
        if (unfiledRecordFolderChild.getIsRecord().booleanValue()) {
            this.mapAssociations(unfiledRecordFolderChild, info, parameters.getInclude());
        }
        return unfiledRecordFolderChild;
    }

    public RecordCategoryChild createRecordCategoryChild(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        RecordCategoryChild recordCategoryChild = new RecordCategoryChild();
        this.mapBasicInfo(recordCategoryChild, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(recordCategoryChild, info, parameters.getInclude(), isMinimalInfo);
        this.mapRecordCategoryChildInfo(recordCategoryChild, info, parameters.getInclude(), parameters.getFilter(), isMinimalInfo);
        return recordCategoryChild;
    }

    public Record createRecord(FileInfo info, Parameters parameters, Map<String, UserInfo> mapUserInfo, boolean isMinimalInfo) {
        Record record = new Record();
        this.mapBasicInfo(record, info, parameters.getFilter(), mapUserInfo, isMinimalInfo);
        this.mapOptionalInfo(record, info, parameters.getInclude(), isMinimalInfo);
        this.mapRecordInfo(record, info, parameters.getInclude());
        this.mapAssociations(record, info, parameters.getInclude());
        return record;
    }
}

