/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.repo.content.ContentLimitViolationException;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.FilterPropBoolean;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.Activities;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InsufficientStorageException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.RequestEntityTooLargeException;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.where.Query;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.workflow.api.impl.MapBasedQueryWalker;
import org.alfresco.rm.rest.api.RMSites;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.SearchTypesFactory;
import org.alfresco.rm.rest.api.model.RMNode;
import org.alfresco.rm.rest.api.model.RMSite;
import org.alfresco.rm.rest.api.model.TransferContainer;
import org.alfresco.rm.rest.api.model.UploadInfo;
import org.alfresco.service.cmr.activities.ActivityInfo;
import org.alfresco.service.cmr.activities.ActivityPoster;
import org.alfresco.service.cmr.attributes.DuplicateAttributeException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.usage.ContentQuotaException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePlanComponentsApiUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchTypesFactory.class);
    public static final String FILE_PLAN_ALIAS = "-filePlan-";
    public static final String TRANSFERS_ALIAS = "-transfers-";
    public static final String UNFILED_ALIAS = "-unfiled-";
    public static final String HOLDS_ALIAS = "-holds-";
    public static final String RM_SITE_ID = "rm";
    public static final List<String> CONTAINERS_FOR_CLASSIFIABLE_CHILDREN_ALIAS = Arrays.asList("-filePlan-", "-unfiled-");
    public static final List<QName> TYPES_CAN_CREATE = Arrays.asList(RecordsManagementModel.TYPE_FILE_PLAN, RecordsManagementModel.TYPE_RECORD_CATEGORY, RecordsManagementModel.TYPE_RECORD_FOLDER, RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER, RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER, RecordsManagementModel.TYPE_HOLD_CONTAINER);
    private Nodes nodes;
    private FileFolderService fileFolderService;
    private FilePlanService filePlanService;
    private NodeService nodeService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private DictionaryService dictionaryService;
    private CapabilityService capabilityService;
    private PermissionService permissionService;
    private RecordService recordService;
    private AuthenticationUtil authenticationUtil;
    private ActivityPoster activityPoster;
    private RMSites sites;

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setAuthenticationUtil(AuthenticationUtil authenticationUtil) {
        this.authenticationUtil = authenticationUtil;
    }

    public void setActivityPoster(ActivityPoster poster) {
        this.activityPoster = poster;
    }

    public void setSites(RMSites sites) {
        this.sites = sites;
    }

    public NodeRef lookupAndValidateNodeType(String nodeId, QName expectedNodeType) throws EntityNotFoundException {
        return this.lookupAndValidateNodeType(nodeId, expectedNodeType, null);
    }

    public NodeRef lookupAndValidateNodeType(String nodeId, QName expectedNodeType, String relativePath) throws EntityNotFoundException {
        return this.lookupAndValidateNodeType(nodeId, expectedNodeType, relativePath, false);
    }

    public NodeRef lookupAndValidateNodeType(String nodeId, QName expectedNodeType, String relativePath, boolean readOnlyRelativePath) throws EntityNotFoundException {
        ParameterCheck.mandatoryString((String)"nodeId", (String)nodeId);
        ParameterCheck.mandatory((String)"expectedNodeType", (Object)expectedNodeType);
        NodeRef nodeRef = this.lookupByPlaceholder(nodeId);
        QName nodeType = this.nodeService.getType(nodeRef);
        if (!nodeType.equals((Object)expectedNodeType)) {
            throw new InvalidArgumentException("The given id:'" + nodeId + "' (nodeType:" + nodeType.toString() + ") is not valid for this endpoint. Expected nodeType is:" + expectedNodeType.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)relativePath)) {
            nodeRef = this.lookupAndValidateRelativePath(nodeRef, relativePath, readOnlyRelativePath, expectedNodeType);
        }
        return nodeRef;
    }

    public NodeRef validateAndLookUpContainerNode(String nodeId, List<String> allowedPlaceholders) {
        ParameterCheck.mandatoryString((String)"nodeId", (String)nodeId);
        NodeRef nodeRef = this.lookupByAllowedPlaceholders(nodeId, allowedPlaceholders);
        QName nodeType = this.nodeService.getType(nodeRef);
        if (!this.dictionaryService.isSubClass(nodeType, ContentModel.TYPE_FOLDER)) {
            throw new InvalidArgumentException("The given id:'" + nodeId + "' (nodeType:" + nodeType.toString() + ") is not valid for this endpoint. Expected nodeType is:" + ContentModel.TYPE_FOLDER.toString());
        }
        return nodeRef;
    }

    public NodeRef lookupByAllowedPlaceholders(String nodeId, List<String> allowedPlaceholders) {
        NodeRef nodeRef = allowedPlaceholders.contains(nodeId) ? this.lookupByPlaceholder(nodeId) : new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        return nodeRef;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NodeRef lookupByPlaceholder(String nodeId) {
        if (nodeId.equals(FILE_PLAN_ALIAS)) {
            NodeRef filePlan = this.filePlanService.getFilePlanBySiteId(RM_SITE_ID);
            if (filePlan == null) throw new EntityNotFoundException(nodeId);
            return filePlan;
        }
        if (nodeId.equals(TRANSFERS_ALIAS)) {
            NodeRef filePlan = this.filePlanService.getFilePlanBySiteId(RM_SITE_ID);
            if (filePlan == null) throw new EntityNotFoundException(nodeId);
            return this.filePlanService.getTransferContainer(filePlan);
        }
        if (nodeId.equals(UNFILED_ALIAS)) {
            NodeRef filePlan = this.filePlanService.getFilePlanBySiteId(RM_SITE_ID);
            if (filePlan == null) throw new EntityNotFoundException(nodeId);
            return this.filePlanService.getUnfiledContainer(filePlan);
        }
        if (!nodeId.equals(HOLDS_ALIAS)) return new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
        NodeRef filePlan = this.filePlanService.getFilePlanBySiteId(RM_SITE_ID);
        if (filePlan == null) throw new EntityNotFoundException(nodeId);
        return this.filePlanService.getHoldContainer(filePlan);
    }

    public List<Pair<QName, Boolean>> getSortProperties(Parameters parameters) {
        ArrayList<Pair<QName, Boolean>> sortProps = new ArrayList<Pair<QName, Boolean>>();
        sortProps.add(new Pair((Object)GetChildrenCannedQuery.SORT_QNAME_NODE_TYPE, (Object)true));
        sortProps.add(new Pair((Object)ContentModel.PROP_NAME, (Object)true));
        return sortProps;
    }

    public void writeContent(NodeRef nodeRef, String fileName, InputStream stream, boolean guessEncoding) {
        try {
            ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
            String mimeType = this.mimetypeService.guessMimetype(fileName);
            if (mimeType != null && !mimeType.equals("application/octet-stream")) {
                writer.setMimetype(mimeType);
            } else {
                writer.guessMimetype(fileName);
            }
            InputStream is = null;
            if (guessEncoding) {
                is = new BufferedInputStream(stream);
                is.mark(1024);
                writer.setEncoding(this.guessEncoding(is, mimeType, false));
                try {
                    is.reset();
                }
                catch (IOException ioe) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Failed to reset stream after trying to guess encoding: " + ioe.getMessage());
                    }
                }
            } else {
                is = stream;
            }
            writer.putContent(is);
        }
        catch (ContentQuotaException cqe) {
            throw new InsufficientStorageException();
        }
        catch (ContentLimitViolationException clv) {
            throw new RequestEntityTooLargeException(clv.getMessage());
        }
        catch (ContentIOException cioe) {
            if (cioe.getCause() instanceof NodeLockedException) {
                throw (NodeLockedException)cioe.getCause();
            }
            throw cioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessEncoding(InputStream in, String mimeType, boolean close) {
        String encoding = "UTF-8";
        try {
            if (in != null) {
                Charset charset = this.mimetypeService.getContentCharsetFinder().getCharset(in, mimeType);
                encoding = charset.name();
            }
        }
        finally {
            block10: {
                try {
                    if (close && in != null) {
                        in.close();
                    }
                }
                catch (IOException ioe) {
                    if (!LOGGER.isWarnEnabled()) break block10;
                    LOGGER.warn("Failed to close stream after trying to guess encoding: " + ioe.getMessage());
                }
            }
        }
        return encoding;
    }

    public NodeRef lookupAndValidateRelativePath(NodeRef parentNodeRef, String relativePath, QName nodesType) {
        return this.lookupAndValidateRelativePath(parentNodeRef, relativePath, false, nodesType);
    }

    public NodeRef lookupAndValidateRelativePath(NodeRef parentNodeRef, String relativePath, boolean readOnlyRelativePath, QName nodesType) {
        String pathElement;
        NodeRef contextParentNodeRef;
        NodeRef child;
        int i;
        ParameterCheck.mandatory((String)"parentNodeRef", (Object)parentNodeRef);
        ParameterCheck.mandatory((String)"nodesType", (Object)nodesType);
        if (StringUtils.isBlank((CharSequence)relativePath)) {
            return parentNodeRef;
        }
        List<String> pathElements = this.getPathElements(relativePath);
        if (pathElements.isEmpty()) {
            return parentNodeRef;
        }
        NodeRef lastNodeRef = parentNodeRef;
        for (i = 0; i < pathElements.size() && (child = this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<NodeRef>(){
            final /* synthetic */ NodeRef val$contextParentNodeRef;
            final /* synthetic */ String val$pathElement;
            {
                this.val$contextParentNodeRef = nodeRef;
                this.val$pathElement = string;
            }

            public NodeRef doWork() throws Exception {
                return FilePlanComponentsApiUtils.this.nodeService.getChildByName(this.val$contextParentNodeRef, ContentModel.ASSOC_CONTAINS, this.val$pathElement);
            }
        })) != null; ++i) {
            lastNodeRef = child;
        }
        if (i == pathElements.size()) {
            QName nodeType = this.nodeService.getType(lastNodeRef);
            if (!nodeType.equals((Object)nodesType)) {
                throw new InvalidArgumentException("The given id:'" + parentNodeRef.getId() + "' and the relative path '" + relativePath + "' reach a node type invalid for this endpoint. Expected nodeType is:" + nodesType.toString() + ". Actual nodeType is:" + String.valueOf(nodeType));
            }
            return lastNodeRef;
        }
        if (readOnlyRelativePath) {
            throw new NotFoundException("The entity with relativePath: " + relativePath + " was not found.");
        }
        pathElements = pathElements.subList(i, pathElements.size());
        if (nodesType.equals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER)) {
            for (String pathElement2 : pathElements) {
                lastNodeRef = this.fileFolderService.create(lastNodeRef, pathElement2, RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER).getNodeRef();
            }
        } else if (nodesType.equals((Object)RecordsManagementModel.TYPE_RECORD_CATEGORY)) {
            for (String pathElement2 : pathElements) {
                lastNodeRef = this.filePlanService.createRecordCategory(lastNodeRef, pathElement2);
            }
        } else {
            throw new InvalidArgumentException("Creating relative path of type '" + String.valueOf(nodesType) + "' not suported for this endpoint");
        }
        return lastNodeRef;
    }

    private List<String> getPathElements(String path) {
        ArrayList<String> pathElements = new ArrayList<String>();
        if (path != null && path.trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreTokens()) {
                pathElements.add(tokenizer.nextToken().trim());
            }
        }
        return pathElements;
    }

    public Map<QName, Serializable> mapToNodeProperties(Map<String, Object> properties) {
        Map response = null;
        if (properties != null) {
            response = this.nodes.mapToNodeProperties(properties);
        }
        return response;
    }

    public NodeRef createRMNode(NodeRef parentNodeRef, RMNode nodeInfo, Parameters parameters) {
        ParameterCheck.mandatory((String)"parentNodeRef", (Object)parentNodeRef);
        ParameterCheck.mandatory((String)"nodeInfo", (Object)nodeInfo);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        String nodeName = nodeInfo.getName();
        String nodeType = nodeInfo.getNodeType();
        RMParameterCheck.checkNotBlank("name", nodeName);
        RMParameterCheck.checkNotBlank("nodeType", nodeType);
        NodeRef newNodeRef = null;
        boolean autoRename = Boolean.valueOf(parameters.getParameter("autoRename"));
        try {
            List<String> aspectNames;
            NodeRef existingNode;
            QName typeQName = this.nodes.createQName(nodeType);
            if (autoRename && (existingNode = this.nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, nodeName)) != null) {
                nodeName = this.findUniqueName(parentNodeRef, nodeName);
            }
            newNodeRef = this.fileFolderService.create(parentNodeRef, nodeName, typeQName).getNodeRef();
            Map<QName, Serializable> qnameProperties = this.mapToNodeProperties(nodeInfo.getProperties());
            if (qnameProperties != null) {
                this.nodeService.addProperties(newNodeRef, qnameProperties);
            }
            if (!typeQName.equals((Object)RecordsManagementModel.TYPE_NON_ELECTRONIC_DOCUMENT) && this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_CONTENT)) {
                this.writeContent(newNodeRef, nodeName, new ByteArrayInputStream("".getBytes()), false);
            }
            if ((aspectNames = nodeInfo.getAspectNames()) != null) {
                this.nodes.addCustomAspects(newNodeRef, aspectNames, ApiNodesModelFactory.EXCLUDED_ASPECTS);
            }
        }
        catch (FileFolderServiceImpl.InvalidTypeException ex) {
            throw new InvalidArgumentException("The given type:'" + nodeType + "' is invalid '");
        }
        catch (DuplicateAttributeException ex) {
            throw new IntegrityException(ex.getMessage(), null);
        }
        return newNodeRef;
    }

    public NodeRef uploadRecord(NodeRef parentNodeRef, UploadInfo uploadInfo, Parameters parameters) {
        NodeRef existingNode;
        QName typeQName;
        ParameterCheck.mandatory((String)"parentNodeRef", (Object)parentNodeRef);
        ParameterCheck.mandatory((String)"uploadInfo", (Object)uploadInfo);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        String nodeName = uploadInfo.getFileName();
        String nodeType = uploadInfo.getNodeType();
        InputStream stream = uploadInfo.getContent().getInputStream();
        ParameterCheck.mandatory((String)"stream", (Object)stream);
        RMParameterCheck.checkNotBlank("name", nodeName);
        QName qName = typeQName = StringUtils.isBlank((CharSequence)nodeType) ? ContentModel.TYPE_CONTENT : this.nodes.createQName(nodeType);
        if (!this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_CONTENT)) {
            throw new InvalidArgumentException("Can only upload type of cm:content: " + String.valueOf(typeQName));
        }
        boolean autoRename = Boolean.valueOf(parameters.getParameter("autoRename"));
        if (autoRename && (existingNode = this.nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, nodeName)) != null) {
            nodeName = this.findUniqueName(parentNodeRef, nodeName);
        }
        NodeRef newNodeRef = this.fileFolderService.create(parentNodeRef, nodeName, typeQName).getNodeRef();
        this.writeContent(newNodeRef, nodeName, stream, true);
        Map<QName, Serializable> qnameProperties = this.mapToNodeProperties(uploadInfo.getProperties());
        if (qnameProperties != null) {
            this.nodeService.addProperties(newNodeRef, qnameProperties);
        }
        return newNodeRef;
    }

    public List<FilterProp> getListChildrenFilterProps(Parameters parameters, Set<String> listFolderChildrenEqualsQueryProperties) {
        ArrayList<FilterPropBoolean> filterProps = null;
        Query q = parameters.getQuery();
        if (q != null) {
            Boolean isClosed;
            MapBasedQueryWalker propertyWalker = new MapBasedQueryWalker(listFolderChildrenEqualsQueryProperties, null);
            QueryHelper.walk((Query)q, (QueryHelper.WalkerCallback)propertyWalker);
            Boolean isPrimary = (Boolean)propertyWalker.getProperty("isPrimary", 8, Boolean.class);
            if (isPrimary != null) {
                filterProps = new ArrayList<FilterPropBoolean>(1);
                filterProps.add(new FilterPropBoolean(GetChildrenCannedQuery.FILTER_QNAME_NODE_IS_PRIMARY, isPrimary));
            }
            if ((isClosed = (Boolean)propertyWalker.getProperty("isClosed", 8, Boolean.class)) != null) {
                filterProps = new ArrayList(1);
                filterProps.add(new FilterPropBoolean(RecordsManagementModel.PROP_IS_CLOSED, isClosed));
            }
        }
        return filterProps;
    }

    public void updateNode(NodeRef nodeRef, RMNode updateInfo, Parameters parameters) {
        String name;
        Map<Object, Object> props = new HashMap(0);
        if (updateInfo.getProperties() != null) {
            props = this.mapToNodeProperties(updateInfo.getProperties());
        }
        if ((name = updateInfo.getName()) != null && !name.isEmpty()) {
            props.put(ContentModel.PROP_NAME, name);
        }
        try {
            this.nodeService.addProperties(nodeRef, props);
        }
        catch (DuplicateChildNodeNameException dcne) {
            throw new ConstraintViolatedException(dcne.getMessage());
        }
        List<String> aspectNames = updateInfo.getAspectNames();
        this.nodes.updateCustomAspects(nodeRef, aspectNames, ApiNodesModelFactory.EXCLUDED_ASPECTS);
    }

    public NodeRef validateRecord(String recordId) throws InvalidArgumentException {
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, recordId);
        if (!this.recordService.isRecord(nodeRef)) {
            throw new IllegalArgumentException("The given id:'" + recordId + "' is not valid for this endpoint. This endpoint only supports records.");
        }
        return nodeRef;
    }

    public BinaryResource getContent(NodeRef nodeRef, Parameters parameters, boolean recordActivity) {
        return this.nodes.getContent(nodeRef, parameters, recordActivity);
    }

    public void updateTransferContainer(NodeRef nodeRef, TransferContainer transferContainerInfo, Parameters parameters) {
        String name;
        Map<Object, Object> props = new HashMap(0);
        if (transferContainerInfo.getProperties() != null) {
            props = this.mapToNodeProperties(transferContainerInfo.getProperties());
        }
        if ((name = transferContainerInfo.getName()) != null && !name.isEmpty()) {
            props.put(ContentModel.PROP_NAME, name);
        }
        try {
            this.nodeService.addProperties(nodeRef, props);
        }
        catch (DuplicateChildNodeNameException dcne) {
            throw new ConstraintViolatedException(dcne.getMessage());
        }
    }

    protected List<String> getAllowableOperations(NodeRef nodeRef, QName typeQName) {
        boolean isSpecialContainer;
        ArrayList<String> allowableOperations = new ArrayList<String>();
        boolean isFilePlan = typeQName.equals((Object)RecordsManagementModel.TYPE_FILE_PLAN);
        boolean isTransferContainer = typeQName.equals((Object)RecordsManagementModel.TYPE_TRANSFER_CONTAINER);
        boolean isUnfiledContainer = typeQName.equals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER);
        boolean isHoldsContainer = typeQName.equals((Object)RecordsManagementModel.TYPE_HOLD_CONTAINER);
        boolean bl = isSpecialContainer = isFilePlan || isTransferContainer || isUnfiledContainer || isHoldsContainer;
        if (!isSpecialContainer && this.capabilityService.getCapability("Delete").evaluate(nodeRef) == 1) {
            allowableOperations.add("delete");
        }
        if (TYPES_CAN_CREATE.contains(typeQName) && this.capabilityService.getCapability("FillingPermissionOnly").evaluate(nodeRef) == 1) {
            allowableOperations.add("create");
        }
        if (this.capabilityService.getCapability("Update").evaluate(nodeRef) == 1) {
            allowableOperations.add("update");
        }
        return allowableOperations;
    }

    public QName getFilePlanType() {
        NodeRef filePlanNodeRef = this.filePlanService.getFilePlanBySiteId(RM_SITE_ID);
        if (filePlanNodeRef != null) {
            return this.nodeService.getType(filePlanNodeRef);
        }
        return null;
    }

    public void postActivity(FileInfo fileInfo, NodeRef parentNodeRef, String activityType) {
        ActivityInfo activityInfo = null;
        RMSite rmSite = this.sites.getRMSite(RM_SITE_ID);
        if (rmSite != null && !rmSite.getId().equals("")) {
            boolean isContent;
            if (fileInfo != null && (isContent = this.dictionaryService.isSubClass(fileInfo.getType(), ContentModel.TYPE_CONTENT))) {
                activityInfo = new ActivityInfo(null, parentNodeRef, RM_SITE_ID, fileInfo);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Non-site activity, so ignored " + String.valueOf(fileInfo.getNodeRef()));
        }
        if (activityInfo == null) {
            return;
        }
        if (activityType != null) {
            this.activityPoster.postFileFolderActivity(activityType, null, TenantUtil.getCurrentDomain(), activityInfo.getSiteId(), activityInfo.getParentNodeRef(), activityInfo.getNodeRef(), activityInfo.getFileName(), "restapi", Activities.RESTAPI_CLIENT, activityInfo.getFileInfo());
        }
    }

    private String findUniqueName(NodeRef parentNodeRef, String fileName) {
        String tmpFilename;
        NodeRef existingFile;
        int counter = 1;
        do {
            int dotIndex;
            tmpFilename = (dotIndex = fileName.lastIndexOf(46)) == 0 ? counter + fileName : (dotIndex > 0 ? fileName.substring(0, dotIndex) + "-" + counter + fileName.substring(dotIndex) : fileName + "-" + counter);
            existingFile = this.nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, tmpFilename);
            ++counter;
        } while (existingFile != null);
        return tmpFilename;
    }
}

