/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.hold;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldServicePolicies;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.ClassBehaviourBinding;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.GUID;

public class AddToHoldTest
extends BaseRMTestCase
implements HoldServicePolicies.BeforeAddToHoldPolicy,
HoldServicePolicies.OnAddToHoldPolicy {
    private static final int RECORD_COUNT = 10;
    private boolean beforeAddToHoldFlag = false;
    private boolean onAddToHoldFlag = false;

    public void testAddRecordToHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef recordCategory;
            private NodeRef recordFolder;
            private NodeRef record;

            @Override
            public void given() {
                this.hold = AddToHoldTest.this.holdService.createHold(AddToHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                this.recordCategory = AddToHoldTest.this.filePlanService.createRecordCategory(AddToHoldTest.this.filePlan, GUID.generate());
                this.recordFolder = AddToHoldTest.this.recordFolderService.createRecordFolder(this.recordCategory, GUID.generate());
                this.record = AddToHoldTest.this.recordService.createRecordFromContent(this.recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null);
                TestCase.assertFalse((boolean)AddToHoldTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertFalse((boolean)AddToHoldTest.this.freezeService.isFrozen(this.record));
                TestCase.assertFalse((boolean)AddToHoldTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                TestCase.assertTrue((boolean)AddToHoldTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)0, (Object)AddToHoldTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }

            @Override
            public void when() throws Exception {
                AddToHoldTest.this.holdService.addToHold(this.hold, this.record);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)AddToHoldTest.this.freezeService.isFrozen(this.record));
                TestCase.assertFalse((boolean)AddToHoldTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertTrue((boolean)AddToHoldTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                TestCase.assertFalse((boolean)AddToHoldTest.this.holdService.getHeld(this.hold).contains(this.recordFolder));
                TestCase.assertFalse((boolean)AddToHoldTest.this.holdService.heldBy(this.recordFolder, true).contains(this.hold));
                TestCase.assertTrue((boolean)AddToHoldTest.this.holdService.getHeld(this.hold).contains(this.record));
                TestCase.assertTrue((boolean)AddToHoldTest.this.holdService.heldBy(this.record, true).contains(this.hold));
                TestCase.assertTrue((boolean)AddToHoldTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)1, (Object)AddToHoldTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }
        });
    }

    public void testAddRecordsToHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef recordCategory;
            private NodeRef recordFolder;
            private List<NodeRef> records;
            {
                this.records = new ArrayList<NodeRef>(10);
            }

            @Override
            public void given() {
                this.hold = AddToHoldTest.this.holdService.createHold(AddToHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                this.recordCategory = AddToHoldTest.this.filePlanService.createRecordCategory(AddToHoldTest.this.filePlan, GUID.generate());
                this.recordFolder = AddToHoldTest.this.recordFolderService.createRecordFolder(this.recordCategory, GUID.generate());
                for (int i = 0; i < 10; ++i) {
                    this.records.add(AddToHoldTest.this.recordService.createRecordFromContent(this.recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null));
                }
                TestCase.assertFalse((boolean)AddToHoldTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertFalse((boolean)AddToHoldTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                for (NodeRef record : this.records) {
                    TestCase.assertFalse((boolean)AddToHoldTest.this.freezeService.isFrozen(record));
                }
                TestCase.assertTrue((boolean)AddToHoldTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)0, (Object)AddToHoldTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }

            @Override
            public void when() throws Exception {
                AddToHoldTest.this.holdService.addToHold(this.hold, this.records);
            }

            @Override
            public void then() {
                for (NodeRef record : this.records) {
                    TestCase.assertTrue((boolean)AddToHoldTest.this.freezeService.isFrozen(record));
                }
                TestCase.assertFalse((boolean)AddToHoldTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertTrue((boolean)AddToHoldTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                TestCase.assertFalse((boolean)AddToHoldTest.this.holdService.getHeld(this.hold).contains(this.recordFolder));
                TestCase.assertFalse((boolean)AddToHoldTest.this.holdService.heldBy(this.recordFolder, true).contains(this.hold));
                for (NodeRef record : this.records) {
                    TestCase.assertTrue((boolean)AddToHoldTest.this.holdService.getHeld(this.hold).contains(record));
                    TestCase.assertTrue((boolean)AddToHoldTest.this.holdService.heldBy(record, true).contains(this.hold));
                }
                TestCase.assertTrue((boolean)AddToHoldTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)10, (Object)AddToHoldTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }
        });
    }

    public void testAddRecordFolderToHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef recordCategory;
            private NodeRef recordFolder;
            private List<NodeRef> records;
            {
                this.records = new ArrayList<NodeRef>(10);
            }

            @Override
            public void given() {
                this.hold = AddToHoldTest.this.holdService.createHold(AddToHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                this.recordCategory = AddToHoldTest.this.filePlanService.createRecordCategory(AddToHoldTest.this.filePlan, GUID.generate());
                this.recordFolder = AddToHoldTest.this.recordFolderService.createRecordFolder(this.recordCategory, GUID.generate());
                for (int i = 0; i < 10; ++i) {
                    this.records.add(AddToHoldTest.this.recordService.createRecordFromContent(this.recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null));
                }
                TestCase.assertFalse((boolean)AddToHoldTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertFalse((boolean)AddToHoldTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                for (NodeRef record : this.records) {
                    TestCase.assertFalse((boolean)AddToHoldTest.this.freezeService.isFrozen(record));
                }
                TestCase.assertTrue((boolean)AddToHoldTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)0, (Object)AddToHoldTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }

            @Override
            public void when() throws Exception {
                AddToHoldTest.this.holdService.addToHold(this.hold, this.recordFolder);
            }

            @Override
            public void then() {
                for (NodeRef record : this.records) {
                    TestCase.assertTrue((boolean)AddToHoldTest.this.freezeService.isFrozen(record));
                    TestCase.assertFalse((boolean)AddToHoldTest.this.holdService.getHeld(this.hold).contains(record));
                    TestCase.assertTrue((boolean)AddToHoldTest.this.holdService.heldBy(record, true).contains(this.hold));
                }
                TestCase.assertTrue((boolean)AddToHoldTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertTrue((boolean)AddToHoldTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                TestCase.assertTrue((boolean)AddToHoldTest.this.holdService.getHeld(this.hold).contains(this.recordFolder));
                TestCase.assertTrue((boolean)AddToHoldTest.this.holdService.heldBy(this.recordFolder, true).contains(this.hold));
                TestCase.assertTrue((boolean)AddToHoldTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)10, (Object)AddToHoldTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }
        });
    }

    public void testPolicyNotificationForAddToHold() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef recordCategory;
            private NodeRef recordFolder;
            BehaviourDefinition<ClassBehaviourBinding> beforeAddToHoldBehaviour;
            BehaviourDefinition<ClassBehaviourBinding> onAddToHoldBehaviour;

            @Override
            public void given() {
                this.hold = AddToHoldTest.this.holdService.createHold(AddToHoldTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                this.recordCategory = AddToHoldTest.this.filePlanService.createRecordCategory(AddToHoldTest.this.filePlan, GUID.generate());
                this.recordFolder = AddToHoldTest.this.recordFolderService.createRecordFolder(this.recordCategory, GUID.generate());
                this.beforeAddToHoldBehaviour = AddToHoldTest.this.policyComponent.bindClassBehaviour(HoldServicePolicies.BeforeAddToHoldPolicy.QNAME, RecordsManagementModel.TYPE_HOLD, (Behaviour)new JavaBehaviour((Object)AddToHoldTest.this, "beforeAddToHold", Behaviour.NotificationFrequency.EVERY_EVENT));
                this.onAddToHoldBehaviour = AddToHoldTest.this.policyComponent.bindClassBehaviour(HoldServicePolicies.OnAddToHoldPolicy.QNAME, RecordsManagementModel.TYPE_HOLD, (Behaviour)new JavaBehaviour((Object)AddToHoldTest.this, "onAddToHold", Behaviour.NotificationFrequency.EVERY_EVENT));
                TestCase.assertFalse((boolean)AddToHoldTest.this.beforeAddToHoldFlag);
                TestCase.assertFalse((boolean)AddToHoldTest.this.onAddToHoldFlag);
            }

            @Override
            public void when() throws Exception {
                AddToHoldTest.this.holdService.addToHold(this.hold, this.recordFolder);
            }

            @Override
            public void then() {
                TestCase.assertTrue((boolean)AddToHoldTest.this.beforeAddToHoldFlag);
                TestCase.assertTrue((boolean)AddToHoldTest.this.onAddToHoldFlag);
            }

            @Override
            public void after() {
                AddToHoldTest.this.policyComponent.removeClassDefinition(this.beforeAddToHoldBehaviour);
                AddToHoldTest.this.policyComponent.removeClassDefinition(this.onAddToHoldBehaviour);
            }
        });
    }

    public void beforeAddToHold(NodeRef hold, NodeRef contentNodeRef) {
        this.beforeAddToHoldFlag = true;
    }

    public void onAddToHold(NodeRef hold, NodeRef contentNodeRef) {
        this.onAddToHoldFlag = true;
    }
}

