/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.capabilities;

import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.RetryingTransactionHelperTestCase;

public class CompositeCapabilityTest
extends BaseRMTestCase {
    private NodeRef record;
    private NodeRef declaredRecord;

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setupTestDataImpl() {
        super.setupTestDataImpl();
        this.record = this.utils.createRecord(this.rmFolder, "record.txt");
        this.declaredRecord = this.utils.createRecord(this.rmFolder, "declaredRecord.txt");
    }

    @Override
    protected void setupTestData() {
        super.setupTestData();
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                CompositeCapabilityTest.this.utils.completeRecord(CompositeCapabilityTest.this.declaredRecord);
                return null;
            }
        });
    }

    @Override
    protected void tearDownImpl() {
        super.tearDownImpl();
    }

    @Override
    protected void setupTestUsersImpl(NodeRef filePlan) {
        super.setupTestUsersImpl(filePlan);
        for (String user : this.testUsers) {
            this.filePlanPermissionService.setPermission(this.rmContainer, user, "Filing");
        }
    }

    public void testUpdate() {
        final Capability capability = this.capabilityService.getCapability("Update");
        CompositeCapabilityTest.assertNotNull((Object)capability);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)capability.hasPermission(CompositeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)capability.hasPermission(CompositeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)capability.hasPermission(CompositeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)capability.hasPermission(CompositeCapabilityTest.this.declaredRecord));
                return null;
            }
        }, this.recordsManagerName);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(CompositeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(CompositeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(CompositeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(CompositeCapabilityTest.this.declaredRecord));
                return null;
            }
        }, this.userName);
    }

    public void testUpdateProperties() {
        final Capability capability = this.capabilityService.getCapability("UpdateProperties");
        CompositeCapabilityTest.assertNotNull((Object)capability);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)capability.hasPermission(CompositeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)capability.hasPermission(CompositeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)capability.hasPermission(CompositeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)capability.hasPermission(CompositeCapabilityTest.this.declaredRecord));
                return null;
            }
        }, this.recordsManagerName);
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(CompositeCapabilityTest.this.rmContainer));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(CompositeCapabilityTest.this.rmFolder));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(CompositeCapabilityTest.this.record));
                TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)capability.hasPermission(CompositeCapabilityTest.this.declaredRecord));
                return null;
            }
        }, this.userName);
    }
}

