/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.webscript;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMWebScriptTestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class RmClassesRestApiTest
extends BaseRMWebScriptTestCase {
    private static final String RM_ASPECTS_URL = "/api/rm/classes?cf=%s&siteId=%s";

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testRmGetAspectDefinitions() throws IOException, JSONException {
        String url = String.format(RM_ASPECTS_URL, "aspect", this.siteId);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        String contentAsString = response.getContentAsString();
        RmClassesRestApiTest.assertNotNull((Object)contentAsString);
        JSONArray contentAsJson = new JSONArray(contentAsString);
        RmClassesRestApiTest.assertNotNull((Object)contentAsJson);
        List<String> dmAspects = this.getDmAspects();
        List<String> rmAspects = this.getRmAspects();
        ArrayList<String> rmAspectList = new ArrayList<String>();
        for (int i = 0; i < contentAsJson.length(); ++i) {
            String name = contentAsJson.getJSONObject(i).getString("name");
            RmClassesRestApiTest.assertNotNull((Object)name);
            rmAspectList.add(name);
            RmClassesRestApiTest.assertFalse((boolean)dmAspects.contains(name));
        }
        RmClassesRestApiTest.assertTrue((boolean)rmAspectList.containsAll(rmAspects));
        url = String.format(RM_ASPECTS_URL, "aspect", this.collabSiteId);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        contentAsString = response.getContentAsString();
        RmClassesRestApiTest.assertNotNull((Object)contentAsString);
        contentAsJson = new JSONArray(contentAsString);
        RmClassesRestApiTest.assertNotNull((Object)contentAsJson);
        ArrayList<String> dmAspectList = new ArrayList<String>();
        for (int i = 0; i < contentAsJson.length(); ++i) {
            String name = contentAsJson.getJSONObject(i).getString("name");
            RmClassesRestApiTest.assertNotNull((Object)name);
            dmAspectList.add(name);
        }
        RmClassesRestApiTest.assertTrue((boolean)dmAspectList.containsAll(dmAspects));
        RmClassesRestApiTest.assertTrue((boolean)dmAspectList.containsAll(rmAspects));
    }

    private List<String> getRmAspects() {
        return Arrays.asList("rma:ascended", "rma:recordMetaData", "rma:vitalRecordDefinition");
    }

    private List<String> getDmAspects() {
        return Arrays.asList("emailserver:attached", "bpm:assignees", "cm:likesRatingSchemeRollups", "wf:parallelReviewStats", "sys:localized");
    }
}

