/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.junit.Assert;

public class BaseYamlUnitTest {
    private static String SWAGGER_2_SCHEMA_LOCATION = "/rest/schema.json";
    private static String OPEN_API_SPECIFICATION = "2.0";

    protected Set<String> getYamlFilesList(String pathName) throws Exception {
        HashSet<String> yamlFilePathNames = new HashSet<String>();
        File directory = new File(pathName);
        Collection yamlFiles = FileUtils.listFiles((File)directory, (IOFileFilter)new WildcardFileFilter("*.yaml"), null);
        for (File file : yamlFiles) {
            yamlFilePathNames.add(file.getCanonicalPath());
        }
        return yamlFilePathNames;
    }

    protected void validateYamlFiles(Set<String> yamlFileNames) throws ProcessingException, IOException {
        Assert.assertFalse((String)"Expected at least 1 yaml file to validate", (boolean)yamlFileNames.isEmpty());
        JsonSchema swaggerSchema = this.getSwaggerSchema(SWAGGER_2_SCHEMA_LOCATION);
        Assert.assertNotNull((String)"Failed to obtain the Swagger schema", (Object)swaggerSchema);
        for (String yamlFilePath : yamlFileNames) {
            try {
                Assert.assertTrue((String)("Yaml file is not valid Swagger " + OPEN_API_SPECIFICATION + ": " + yamlFilePath), (boolean)this.validateYamlFile(yamlFilePath, swaggerSchema));
                Swagger swagger = new SwaggerParser().read(yamlFilePath);
                Assert.assertEquals((String)("Failed to obtain Swagger version from yaml file " + yamlFilePath), (Object)swagger.getSwagger(), (Object)OPEN_API_SPECIFICATION);
            }
            catch (ProcessingException ex) {
                String context = String.format(yamlFilePath + ": %n" + ex.getMessage(), new Object[0]);
                throw new ProcessingException(context);
            }
        }
    }

    private JsonSchema getSwaggerSchema(String schemaLocation) throws IOException, ProcessingException {
        JsonSchema swaggerSchema = null;
        InputStream in = this.getClass().getResourceAsStream(schemaLocation);
        if (in != null) {
            String swaggerSchemaAsString = IOUtils.toString((InputStream)in);
            JsonNode schemaNode = JsonLoader.fromString((String)swaggerSchemaAsString);
            JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
            swaggerSchema = factory.getJsonSchema(schemaNode);
        }
        return swaggerSchema;
    }

    private boolean validateYamlFile(String yamlFilePath, JsonSchema jsonSchema) throws IOException, ProcessingException {
        String yaml = new String(Files.readAllBytes(Paths.get(yamlFilePath, new String[0])));
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object obj = yamlReader.readValue(yaml, Object.class);
        ObjectMapper jsonWriter = new ObjectMapper();
        String yamlAsJsonString = jsonWriter.writeValueAsString(obj);
        return this.validateJSON(yamlAsJsonString, jsonSchema);
    }

    private boolean validateJSON(String jsonData, JsonSchema schema) throws IOException, ProcessingException {
        Iterator messages;
        JsonNode dataNode = JsonLoader.fromString((String)jsonData);
        ProcessingReport report = schema.validate(dataNode);
        boolean isOk = report.isSuccess();
        if (!isOk && (messages = report.iterator()).hasNext()) {
            throw new ProcessingException(((ProcessingMessage)messages.next()).toString());
        }
        return isOk;
    }
}

