/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.WebScriptUtils;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractRmWebScript
extends DeclarativeWebScript {
    protected static final String PATH_SEPARATOR = "/";
    protected static final String STORE_TYPE = "store_type";
    protected static final String STORE_ID = "store_id";
    protected static final String ID = "id";
    protected static final String SUCCESS = "success";
    protected static final String INVERT = "__invert";
    private DispositionService dispositionService;
    private NamespaceService namespaceService;
    private NodeService nodeService;

    protected DispositionService getDispositionService() {
        return this.dispositionService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    protected NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected NodeRef parseRequestForNodeRef(WebScriptRequest req) {
        Map<String, String> templateVars = WebScriptUtils.getTemplateVars(req);
        String storeType = templateVars.get(STORE_TYPE);
        String storeId = templateVars.get(STORE_ID);
        String nodeId = templateVars.get(ID);
        NodeRef nodeRef = new NodeRef(storeType, storeId, nodeId);
        if (!this.getNodeService().exists(nodeRef)) {
            throw new WebScriptException(404, "Unable to find node: '" + nodeRef.toString() + "'.");
        }
        return nodeRef;
    }
}

