/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.workflow.requestInfo;

import java.util.List;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;

public final class RequestInfoUtils {
    private RequestInfoUtils() {
    }

    public static ServiceRegistry getServiceRegistry() {
        ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
        if (config != null) {
            ServiceRegistry registry = (ServiceRegistry)config.getBeans().get("services");
            if (registry == null) {
                throw new AlfrescoRuntimeException("Service-registry not present in ProcessEngineConfiguration beans, expected ServiceRegistry with keyservices");
            }
            return registry;
        }
        throw new IllegalStateException("No ProcessEngineCOnfiguration found in active context");
    }

    public static String getRecordName(DelegateTask delegateTask) {
        ParameterCheck.mandatory((String)"delegateTask", (Object)delegateTask);
        String recordName = "";
        NodeService nodeService = RequestInfoUtils.getServiceRegistry().getNodeService();
        ActivitiScriptNode scriptNode = (ActivitiScriptNode)delegateTask.getVariable("bpm_package");
        List childAssocs = nodeService.getChildAssocs(scriptNode.getNodeRef());
        if (childAssocs.size() > 0) {
            NodeRef docRef = ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
            recordName = (String)((Object)nodeService.getProperty(docRef, ContentModel.PROP_NAME));
        }
        return recordName;
    }

    public static String getInitiator(DelegateTask delegateTask) {
        ActivitiScriptNode initiator;
        ParameterCheck.mandatory((String)"delegateTask", (Object)delegateTask);
        String userName = null;
        String ruleCreator = (String)delegateTask.getVariable("rmwf_ruleCreator");
        userName = StringUtils.isBlank((CharSequence)ruleCreator) ? ((initiator = (ActivitiScriptNode)delegateTask.getVariable("initiator")).exists() ? (String)initiator.getProperties().get(ContentModel.PROP_USERNAME.toString()) : AuthenticationUtil.getAdminUserName()) : ruleCreator;
        return userName;
    }
}

