/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.script.AbstractRmWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.WebScriptUtils;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RelationshipDelete
extends AbstractRmWebScript {
    private static final String STORE_TYPE = "target_store_type";
    private static final String STORE_ID = "target_store_id";
    private static final String ID = "target_id";
    private static final String UNIQUE_NAME = "uniqueName";
    private RelationshipService relationshipService;

    protected RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String uniqueName = WebScriptUtils.getRequestParameterValue(req, UNIQUE_NAME);
        NodeRef source = this.parseRequestForNodeRef(req);
        NodeRef target = this.parseRequestForTargetNodeRef(req);
        this.getRelationshipService().removeRelationship(uniqueName, source, target);
        this.getRelationshipService().removeRelationship(uniqueName, target, source);
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("success", true);
        return model;
    }

    private NodeRef parseRequestForTargetNodeRef(WebScriptRequest req) {
        Map<String, String> templateVars = WebScriptUtils.getTemplateVars(req);
        String storeType = templateVars.get(STORE_TYPE);
        String storeId = templateVars.get(STORE_ID);
        String nodeId = templateVars.get(ID);
        NodeRef nodeRef = new NodeRef(storeType, storeId, nodeId);
        if (!this.getNodeService().exists(nodeRef)) {
            throw new WebScriptException(404, "Unable to find node: '" + nodeRef.toString() + "'.");
        }
        return nodeRef;
    }
}

