/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.capability;

import java.lang.reflect.Method;
import java.util.Iterator;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.ConfigAttribute;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.capability.RMEntryVoter;
import org.alfresco.module.org_alfresco_module_rm.capability.policy.ConfigAttributeDefinition;
import org.alfresco.module.org_alfresco_module_rm.capability.policy.Policy;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RMEntryVoterUnitTest
extends BaseUnitTest {
    private static final String POLICY_NAME = "myPolicy";
    @InjectMocks
    private RMEntryVoter entryVoter;
    @Mock
    private Policy mockedPolicy;
    @Mock
    private Authentication mockedAuthentication;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        Mockito.when((Object)this.mockedAuthenticationUtil.isRunAsUserTheSystemUser()).thenReturn((Object)false);
        Mockito.when((Object)this.mockedTransactionalResourceHelper.isResourcePresent((Object)"voting")).thenReturn((Object)false);
    }

    @Test
    public void alreadyVoting() throws Exception {
        Mockito.when((Object)this.mockedTransactionalResourceHelper.isResourcePresent((Object)"voting")).thenReturn((Object)true);
        MethodInvocation mockedMethodInvocation = this.createMethodInvoation("myTestMethod", NodeRef.class);
        net.sf.acegisecurity.ConfigAttributeDefinition mockedConfigDef = this.createConfigDefinition("RM.invalid");
        Assert.assertEquals((long)1L, (long)this.entryVoter.vote(this.mockedAuthentication, (Object)mockedMethodInvocation, mockedConfigDef));
    }

    @Test
    public void runAsSystem() throws Exception {
        Mockito.when((Object)this.mockedAuthenticationUtil.isRunAsUserTheSystemUser()).thenReturn((Object)true);
        MethodInvocation mockedMethodInvocation = this.createMethodInvoation("myTestMethod", NodeRef.class);
        net.sf.acegisecurity.ConfigAttributeDefinition mockedConfigDef = this.createConfigDefinition("RM.invalid");
        Assert.assertEquals((long)1L, (long)this.entryVoter.vote(this.mockedAuthentication, (Object)mockedMethodInvocation, mockedConfigDef));
    }

    @Test
    public void invalidPolicy() throws Exception {
        MethodInvocation mockedMethodInvocation = this.createMethodInvoation("myTestMethod", NodeRef.class);
        net.sf.acegisecurity.ConfigAttributeDefinition mockedConfigDef = this.createConfigDefinition("RM.invalid");
        this.exception.expect(AlfrescoRuntimeException.class);
        this.entryVoter.vote(this.mockedAuthentication, (Object)mockedMethodInvocation, mockedConfigDef);
    }

    @Test
    public void validPolicy() throws Exception {
        Mockito.when((Object)this.mockedPolicy.getName()).thenReturn((Object)POLICY_NAME);
        this.entryVoter.registerPolicy(this.mockedPolicy);
        MethodInvocation mockedMethodInvocation = this.createMethodInvoation("myTestMethod", NodeRef.class);
        net.sf.acegisecurity.ConfigAttributeDefinition mockedConfigDef = this.createConfigDefinition("RM.myPolicy");
        this.entryVoter.vote(this.mockedAuthentication, (Object)mockedMethodInvocation, mockedConfigDef);
        ((Policy)Mockito.verify((Object)this.mockedPolicy, (VerificationMode)Mockito.times((int)1))).evaluate((MethodInvocation)Matchers.eq((Object)mockedMethodInvocation), (Class[])Matchers.any(Class[].class), (ConfigAttributeDefinition)Matchers.any(ConfigAttributeDefinition.class));
    }

    private net.sf.acegisecurity.ConfigAttributeDefinition createConfigDefinition(String value) {
        net.sf.acegisecurity.ConfigAttributeDefinition mockedConfig = (net.sf.acegisecurity.ConfigAttributeDefinition)Mockito.mock(net.sf.acegisecurity.ConfigAttributeDefinition.class);
        ConfigAttribute mockedConfigAttr = (ConfigAttribute)Mockito.mock(ConfigAttribute.class);
        Mockito.when((Object)mockedConfigAttr.getAttribute()).thenReturn((Object)value);
        Iterator mockedIter = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)mockedIter.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when(mockedIter.next()).thenReturn((Object)mockedConfigAttr);
        Mockito.when((Object)mockedConfig.getConfigAttributes()).thenReturn((Object)mockedIter);
        return mockedConfig;
    }

    private MethodInvocation createMethodInvoation(String methodName, Class<?> ... parameterTypes) throws Exception {
        MethodInvocation mockedMethodInvocation = (MethodInvocation)Mockito.mock(MethodInvocation.class);
        Method method = RMEntryVoterUnitTest.class.getMethod(methodName, parameterTypes);
        Mockito.when((Object)mockedMethodInvocation.getMethod()).thenReturn((Object)method);
        return mockedMethodInvocation;
    }

    public void myTestMethod(NodeRef nodeRef) {
    }
}

