/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v33;

import org.alfresco.module.org_alfresco_module_rm.patch.v33.RMv33HoldAuditEntryValuesPatch;
import org.alfresco.module.org_alfresco_module_rm.query.RecordsManagementQueryDAO;
import org.alfresco.repo.domain.propval.PropertyStringValueEntity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class RMv33HoldAuditEntryValuesPatchUnitTest {
    @Mock
    private RecordsManagementQueryDAO mockedRecordsManagementQueryDAO;
    @InjectMocks
    private RMv33HoldAuditEntryValuesPatch patch;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void holdAuditEntriesAreUpdatedAfterUpgrade() {
        PropertyStringValueEntity addToHoldPropertyStringValueEntity = new PropertyStringValueEntity();
        addToHoldPropertyStringValueEntity.setValue("addToHold");
        Mockito.when((Object)this.mockedRecordsManagementQueryDAO.getPropertyStringValueEntity("addToHold")).thenReturn((Object)addToHoldPropertyStringValueEntity);
        Mockito.when((Object)this.mockedRecordsManagementQueryDAO.updatePropertyStringValueEntity(addToHoldPropertyStringValueEntity)).thenReturn((Object)1);
        PropertyStringValueEntity removeFromHoldPropertyStringValueEntity = new PropertyStringValueEntity();
        removeFromHoldPropertyStringValueEntity.setValue("removeFromHold");
        Mockito.when((Object)this.mockedRecordsManagementQueryDAO.getPropertyStringValueEntity("removeFromHold")).thenReturn((Object)removeFromHoldPropertyStringValueEntity);
        Mockito.when((Object)this.mockedRecordsManagementQueryDAO.updatePropertyStringValueEntity(removeFromHoldPropertyStringValueEntity)).thenReturn((Object)1);
        PropertyStringValueEntity deleteHoldPropertyStringValueEntity = new PropertyStringValueEntity();
        deleteHoldPropertyStringValueEntity.setValue("deleteHold");
        Mockito.when((Object)this.mockedRecordsManagementQueryDAO.getPropertyStringValueEntity("deleteHold")).thenReturn((Object)deleteHoldPropertyStringValueEntity);
        Mockito.when((Object)this.mockedRecordsManagementQueryDAO.updatePropertyStringValueEntity(deleteHoldPropertyStringValueEntity)).thenReturn((Object)1);
        this.patch.applyInternal();
        ((RecordsManagementQueryDAO)Mockito.verify((Object)this.mockedRecordsManagementQueryDAO, (VerificationMode)Mockito.times((int)1))).getPropertyStringValueEntity("addToHold");
        ((RecordsManagementQueryDAO)Mockito.verify((Object)this.mockedRecordsManagementQueryDAO, (VerificationMode)Mockito.times((int)1))).updatePropertyStringValueEntity(addToHoldPropertyStringValueEntity);
        ((RecordsManagementQueryDAO)Mockito.verify((Object)this.mockedRecordsManagementQueryDAO, (VerificationMode)Mockito.times((int)1))).getPropertyStringValueEntity("removeFromHold");
        ((RecordsManagementQueryDAO)Mockito.verify((Object)this.mockedRecordsManagementQueryDAO, (VerificationMode)Mockito.times((int)1))).updatePropertyStringValueEntity(removeFromHoldPropertyStringValueEntity);
        ((RecordsManagementQueryDAO)Mockito.verify((Object)this.mockedRecordsManagementQueryDAO, (VerificationMode)Mockito.times((int)1))).getPropertyStringValueEntity("deleteHold");
        ((RecordsManagementQueryDAO)Mockito.verify((Object)this.mockedRecordsManagementQueryDAO, (VerificationMode)Mockito.times((int)1))).updatePropertyStringValueEntity(deleteHoldPropertyStringValueEntity);
        Assert.assertEquals((Object)"Add To Hold", (Object)addToHoldPropertyStringValueEntity.getStringValue());
        Assert.assertEquals((Object)"add to hold", (Object)addToHoldPropertyStringValueEntity.getStringEndLower());
        Assert.assertEquals((Object)770786109L, (Object)addToHoldPropertyStringValueEntity.getStringCrc());
        Assert.assertEquals((Object)"Remove From Hold", (Object)removeFromHoldPropertyStringValueEntity.getStringValue());
        Assert.assertEquals((Object)"remove from hold", (Object)removeFromHoldPropertyStringValueEntity.getStringEndLower());
        Assert.assertEquals((Object)2967613012L, (Object)removeFromHoldPropertyStringValueEntity.getStringCrc());
        Assert.assertEquals((Object)"Delete Hold", (Object)deleteHoldPropertyStringValueEntity.getStringValue());
        Assert.assertEquals((Object)"delete hold", (Object)deleteHoldPropertyStringValueEntity.getStringEndLower());
        Assert.assertEquals((Object)132640810L, (Object)deleteHoldPropertyStringValueEntity.getStringCrc());
    }

    @Test
    public void patchRunWithSuccessWhenNoHoldEntries() {
        Mockito.when((Object)this.mockedRecordsManagementQueryDAO.getPropertyStringValueEntity("addToHold")).thenReturn(null);
        Mockito.when((Object)this.mockedRecordsManagementQueryDAO.getPropertyStringValueEntity("removeFromHold")).thenReturn(null);
        Mockito.when((Object)this.mockedRecordsManagementQueryDAO.getPropertyStringValueEntity("deleteHold")).thenReturn(null);
        this.patch.applyInternal();
        ((RecordsManagementQueryDAO)Mockito.verify((Object)this.mockedRecordsManagementQueryDAO, (VerificationMode)Mockito.times((int)1))).getPropertyStringValueEntity("addToHold");
        ((RecordsManagementQueryDAO)Mockito.verify((Object)this.mockedRecordsManagementQueryDAO, (VerificationMode)Mockito.times((int)1))).getPropertyStringValueEntity("removeFromHold");
        ((RecordsManagementQueryDAO)Mockito.verify((Object)this.mockedRecordsManagementQueryDAO, (VerificationMode)Mockito.times((int)1))).getPropertyStringValueEntity("deleteHold");
        ((RecordsManagementQueryDAO)Mockito.verify((Object)this.mockedRecordsManagementQueryDAO, (VerificationMode)Mockito.times((int)0))).updatePropertyStringValueEntity((PropertyStringValueEntity)Matchers.any());
    }
}

