/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.jscript;

import java.io.Serializable;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.jscript.app.JSONConversionComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONConversionComponentTest
extends BaseRMTestCase {
    protected JSONConversionComponent converter;
    protected NodeRef record;

    @Override
    protected void initServices() {
        super.initServices();
        this.converter = (JSONConversionComponent)this.applicationContext.getBean("jsonConversionComponent");
    }

    @Override
    protected void setupTestDataImpl() {
        super.setupTestDataImpl();
        this.record = this.utils.createRecord(this.rmFolder, "testRecord.txt");
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testJSON() throws Exception {
        this.doTestInTransaction(new JSONTest(this.filePlan, new String[][]{{"isRmNode", "true", "boolean"}, {"rmNode.kind", "FILE_PLAN"}}){});
        this.doTestInTransaction(new JSONTest(this.rmContainer, new String[][]{{"isRmNode", "true", "boolean"}, {"rmNode.kind", "RECORD_CATEGORY"}}){});
        this.doTestInTransaction(new JSONTest(this.rmFolder, new String[][]{{"isRmNode", "true", "boolean"}, {"rmNode.kind", "RECORD_FOLDER"}}){});
        this.doTestInTransaction(new JSONTest(this.record, new String[][]{{"isRmNode", "true", "boolean"}, {"rmNode.kind", "RECORD"}}){});
    }

    class JSONTest
    extends RetryingTransactionHelperTestCase.Test<JSONObject> {
        private NodeRef nodeRef;
        private String[][] testValues;

        public JSONTest(NodeRef nodeRef, String[] ... testValues) {
            super((RetryingTransactionHelperTestCase)JSONConversionComponentTest.this);
            this.nodeRef = nodeRef;
            this.testValues = testValues;
        }

        public JSONObject run() throws Exception {
            String json = JSONConversionComponentTest.this.converter.toJSON(this.nodeRef, true);
            return new JSONObject(json);
        }

        public void test(JSONObject result) throws Exception {
            for (String[] testValue : this.testValues) {
                String key = testValue[0];
                String type = "string";
                if (testValue.length == 3) {
                    type = testValue[2];
                }
                Serializable value = this.convertValue(testValue[1], type);
                Serializable actualValue = (Serializable)this.getValue(result, key);
                TestCase.assertEquals((String)("The key " + key + " did not have the expected value."), (Object)value, (Object)actualValue);
            }
        }

        private Serializable convertValue(String stringValue, String type) {
            Object value = stringValue;
            if (type.equals("boolean")) {
                value = new Boolean(stringValue);
            }
            return value;
        }

        private Object getValue(JSONObject jsonObject, String key) throws JSONException {
            return this.getValue(jsonObject, key.split("\\."));
        }

        private Object getValue(JSONObject jsonObject, String[] key) throws JSONException {
            if (key.length == 1) {
                return jsonObject.get(key[0]);
            }
            return this.getValue(jsonObject.getJSONObject(key[0]), (String[])ArrayUtils.subarray((Object[])key, (int)1, (int)key.length));
        }
    }
}

