/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util;

import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.util.NodeTypeUtility;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class NodeTypeUtilityUnitTest {
    @InjectMocks
    private NodeTypeUtility nodeTypeUtility;
    @Mock
    private DictionaryService mockedDictionaryService;
    private QName type;
    private QName ofType;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.type = AlfMock.generateQName();
        this.ofType = AlfMock.generateQName();
    }

    @Test
    public void testNotInstanceOf() {
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(this.type, this.ofType)).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.nodeTypeUtility.instanceOf(this.type, this.ofType));
    }

    @Test
    public void testIsInstanceOf() {
        Mockito.when((Object)this.mockedDictionaryService.isSubClass(this.type, this.ofType)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.nodeTypeUtility.instanceOf(this.type, this.ofType));
    }

    @Test
    public void testInstanceOfCacheSameTypes() {
        this.nodeTypeUtility.instanceOf(this.type, this.ofType);
        this.nodeTypeUtility.instanceOf(this.type, this.ofType);
        ((DictionaryService)Mockito.verify((Object)this.mockedDictionaryService, (VerificationMode)Mockito.times((int)1))).isSubClass((QName)Matchers.any(), (QName)Matchers.any());
    }

    @Test
    public void testInstanceOfDifferentTypes() {
        QName anotherType = AlfMock.generateQName();
        this.nodeTypeUtility.instanceOf(this.type, this.ofType);
        this.nodeTypeUtility.instanceOf(anotherType, this.ofType);
        ((DictionaryService)Mockito.verify((Object)this.mockedDictionaryService, (VerificationMode)Mockito.times((int)2))).isSubClass((QName)Matchers.any(), (QName)Matchers.any());
    }

    @Test
    public void testTypesAreEqual() {
        Assert.assertTrue((boolean)this.nodeTypeUtility.instanceOf(this.type, this.type));
        ((DictionaryService)Mockito.verify((Object)this.mockedDictionaryService, (VerificationMode)Mockito.times((int)0))).isSubClass((QName)Matchers.any(), (QName)Matchers.any());
    }
}

