/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.surf.util.I18NUtil;

public class EditDispositionActionAsOfDateAction
extends RMActionExecuterAbstractBase {
    private static final String MSG_VALID_DATE_DISP_ASOF = "rm.action.valid-date-disp-asof";
    private static final String MSG_DISP_ASOF_LIFECYCLE_APPLIED = "rm.action.disp-asof-lifecycle-applied";
    public static final String NAME = "editDispositionActionAsOfDate";
    public static final String PARAM_AS_OF_DATE = "asOfDate";

    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (this.getNodeService().hasAspect(actionedUponNodeRef, ASPECT_DISPOSITION_LIFECYCLE)) {
            Date asOfDate = (Date)action.getParameterValue(PARAM_AS_OF_DATE);
            if (asOfDate == null) {
                throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_VALID_DATE_DISP_ASOF));
            }
            DispositionAction da = this.getDispositionService().getNextDispositionAction(actionedUponNodeRef);
            if (da != null) {
                this.getNodeService().setProperty(da.getNodeRef(), PROP_DISPOSITION_AS_OF, (Serializable)asOfDate);
                this.getNodeService().setProperty(da.getNodeRef(), PROP_MANUALLY_SET_AS_OF, (Serializable)Boolean.valueOf(true));
            }
        } else {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_DISP_ASOF_LIFECYCLE_APPLIED));
        }
    }
}

