/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.admin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEvent;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEventService;
import org.alfresco.module.org_alfresco_module_rm.script.admin.RMEventBase;
import org.alfresco.util.ParameterCheck;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class RmEventPut
extends RMEventBase {
    public static final String PARAM_EVENTNAME = "eventname";
    private RecordsManagementEventService rmEventService;

    public void setRecordsManagementEventService(RecordsManagementEventService rmEventService) {
        this.rmEventService = rmEventService;
    }

    public Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        ParameterCheck.mandatory((String)"req", (Object)req);
        HashMap<String, Object> model = new HashMap<String, Object>();
        JSONObject json = null;
        try {
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            Map templateVars = req.getServiceMatch().getTemplateVars();
            String eventName = (String)templateVars.get(PARAM_EVENTNAME);
            if (eventName == null || eventName.isEmpty() || !this.rmEventService.existsEvent(eventName)) {
                throw new WebScriptException(404, "No event name was provided.");
            }
            String eventDisplayLabel = this.getValue(json, "eventDisplayLabel");
            this.doCheck(eventDisplayLabel, "No event display label was provided.");
            String eventType = this.getValue(json, "eventType");
            this.doCheck(eventType, "No event type was provided.");
            RecordsManagementEvent event = null;
            event = this.canEditEvent(eventDisplayLabel, eventName, eventType) ? this.rmEventService.addEvent(eventType, eventName, eventDisplayLabel) : this.rmEventService.getEvent(eventName);
            model.put("event", event);
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        return model;
    }

    private boolean canEditEvent(String eventDisplayLabel, String eventName, String eventType) {
        boolean canEditEvent;
        try {
            canEditEvent = this.rmEventService.canEditEvent(eventDisplayLabel, eventName, eventType);
        }
        catch (AlfrescoRuntimeException are) {
            throw new WebScriptException(400, are.getLocalizedMessage(), (Throwable)are);
        }
        return canEditEvent;
    }
}

