/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v20;

import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.patch.compatibility.ModulePatchComponent;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.springframework.beans.factory.BeanNameAware;

public class RMv2ModelPatch
extends ModulePatchComponent
implements BeanNameAware,
RecordsManagementModel,
DOD5015Model {
    private static final long BATCH_SIZE = 100000L;
    private PatchDAO patchDAO;
    private NodeDAO nodeDAO;
    private QNameDAO qnameDAO;

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    @Override
    protected void executePatch() {
        this.updateQName(QName.createQName((String)"http://www.alfresco.org/model/dod5015/1.0", (String)"filePlan"), TYPE_FILE_PLAN, "TYPE");
        this.updateQName(QName.createQName((String)"http://www.alfresco.org/model/dod5015/1.0", (String)"recordCategory"), TYPE_RECORD_CATEGORY, "TYPE");
        this.updateQName(QName.createQName((String)"http://www.alfresco.org/model/dod5015/1.0", (String)"ghosted"), ASPECT_GHOSTED, "ASPECT");
    }

    private void updateQName(QName qnameBefore, QName qnameAfter, String reindexClass) {
        Work work = new Work(qnameBefore, qnameAfter, reindexClass);
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work, false, true);
    }

    private class Work
    implements RetryingTransactionHelper.RetryingTransactionCallback<Integer> {
        private QName qnameBefore;
        private QName qnameAfter;
        private String reindexClass;

        Work(QName qnameBefore, QName qnameAfter, String reindexClass) {
            this.qnameBefore = qnameBefore;
            this.qnameAfter = qnameAfter;
            this.reindexClass = reindexClass;
        }

        public Integer execute() throws Throwable {
            Long maxNodeId = RMv2ModelPatch.this.patchDAO.getMaxAdmNodeID();
            Pair before = RMv2ModelPatch.this.qnameDAO.getQName(this.qnameBefore);
            if (before != null) {
                Long i = 0L;
                while (i < maxNodeId) {
                    List nodeIds;
                    if ("TYPE".equals(this.reindexClass)) {
                        nodeIds = RMv2ModelPatch.this.patchDAO.getNodesByTypeQNameId((Long)before.getFirst(), i, Long.valueOf(i + 100000L));
                        RMv2ModelPatch.this.nodeDAO.touchNodes(RMv2ModelPatch.this.nodeDAO.getCurrentTransactionId(true), nodeIds);
                    } else if ("ASPECT".equals(this.reindexClass)) {
                        nodeIds = RMv2ModelPatch.this.patchDAO.getNodesByAspectQNameId((Long)before.getFirst(), i, Long.valueOf(i + 100000L));
                        RMv2ModelPatch.this.nodeDAO.touchNodes(RMv2ModelPatch.this.nodeDAO.getCurrentTransactionId(true), nodeIds);
                    }
                    i = i + 100000L;
                }
                RMv2ModelPatch.this.qnameDAO.updateQName(this.qnameBefore, this.qnameAfter);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(" ... updated qname " + this.qnameBefore.toString());
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" ... no need to update qname " + this.qnameBefore.toString());
            }
            return 0;
        }
    }
}

