/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.relationship.Relationship;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDefinition;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipDisplayName;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipType;
import org.alfresco.module.org_alfresco_module_rm.script.AbstractRmWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CustomRefsGet
extends AbstractRmWebScript {
    private static final String REFERENCE_TYPE = "referenceType";
    private static final String REF_ID = "refId";
    private static final String LABEL = "label";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String PARENT_REF = "parentRef";
    private static final String CHILD_REF = "childRef";
    private static final String SOURCE_REF = "sourceRef";
    private static final String TARGET_REF = "targetRef";
    private static final String CUSTOM_REFS_FROM = "customRefsFrom";
    private static final String CUSTOM_REFS_TO = "customRefsTo";
    private static final String NODE_NAME = "nodeName";
    private static final String NODE_TITLE = "nodeTitle";
    private RelationshipService relationshipService;
    private CapabilityService capabilityService;

    protected RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipService = relationshipService;
    }

    protected CapabilityService getCapabilityService() {
        return this.capabilityService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(4);
        NodeRef nodeRef = this.parseRequestForNodeRef(req);
        model.put(NODE_NAME, this.getNodeService().getProperty(nodeRef, ContentModel.PROP_NAME));
        model.put(NODE_TITLE, this.getNodeService().getProperty(nodeRef, ContentModel.PROP_TITLE));
        model.put(CUSTOM_REFS_FROM, this.getOutwardReferences(nodeRef));
        model.put(CUSTOM_REFS_TO, this.getInwardReferenceData(nodeRef));
        return model;
    }

    private List<Map<String, String>> getOutwardReferences(NodeRef nodeRef) {
        ArrayList<Map<String, String>> outwardReferenceData = new ArrayList<Map<String, String>>();
        Set<Relationship> relationships = this.getRelationshipService().getRelationshipsFrom(nodeRef);
        outwardReferenceData.addAll(this.getRelationshipData(relationships));
        return outwardReferenceData;
    }

    private List<Map<String, String>> getInwardReferenceData(NodeRef nodeRef) {
        ArrayList<Map<String, String>> inwardReferenceData = new ArrayList<Map<String, String>>();
        Set<Relationship> relationships = this.getRelationshipService().getRelationshipsTo(nodeRef);
        inwardReferenceData.addAll(this.getRelationshipData(relationships));
        return inwardReferenceData;
    }

    private List<Map<String, String>> getRelationshipData(Set<Relationship> relationships) {
        ArrayList<Map<String, String>> relationshipData = new ArrayList<Map<String, String>>();
        for (Relationship relationship : relationships) {
            String uniqueName = relationship.getUniqueName();
            RelationshipDefinition relationshipDefinition = this.getRelationshipService().getRelationshipDefinition(uniqueName);
            NodeRef source = relationship.getSource();
            NodeRef target = relationship.getTarget();
            if (relationshipDefinition == null || !this.hasView(source) || !this.hasView(target)) continue;
            HashMap<String, String> data = new HashMap<String, String>();
            RelationshipType type = relationshipDefinition.getType();
            RelationshipDisplayName displayName = relationshipDefinition.getDisplayName();
            if (RelationshipType.BIDIRECTIONAL.equals((Object)type)) {
                data.put(LABEL, displayName.getSourceText());
                data.put(SOURCE_REF, source.toString());
                data.put(TARGET_REF, target.toString());
            } else if (RelationshipType.PARENTCHILD.equals((Object)type)) {
                data.put(SOURCE, displayName.getSourceText());
                data.put(TARGET, displayName.getTargetText());
                data.put(PARENT_REF, source.toString());
                data.put(CHILD_REF, target.toString());
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("Unsupported relationship type '").append((Object)type).append("'.");
                throw new WebScriptException(400, sb.toString());
            }
            data.put(REFERENCE_TYPE, type.toString().toLowerCase());
            data.put(REF_ID, uniqueName);
            relationshipData.add(data);
        }
        return relationshipData;
    }

    private boolean hasView(NodeRef nodeRef) {
        boolean result = false;
        Capability viewRecordCapability = this.getCapabilityService().getCapability("ViewRecords");
        if (AccessStatus.ALLOWED.equals((Object)viewRecordCapability.hasPermission(nodeRef))) {
            result = true;
        }
        return result;
    }
}

