/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.job;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.job.RecordsManagementJobExecuter;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispositionLifecycleJobExecuter
extends RecordsManagementJobExecuter {
    private static final Logger log = LoggerFactory.getLogger(DispositionLifecycleJobExecuter.class);
    private int batchSize;
    public static final int DEFAULT_BATCH_SIZE = 500;
    private List<String> dispositionActions;
    private String query;
    private RecordsManagementActionService recordsManagementActionService;
    private NodeService nodeService;
    private SearchService searchService;
    private PersonService personService;
    private FreezeService freezeService;

    public void setFreezeService(FreezeService freezeService) {
        this.freezeService = freezeService;
    }

    public void setDispositionActions(List<String> dispositionActions) {
        this.dispositionActions = dispositionActions;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setRecordsManagementActionService(RecordsManagementActionService recordsManagementActionService) {
        this.recordsManagementActionService = recordsManagementActionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    protected String getQuery() {
        if (this.query == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("TYPE:\"rma:dispositionAction\" AND ");
            sb.append("(@rma\\:dispositionAction:(");
            boolean bFirst = true;
            for (String dispositionAction : this.dispositionActions) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    sb.append(" OR ");
                }
                sb.append("\"").append(dispositionAction).append("\"");
            }
            sb.append("))");
            sb.append(" AND ISUNSET:\"rma:dispositionActionCompletedAt\" ");
            sb.append(" AND ( ");
            sb.append("@rma\\:dispositionEventsEligible:true ");
            sb.append("OR @rma\\:dispositionAsOf:[MIN TO NOW] ");
            sb.append(") ");
            this.query = sb.toString();
        }
        return this.query;
    }

    @Override
    public void executeImpl() {
        try {
            log.debug("Job Starting");
            if (this.dispositionActions == null || this.dispositionActions.isEmpty()) {
                log.debug("Job Finished as disposition action is empty");
                return;
            }
            boolean hasMore = true;
            int skipCount = 0;
            List<Object> resultNodes = new ArrayList();
            if (this.batchSize < 1) {
                log.debug("Invalid value for batch size: " + this.batchSize + " default value used instead.");
                this.batchSize = 500;
            }
            log.trace("Using batch size of " + this.batchSize);
            while (hasMore) {
                SearchParameters params = new SearchParameters();
                params.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
                params.setLanguage("fts-alfresco");
                params.setQuery(this.getQuery());
                params.setSkipCount(skipCount);
                params.setMaxItems(this.batchSize);
                ResultSet results = this.searchService.query(params);
                if (results != null) {
                    resultNodes = results.getNodeRefs().stream().filter(node -> this.nodeService.getPrimaryParent(node) == null ? !this.freezeService.isFrozenOrHasFrozenChildren((NodeRef)node) : !this.freezeService.isFrozenOrHasFrozenChildren(this.nodeService.getPrimaryParent(node).getParentRef())).collect(Collectors.toList());
                }
                hasMore = results.hasMore();
                skipCount += resultNodes.size();
                results.close();
                log.debug("Processing " + resultNodes.size() + " nodes");
                if (resultNodes.isEmpty()) continue;
                this.executeAction(resultNodes);
            }
            log.debug("Job Finished");
        }
        catch (AlfrescoRuntimeException exception) {
            log.debug(exception.getMessage());
        }
    }

    private void executeAction(List<NodeRef> actionNodes) {
        RetryingTransactionHelper.RetryingTransactionCallback processTranCB = () -> {
            for (NodeRef actionNode : actionNodes) {
                ChildAssociationRef parent;
                String dispAction;
                if (!this.nodeService.exists(actionNode) || (dispAction = (String)((Object)this.nodeService.getProperty(actionNode, PROP_DISPOSITION_ACTION))) == null || !this.dispositionActions.contains(dispAction) || !(parent = this.nodeService.getPrimaryParent(actionNode)).getTypeQName().equals((Object)ASSOC_NEXT_DISPOSITION_ACTION)) continue;
                Map<String, Serializable> props = Map.of("rm.no-error-check", false);
                try {
                    this.recordsManagementActionService.executeRecordsManagementAction(parent.getParentRef(), dispAction, props);
                    log.debug("Processed action: " + dispAction + "on" + String.valueOf(parent));
                }
                catch (AlfrescoRuntimeException exception) {
                    log.debug(exception.getMessage());
                }
            }
            return Boolean.TRUE;
        };
        this.retryingTransactionHelper.doInTransaction(processTranCB, false, true);
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

